/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.submodelRepository;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.basyx2.common.AssetServerKeyStoreDescriptor;
import de.iip_ecosphere.platform.support.aas.basyx2.common.Tools;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.common.BaSyxExceptionResolver;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security.RbacUtils;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.submodelRepository.SubmodelRepositoryTypeFilter;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.IOException;
import java.util.List;
import org.eclipse.digitaltwin.basyx.aasrepository.AasRepositoryFactory;
import org.eclipse.digitaltwin.basyx.aasrepository.backend.CrudAasRepositoryFactory;
import org.eclipse.digitaltwin.basyx.aasservice.AasServiceFactory;
import org.eclipse.digitaltwin.basyx.aasservice.backend.AasBackend;
import org.eclipse.digitaltwin.basyx.aasservice.backend.CrudAasServiceFactory;
import org.eclipse.digitaltwin.basyx.aasservice.backend.InMemoryAasBackend;
import org.eclipse.digitaltwin.basyx.core.filerepository.FileRepository;
import org.eclipse.digitaltwin.basyx.core.filerepository.InMemoryFileRepository;
import org.eclipse.digitaltwin.basyx.submodelrepository.SubmodelRepository;
import org.eclipse.digitaltwin.basyx.submodelrepository.backend.CrudSubmodelRepositoryFactory;
import org.eclipse.digitaltwin.basyx.submodelrepository.feature.authorization.AuthorizedSubmodelRepository;
import org.eclipse.digitaltwin.basyx.submodelrepository.feature.operation.delegation.HTTPOperationDelegation;
import org.eclipse.digitaltwin.basyx.submodelrepository.feature.operation.delegation.OperationDelegation;
import org.eclipse.digitaltwin.basyx.submodelrepository.feature.operation.delegation.OperationDelegationSubmodelRepository;
import org.eclipse.digitaltwin.basyx.submodelservice.InMemorySubmodelBackend;
import org.eclipse.digitaltwin.basyx.submodelservice.SubmodelServiceFactory;
import org.eclipse.digitaltwin.basyx.submodelservice.backend.CrudSubmodelServiceFactory;
import org.eclipse.digitaltwin.basyx.submodelservice.backend.SubmodelBackend;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.JdkClientHttpConnector;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.lang.Nullable;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
@Configuration
@ComponentScan(basePackages={"org.eclipse.digitaltwin.basyx", "de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security"}, excludeFilters={@ComponentScan.Filter(type=FilterType.CUSTOM, classes={SubmodelRepositoryTypeFilter.class})})
public class SubmodelRepositorySpringApp
implements WebMvcConfigurer {
    @Autowired(required=false)
    private AssetServerKeyStoreDescriptor kstore;
    @Autowired(required=false)
    private AuthenticationDescriptor authDesc;

    public static void main(String[] args) {
        SpringApplication.run(SubmodelRepositorySpringApp.class, (String[])args);
    }

    @Bean
    public OperationDelegation getOperationDelegation(ObjectMapper mapper) {
        return new HTTPOperationDelegation(this.createWebClient(mapper));
    }

    private WebClient createWebClient(ObjectMapper mapper) {
        KeyStoreDescriptor ksd;
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(configurer -> {
            configurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(mapper, new MimeType[0]));
            configurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(mapper, new MimeType[0]));
        }).build();
        WebClient.Builder builder = WebClient.builder().exchangeStrategies(strategies);
        if (this.kstore != null && (ksd = this.kstore.getDescriptor()).appliesToClient()) {
            try {
                JdkClientHttpConnector httpConnector = new JdkClientHttpConnector(Tools.createHttpClient((KeyStoreDescriptor)ksd).build());
                builder = builder.clientConnector((ClientHttpConnector)httpConnector);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(SubmodelRepositorySpringApp.class).error("While creating WebClient for SubmodelRepository, staying with https: {}", (Object)e.getMessage());
            }
        }
        if (null != this.authDesc) {
            WebClient.Builder b = builder;
            AuthenticationDescriptor.authenticate((n, v) -> b.defaultHeader(n, new String[]{v}), (AuthenticationDescriptor)this.authDesc);
        }
        return builder.build();
    }

    @Bean
    public static SubmodelRepository getSubmodelRepository(OperationDelegation operationDelegation, @Nullable AuthenticationDescriptor authDesc) {
        SubmodelRepository result = CrudSubmodelRepositoryFactory.builder().backend((SubmodelBackend)new InMemorySubmodelBackend()).fileRepository((FileRepository)new InMemoryFileRepository()).create();
        result = new OperationDelegationSubmodelRepository(result, operationDelegation);
        if (AuthenticationDescriptor.definesRbac((AuthenticationDescriptor)authDesc)) {
            result = new AuthorizedSubmodelRepository(result, RbacUtils.createSubmodelPermissionResolver(authDesc));
        }
        return result;
    }

    @Bean
    public static AasBackend getAasBackend() {
        return new InMemoryAasBackend();
    }

    @Bean
    public static FileRepository getFileRepository() {
        return new InMemoryFileRepository();
    }

    @Bean
    public AasRepositoryFactory aasRepositoryFactory() {
        return new CrudAasRepositoryFactory((AasBackend)new InMemoryAasBackend(), (AasServiceFactory)new CrudAasServiceFactory((AasBackend)new InMemoryAasBackend(), (FileRepository)new InMemoryFileRepository()), "");
    }

    @Bean
    @Lazy
    public SubmodelServiceFactory getSubmodelServiceFactory() {
        return new CrudSubmodelServiceFactory((SubmodelBackend)new InMemorySubmodelBackend(), (FileRepository)new InMemoryFileRepository());
    }

    @Profile(value={"test"})
    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll()).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
        resolvers.add(0, new BaSyxExceptionResolver());
    }
}

