/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx2.common.AssetServerKeyStoreDescriptor;
import de.iip_ecosphere.platform.support.aas.basyx2.server.BaSyxDeploymentRecipe;
import de.iip_ecosphere.platform.support.function.IORunnable;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

abstract class BaSyxAbstractAasServer
implements AasServer {
    private static final boolean DEBUG = false;
    private SetupSpec spec;
    private ServerType type;
    private ConfigurableApplicationContext aasRepoCtx;
    private ConfigurableApplicationContext smRepoCtx;
    private ConfigurableApplicationContext aasRegistryCtx;
    private ConfigurableApplicationContext smRegistryCtx;
    private List<IORunnable> actionsAfterStart;

    BaSyxAbstractAasServer(SetupSpec spec, ServerType type, String ... options) {
        this.spec = spec;
        this.type = type;
    }

    public BaSyxAbstractAasServer addActionsAfterStart(List<IORunnable> actions) {
        if (null == this.actionsAfterStart) {
            this.actionsAfterStart = new ArrayList<IORunnable>();
        }
        this.actionsAfterStart.addAll(actions);
        return this;
    }

    protected abstract Class<?> getAasRepositoryAppClass();

    protected ApplicationContextInitializer<ConfigurableApplicationContext> getAasRepositoryAppInitializer() {
        return null;
    }

    protected abstract Class<?> getSmRepositoryAppClass();

    protected ApplicationContextInitializer<ConfigurableApplicationContext> getSmRepositoryAppInitializer() {
        return null;
    }

    protected abstract Class<?> getAasRegistryAppClass();

    protected ApplicationContextInitializer<ConfigurableApplicationContext> getAasRegistryAppInitializer() {
        return null;
    }

    protected abstract Class<?> getSmRegistryAppClass();

    protected ApplicationContextInitializer<ConfigurableApplicationContext> getSmRegistryAppInitializer() {
        return null;
    }

    protected static ConfigurableApplicationContext createContext(Class<?> cls, int port) {
        return BaSyxAbstractAasServer.createContext(cls, port, null);
    }

    protected static ConfigurableApplicationContext createContext(Class<?> cls, int port, AppConfigurer configurer) {
        return BaSyxAbstractAasServer.createContext(cls, port, configurer, null);
    }

    static AppConfigurer createConfigurer() {
        return BaSyxAbstractAasServer.createConfigurer(null, null);
    }

    static AppConfigurer createConfigurer(SetupSpec.ComponentSetup setup) {
        return BaSyxAbstractAasServer.createConfigurer(null, setup);
    }

    static AppConfigurer createConfigurer(ApplicationContextInitializer<ConfigurableApplicationContext> initializer) {
        return BaSyxAbstractAasServer.createConfigurer(initializer, null);
    }

    static AppConfigurer createConfigurer(ApplicationContextInitializer<ConfigurableApplicationContext> initializer, SetupSpec.ComponentSetup setup) {
        AppConfigurer result = new AppConfigurer().addInitializer(initializer);
        if (null != setup) {
            result.addKeystore(setup.getKeyStore());
            result.addAuthenticaton(setup.getAuthentication());
        }
        if (BaSyxAbstractAasServer.isJUnitTest()) {
            result.addTestingProfile();
        } else {
            result.setBasyxAuthorization(false);
        }
        return result;
    }

    public static boolean isJUnitTest() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    protected static ConfigurableApplicationContext createContext(Class<?> cls, int port, AppConfigurer configurer, Consumer<SetupSpec.State> stateConsumer) {
        ConfigurableApplicationContext result = null;
        if (null != cls) {
            String pluginId = "aas.basyx-2.0-server";
            if (null == PluginManager.getPlugin((String)pluginId)) {
                pluginId = "aas.basyx-2.0";
            }
            ClassLoader pLoader = PluginManager.getPluginLoader((String)pluginId);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(pLoader);
            if (null == configurer) {
                configurer = BaSyxAbstractAasServer.createConfigurer();
            }
            LoggerFactory.getLogger(BaSyxAbstractAasServer.class).info("Starting {} on port {}", (Object)cls.getSimpleName(), (Object)port);
            SpringApplication app = new SpringApplication(new Class[]{cls});
            if (null != configurer) {
                configurer.configure(app);
            }
            configurer.addPort(port);
            configurer.addConfigName(cls.getSimpleName());
            configurer.addArg("spring.http.client.factory", "reactor");
            result = app.run(null == configurer ? new String[]{} : configurer.getArgs());
            if (null != stateConsumer) {
                stateConsumer.accept(SetupSpec.State.RUNNING);
            }
            Thread.currentThread().setContextClassLoader(cl);
        }
        return result;
    }

    public void deploy(Aas aas) throws IOException {
        BaSyxDeploymentRecipe.deploy(this.spec, aas);
    }

    public void deploy(Aas aas, Submodel submodel) throws IOException {
        Registry registry = AasFactory.getInstance().obtainRegistry(this.spec);
        registry.createAas(aas, "");
        registry.createSubmodel(aas, submodel);
        registry.register(aas, submodel, "");
    }

    static boolean shallStart(SetupSpec.State state) {
        return state == SetupSpec.State.STOPPED;
    }

    public AasServer start() {
        if (this.type == ServerType.COMBINED || this.type == ServerType.REPOSITORY) {
            if (BaSyxAbstractAasServer.shallStart(this.spec.getAasRepositoryState())) {
                this.aasRepoCtx = BaSyxAbstractAasServer.createContext(this.getAasRepositoryAppClass(), this.spec.getAasRepositoryEndpoint().getPort(), BaSyxAbstractAasServer.createConfigurer(this.getAasRepositoryAppInitializer(), this.spec.getSetup(SetupSpec.AasComponent.AAS_REPOSITORY)), s -> this.spec.notifyAasRepositoryStateChange(s));
            }
            if (BaSyxAbstractAasServer.shallStart(this.spec.getSubmodelRepositoryState())) {
                this.smRepoCtx = BaSyxAbstractAasServer.createContext(this.getSmRepositoryAppClass(), this.spec.getSubmodelRepositoryEndpoint().getPort(), BaSyxAbstractAasServer.createConfigurer(this.getSmRepositoryAppInitializer(), this.spec.getSetup(SetupSpec.AasComponent.SUBMODEL_REPOSITORY)), s -> this.spec.notifySubmodelRepositoryStateChange(s));
            }
        }
        if (this.type == ServerType.COMBINED && !this.spec.areRegistriesRunning() || this.type == ServerType.REGISTRY) {
            if (BaSyxAbstractAasServer.shallStart(this.spec.getAasRegistryState())) {
                this.aasRegistryCtx = BaSyxAbstractAasServer.createContext(this.getAasRegistryAppClass(), this.spec.getAasRegistryEndpoint().getPort(), BaSyxAbstractAasServer.createConfigurer(this.getAasRegistryAppInitializer(), this.spec.getSetup(SetupSpec.AasComponent.AAS_REGISTRY)), s -> this.spec.notifyAasRegistryStateChange(s));
            }
            if (BaSyxAbstractAasServer.shallStart(this.spec.getSubmodelRegistryState())) {
                this.smRegistryCtx = BaSyxAbstractAasServer.createContext(this.getSmRegistryAppClass(), this.spec.getSubmodelRegistryEndpoint().getPort(), BaSyxAbstractAasServer.createConfigurer(this.getSmRegistryAppInitializer(), this.spec.getSetup(SetupSpec.AasComponent.SUBMODEL_REGISTRY)).addAssetServerKeystore(this.spec.getAssetServerKeyStore()), s -> this.spec.notifySubmodelRegistryStateChange(s));
                this.spec.notifySubmodelRegistryStateChange(SetupSpec.State.RUNNING);
            }
        }
        if (null != this.actionsAfterStart) {
            for (IORunnable a : this.actionsAfterStart) {
                try {
                    a.run();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(BaSyxAbstractAasServer.class).error("Cannot execute start action: {}", (Object)e.getMessage());
                }
            }
        }
        return this;
    }

    static void close(ConfigurableApplicationContext ctx, Consumer<SetupSpec.State> stateConsumer) {
        if (null != ctx) {
            LoggerFactory.getLogger(BaSyxAbstractAasServer.class).info("Stopping context {}", (Object)ctx.getDisplayName());
            ctx.close();
            if (null != stateConsumer) {
                stateConsumer.accept(SetupSpec.State.STOPPED);
            }
        }
    }

    public void stop(boolean dispose) {
        BaSyxAbstractAasServer.close(this.aasRepoCtx, s -> this.spec.notifyAasRepositoryStateChange(s));
        BaSyxAbstractAasServer.close(this.smRepoCtx, s -> this.spec.notifySubmodelRepositoryStateChange(s));
        BaSyxAbstractAasServer.close(this.aasRegistryCtx, s -> this.spec.notifyAasRegistryStateChange(s));
        BaSyxAbstractAasServer.close(this.smRegistryCtx, s -> this.spec.notifySubmodelRegistryStateChange(s));
    }

    public static enum ServerType {
        REGISTRY,
        REPOSITORY,
        COMBINED;

    }

    protected static class AppConfigurer {
        private List<String> args = new ArrayList<String>();
        private List<String> profiles = new ArrayList<String>();
        private List<ApplicationContextInitializer<ConfigurableApplicationContext>> initializers = new ArrayList<ApplicationContextInitializer<ConfigurableApplicationContext>>();

        protected AppConfigurer() {
        }

        public AppConfigurer addInitializer(ApplicationContextInitializer<ConfigurableApplicationContext> initializer) {
            if (null != initializer) {
                this.initializers.add(initializer);
            }
            return this;
        }

        public <T> AppConfigurer addBeanRegistrationInitializer(final Class<T> cls, final T instance) {
            if (null != instance) {
                this.addInitializer(new ApplicationContextInitializer<ConfigurableApplicationContext>(){

                    public void initialize(ConfigurableApplicationContext applicationContext) {
                        applicationContext.getBeanFactory().registerSingleton(cls.getCanonicalName(), instance);
                    }
                });
            }
            return this;
        }

        public AppConfigurer addPort(int port) {
            this.args.add("--server.port=" + port);
            return this;
        }

        public AppConfigurer addConfigName(String name) {
            this.args.add("--spring.config.name=" + name);
            return this;
        }

        public AppConfigurer addDebugging() {
            this.args.add("--debug");
            return this;
        }

        public AppConfigurer addJavaSslDebugging() {
            System.setProperty("javax.net.debug", "ssl:handshake");
            return this;
        }

        public AppConfigurer addJavaHttpClientDebugging() {
            System.setProperty("jdk.httpclient.HttpClient.log", "all");
            System.setProperty("jdk.internal.httpclient.debug", "true");
            return this;
        }

        public AppConfigurer addArg(String name, String value) {
            this.args.add("--" + name + "=" + value);
            return this;
        }

        public AppConfigurer addArg(String arg) {
            this.args.add(arg);
            return this;
        }

        public AppConfigurer addWebStartupDebugging() {
            this.args.add("--logging.level.org.springframework.web=DEBUG");
            this.args.add("--logging.level.org.springframework.web.server.adapter.HttpWebHandlerAdapter=TRACE");
            this.args.add("--logging.level.org.springframework.web.reactive.function.client.ExchangeFunctions=trace");
            this.args.add("--spring.codec.log-request-details=true");
            this.args.add("--spring.mvc.log-request-details=true");
            return this;
        }

        public AppConfigurer addSpringSecurityDebugging() {
            this.args.add("--logging.level.org.springframework.security=DEBUG");
            return this;
        }

        public AppConfigurer setBasyxAuthorization(boolean enable) {
            this.args.add("--registry.authorization=" + (enable ? "Enabled" : "Disabled"));
            this.args.add("--basyx.feature.authorization.enabled=" + enable);
            return this;
        }

        public AppConfigurer addStartupBeanDebugging() {
            this.args.add("--logging.level.org.springframework.beans.factory=DEBUG");
            return this;
        }

        public AppConfigurer addAdditionalProfiles(String ... profiles) {
            for (String p : profiles) {
                if (null == p) continue;
                this.profiles.add(p);
            }
            return this;
        }

        public AppConfigurer addTestingProfile() {
            this.profiles.add("test");
            this.setBasyxAuthorization(false);
            return this;
        }

        public AppConfigurer addKeystore(KeyStoreDescriptor kstore) {
            return this.addBeanRegistrationInitializer(KeyStoreDescriptor.class, kstore);
        }

        public AppConfigurer addAssetServerKeystore(KeyStoreDescriptor kstore) {
            if (null != kstore) {
                this.addBeanRegistrationInitializer(AssetServerKeyStoreDescriptor.class, new AssetServerKeyStoreDescriptor(kstore));
            }
            return this;
        }

        public AppConfigurer addAuthenticaton(AuthenticationDescriptor auth) {
            return this.addBeanRegistrationInitializer(AuthenticationDescriptor.class, auth);
        }

        private void configure(SpringApplication app) {
            if (!this.profiles.isEmpty()) {
                app.setAdditionalProfiles(this.profiles.toArray(new String[this.profiles.size()]));
            }
            for (ApplicationContextInitializer<ConfigurableApplicationContext> i : this.initializers) {
                app.addInitializers(new ApplicationContextInitializer[]{i});
            }
        }

        private String[] getArgs() {
            return this.args.toArray(new String[this.args.size()]);
        }
    }
}

