/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.basyx2.server.BaSyxAbstractAasServer;
import de.iip_ecosphere.platform.support.aas.basyx2.server.BaSyxLocalServer;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;

public class BaSyxServerRecipe
implements ServerRecipe {
    public ServerRecipe.PersistenceType toPersistenceType(String type) {
        ServerRecipe.LocalPersistenceType result = ServerRecipe.LocalPersistenceType.INMEMORY;
        try {
            result = ServerRecipe.LocalPersistenceType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Persistence type '" + type + "' is unknown. Using " + String.valueOf(ServerRecipe.LocalPersistenceType.INMEMORY) + " as fallback.");
        }
        return result;
    }

    public AasServer createAasServer(SetupSpec spec, ServerRecipe.PersistenceType persistence, String ... options) {
        return new BaSyxLocalServer(spec, BaSyxAbstractAasServer.ServerType.REPOSITORY, persistence, options);
    }

    public Server createRegistryServer(SetupSpec spec, ServerRecipe.PersistenceType persistence, String ... options) {
        return new BaSyxLocalServer(spec, BaSyxAbstractAasServer.ServerType.REGISTRY, persistence, options);
    }

    public ServerRecipe setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        return this;
    }
}

