/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.aasRepository;

import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.aasRepository.AasRepositoryTypeFilter;
import de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security.RbacUtils;
import org.eclipse.digitaltwin.basyx.aasrepository.AasRepository;
import org.eclipse.digitaltwin.basyx.aasrepository.backend.CrudAasRepositoryFactory;
import org.eclipse.digitaltwin.basyx.aasrepository.feature.authorization.AuthorizedAasRepository;
import org.eclipse.digitaltwin.basyx.aasservice.AasServiceFactory;
import org.eclipse.digitaltwin.basyx.aasservice.backend.AasBackend;
import org.eclipse.digitaltwin.basyx.aasservice.backend.CrudAasServiceFactory;
import org.eclipse.digitaltwin.basyx.aasservice.backend.InMemoryAasBackend;
import org.eclipse.digitaltwin.basyx.core.filerepository.FileRepository;
import org.eclipse.digitaltwin.basyx.core.filerepository.InMemoryFileRepository;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Profile;
import org.springframework.lang.Nullable;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@SpringBootApplication
@Configuration
@ComponentScan(basePackages={"org.eclipse.digitaltwin.basyx", "de.iip_ecosphere.platform.support.aas.basyx2.server.apps.security"}, excludeFilters={@ComponentScan.Filter(type=FilterType.CUSTOM, classes={AasRepositoryTypeFilter.class})})
public class AasRepositorySpringApp {
    public static void main(String[] args) {
        SpringApplication.run(AasRepositorySpringApp.class, (String[])args);
    }

    @Bean
    public static AasRepository getAasRepository(@Nullable AuthenticationDescriptor authDesc) {
        InMemoryFileRepository fileRepository = new InMemoryFileRepository();
        AasRepository result = CrudAasRepositoryFactory.builder().backend((AasBackend)new InMemoryAasBackend()).fileRepository((FileRepository)fileRepository).create();
        if (AuthenticationDescriptor.definesRbac((AuthenticationDescriptor)authDesc)) {
            result = new AuthorizedAasRepository(result, RbacUtils.createAasPermissionResolver(authDesc));
        }
        return result;
    }

    @Bean
    public static AasServiceFactory getAasServiceFactory() {
        return new CrudAasServiceFactory((AasBackend)new InMemoryAasBackend(), (FileRepository)new InMemoryFileRepository());
    }

    @Bean
    public static AasBackend getAasBackend() {
        return new InMemoryAasBackend();
    }

    @Bean
    public static FileRepository getFileRepository() {
        return new InMemoryFileRepository();
    }

    @Profile(value={"test"})
    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll()).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }
}

