/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx2.server.apps.common;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Component
public class BaSyxExceptionResolver
implements HandlerExceptionResolver {
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (ex instanceof WebClientRequestException) {
            return this.resolve(response, 503, "External service temporarily unavailable: " + ex.getMessage());
        }
        return null;
    }

    private ModelAndView resolve(HttpServletResponse response, int status, String msg) {
        try {
            response.setStatus(status);
            response.getWriter().write(msg);
            response.getWriter().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ModelAndView();
    }
}

