/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.commons.apache;

import de.iip_ecosphere.platform.support.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testJava() {
        Assert.assertNull((Object)StringUtils.escapeJava(null));
        Assert.assertNull((Object)StringUtils.unescapeJava(null));
        Assert.assertEquals((Object)"\n", (Object)StringUtils.unescapeJava((String)StringUtils.escapeJava((String)"\n")));
    }

    @Test
    public void testJson() {
        Assert.assertNull((Object)StringUtils.escapeJson(null));
        Assert.assertNull((Object)StringUtils.unescapeJson(null));
        Assert.assertEquals((Object)"\t", (Object)StringUtils.unescapeJava((String)StringUtils.escapeJava((String)"\t")));
    }

    @Test
    public void testDefaults() {
        Assert.assertEquals((Object)"a", (Object)StringUtils.defaultIfBlank(null, (CharSequence)"a"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.defaultIfBlank((CharSequence)"", (CharSequence)"a"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.defaultIfBlank((CharSequence)"   ", (CharSequence)"a"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.defaultIfEmpty(null, (CharSequence)"a"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.defaultIfEmpty((CharSequence)"", (CharSequence)"a"));
        Assert.assertEquals((Object)"   ", (Object)StringUtils.defaultIfEmpty((CharSequence)"   ", (CharSequence)"a"));
    }

    @Test
    public void testIsEmptyBlank() {
        Assert.assertTrue((boolean)StringUtils.isBlank(null));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)"   "));
        Assert.assertTrue((boolean)StringUtils.isEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"   "));
    }

    @Test
    public void testToString() {
        TestData t = new TestData();
        t.iVal = 10;
        t.sVal = "abc";
        String res = StringUtils.toStringShortStyle((Object)t);
        Assert.assertTrue((res.length() > t.sVal.length() ? 1 : 0) != 0);
        res = StringUtils.toString((Object)t);
        Assert.assertTrue((res.length() > 0 ? 1 : 0) != 0);
        t.sVal = "aaaabbbbaaaabbbbaaaabbbbaaaabbbbkkskghwnajvkjejbajkbe5u ajdgkjekjbngkjnak";
        res = StringUtils.toStringShortStyle((Object)t);
        Assert.assertTrue((res.length() < t.sVal.length() ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() {
        Assert.assertEquals((Object)"This", (Object)StringUtils.removeEnd((String)"ThisEnd", (String)"End"));
        Assert.assertEquals((Object)"End", (Object)StringUtils.removeStart((String)"ThisEnd", (String)"This"));
    }

    private static class TestData {
        private int iVal;
        private String sVal;

        private TestData() {
        }
    }
}

