/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;

public class AasUtils {
    public static final URI EMPTY_URI;
    public static final ResourceResolver CLASSPATH_RESOLVER;
    public static final ResourceResolver CLASSPATH_RESOURCE_RESOLVER;

    public static String readString(Object[] args) {
        return AasUtils.readString(args, 0);
    }

    public static String readString(Object[] args, int index) {
        return AasUtils.readString(args, index, "");
    }

    public static String readString(Object[] args, int index, String dflt) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        return null == param ? dflt : param.toString();
    }

    public static int readInt(Object[] args, int index, int dflt) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        int result = dflt;
        if (null != param) {
            try {
                result = Integer.parseInt(param.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static double readDouble(Object[] args, int index, int dflt) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        double result = dflt;
        if (null != param) {
            try {
                result = Double.parseDouble(param.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean readBoolean(Object[] args, int index, boolean dflt) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        boolean result = dflt;
        if (null != param) {
            result = Boolean.parseBoolean(param.toString());
        }
        return result;
    }

    public static URI readUriEx(Object[] args, int index, URI dflt) throws URISyntaxException {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        URI result = dflt;
        if (null != param) {
            result = new URI(param.toString());
        }
        return result;
    }

    public static URI readUri(Object[] args, int index, URI dflt) {
        URI result;
        try {
            result = AasUtils.readUriEx(args, index, dflt);
        }
        catch (URISyntaxException e) {
            result = dflt;
        }
        return result;
    }

    public static String fixId(String id) {
        return AasFactory.getInstance().fixId(id);
    }

    public static Map<String, String> readMap(Object[] args, int index, Map<String, String> dflt) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        Map result = dflt;
        if (null != param) {
            result = (Map)JsonUtils.fromJson((Object)param, Map.class);
        }
        return result;
    }

    public static String writeMap(Map<String, String> map) {
        return JsonUtils.toJson(map);
    }

    public static void resolveImage(String image, ResourceResolver resolver, boolean handleAlways, ResourceHandler handler) {
        boolean resolved = false;
        if (null == resolver) {
            resolver = CLASSPATH_RESOURCE_RESOLVER;
        }
        if (null != image && image.length() > 0) {
            String prevMsg = "";
            try {
                String fName = FileUtils.sanitizeFileName((String)image);
                File f = new File(FileUtils.getTempDirectory(), fName);
                FileUtils.deleteOnExit((File)f);
                InputStream is = resolver.resolve(image);
                if (null != is) {
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)f);
                    String contents = FileUtils.fileToBase64((File)f);
                    String mimeType = Files.probeContentType(f.toPath());
                    handler.handle(fName, contents, mimeType);
                    resolved = true;
                }
            }
            catch (IOException e) {
                prevMsg = e.getMessage();
            }
            if (!resolved) {
                try {
                    URL url = NetUtils.createURL((String)image);
                    if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
                        String name = url.getFile();
                        int pos = name.lastIndexOf(47);
                        if (pos > 0) {
                            name = name.substring(pos + 1);
                        }
                        name = AasUtils.fixId(name);
                        handler.handle(name, url.toString(), "text/x-uri");
                        resolved = true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (!resolved) {
                LoggerFactory.getLogger(AasUtils.class).warn("Cannot resolve image '{}' {}", (Object)image, (Object)prevMsg);
            }
        }
        if (!resolved && handleAlways) {
            handler.handle("", "", "");
        }
    }

    public static <T> T getPropertyValueSafe(ElementsAccess coll, String propIdShort, Class<T> type, Function<Object, T> transformer, T dflt) {
        T result = dflt;
        Property prop = coll.getProperty(propIdShort);
        if (null != prop) {
            try {
                result = transformer.apply(prop.getValue());
            }
            catch (ExecutionException e) {
                LoggerFactory.getLogger(AasUtils.class).warn("Cannot access AAS property {} value: {}", (Object)propIdShort, (Object)e.getMessage());
            }
        } else {
            LoggerFactory.getLogger(AasUtils.class).warn("Cannot find AAS property {} in collection {}", (Object)propIdShort, (Object)coll.getIdShort());
        }
        return result;
    }

    public static String getPropertyValueAsStringSafe(ElementsAccess parent, String propIdShort, String dflt) {
        return AasUtils.getPropertyValueSafe(parent, propIdShort, String.class, o -> null == o ? dflt : o.toString(), dflt);
    }

    public static Integer getPropertyValueAsIntegerSafe(ElementsAccess parent, String propIdShort, Integer dflt) {
        return AasUtils.getPropertyValueSafe(parent, propIdShort, Integer.class, o -> null == o ? dflt : (Integer)o, dflt);
    }

    public static void setPropertyValue(ElementsAccess parent, String propIdShort, Object value) throws ExecutionException {
        Property prop;
        if (null != parent && null != (prop = parent.getProperty(propIdShort))) {
            prop.setValue(value);
        }
    }

    public static void setPropertyValueSafe(ElementsAccess parent, String propIdShort, Object value) {
        try {
            AasUtils.setPropertyValue(parent, propIdShort, value);
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(AasUtils.class).warn("Cannot set value for AAS property {}: {}", (Object)propIdShort, (Object)e.getMessage());
        }
    }

    public static Property.PropertyBuilder setValue(Property.PropertyBuilder builder, Object value, Invokable getter, Invokable setter) {
        AasFactory factory = AasFactory.getInstance();
        if (factory.supportsPropertyFunctions()) {
            builder.bind(getter, setter);
        } else {
            builder.setValue(value);
        }
        return builder;
    }

    public static String composeIdentifier(String basicId, String detailedId) {
        return basicId + detailedId;
    }

    public static void ifEarlyAas(Runnable func) {
        AasUtils.ifEarlyAas(null, func, null);
    }

    public static void ifEarlyAas(Runnable func, Runnable elseFunc) {
        AasUtils.ifEarlyAas(null, func, elseFunc);
    }

    public static void ifEarlyAas(Supplier<Boolean> andIf, Runnable func, Runnable elseFunc) {
        if (AasFactory.getInstance().createPropertiesEarly() && (null == andIf || andIf.get().booleanValue())) {
            if (func != null) {
                func.run();
            }
        } else if (elseFunc != null) {
            elseFunc.run();
        }
    }

    static {
        URI tmp;
        CLASSPATH_RESOLVER = (c, n) -> ResourceLoader.getResourceAsStream((String)ResourceLoader.prependSlash((String)n), (ResourceResolver[])new ResourceResolver[0]);
        CLASSPATH_RESOURCE_RESOLVER = (c, n) -> ResourceLoader.getResourceAsStream((String)("/resources" + ResourceLoader.prependSlash((String)n)), (ResourceResolver[])new ResourceResolver[0]);
        try {
            tmp = new URI("");
        }
        catch (URISyntaxException e) {
            tmp = null;
        }
        EMPTY_URI = tmp;
    }

    public static interface ResourceHandler {
        public void handle(String var1, String var2, String var3);
    }
}

