/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.identities;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.yaml.Yaml;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class YamlIdentityFile {
    private String name = "<undefined>";
    private Map<String, IdentityInformation> identities = new HashMap<String, IdentityInformation>();

    public Map<String, IdentityInformation> getIdentities() {
        return this.identities;
    }

    public IdentityInformation getData(String key) {
        return this.identities.get(key);
    }

    public String getName() {
        return this.name;
    }

    public void setIdentities(Map<String, IdentityInformation> data) {
        this.identities = data;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static YamlIdentityFile load(InputStream in) {
        YamlIdentityFile result = null;
        if (null == in) {
            LoggerFactory.getLogger(YamlIdentityFile.class).warn("No input stream given: Falling back to empty instance.");
            result = new YamlIdentityFile();
        } else {
            try {
                result = (YamlIdentityFile)Yaml.getInstance().loadTolerantAs(in, YamlIdentityFile.class);
                FileUtils.closeQuietly((Closeable)in);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(YamlIdentityFile.class).warn("Cannot load input stream: {} Falling back to empty instance.", (Object)e.getMessage());
                FileUtils.closeQuietly((Closeable)in);
                result = new YamlIdentityFile();
            }
        }
        return result;
    }

    public static class IdentityInformation {
        private IdentityToken.TokenType type;
        private String tokenPolicyId;
        private String userName;
        private String tokenData;
        private String tokenEncryptionAlgorithm;
        private String signatureAlgorithm;
        private String signature;
        private String file;

        public IdentityToken.TokenType getType() {
            return this.type;
        }

        public void setType(IdentityToken.TokenType type) {
            this.type = type;
        }

        public String getTokenPolicyId() {
            return this.tokenPolicyId;
        }

        public void setTokenPolicyId(String tokenPolicyId) {
            this.tokenPolicyId = tokenPolicyId;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getFile() {
            return this.file;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getTokenData() {
            return this.tokenData;
        }

        public void setTokenData(String tokenData) {
            this.tokenData = tokenData;
        }

        public byte[] getTokenDataAsBytes() {
            return null == this.tokenData ? null : this.tokenData.getBytes();
        }

        public String getTokenEncryptionAlgorithm() {
            return this.tokenEncryptionAlgorithm;
        }

        public void setTokenEncryptionAlgorithm(String tokenEncryptionAlgorithm) {
            this.tokenEncryptionAlgorithm = tokenEncryptionAlgorithm;
        }

        public String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public String getSignature() {
            return this.signature;
        }

        public byte[] getSignatureAsBytes() {
            return null == this.signature ? null : this.signature.getBytes();
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }
}

