/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors.util;

import com.profesorfalken.jsensors.manager.windows.powershell.PowerShellOperations;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerShellOperations.class);
    private static File tempFile = null;

    private SensorsUtils() {
    }

    public static String generateLibTmpPath(String libName) {
        return SensorsUtils.generateLibTmpPath("/", libName);
    }

    public static String generateLibTmpPath(String path, String libName) {
        if (tempFile == null) {
            InputStream in = SensorsUtils.class.getResourceAsStream(path + libName);
            try {
                int read;
                tempFile = File.createTempFile(libName, "");
                tempFile.deleteOnExit();
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(tempFile);
                while ((read = in.read(buffer)) != -1) {
                    fos.write(buffer, 0, read);
                }
                fos.close();
                in.close();
            }
            catch (IOException ex) {
                LOGGER.error("Cannot generate temporary file", (Throwable)ex);
                return "";
            }
        }
        return tempFile.getAbsolutePath();
    }
}

