/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors.standalone;

import com.profesorfalken.jsensors.JSensors;
import com.profesorfalken.jsensors.manager.windows.powershell.PowerShellOperations;
import com.profesorfalken.jsensors.model.components.Component;
import com.profesorfalken.jsensors.model.components.Components;
import com.profesorfalken.jsensors.model.components.Cpu;
import com.profesorfalken.jsensors.model.components.Disk;
import com.profesorfalken.jsensors.model.components.Gpu;
import com.profesorfalken.jsensors.model.sensors.Fan;
import com.profesorfalken.jsensors.model.sensors.Load;
import com.profesorfalken.jsensors.model.sensors.Temperature;
import com.profesorfalken.jsensors.util.OSDetector;
import java.awt.EventQueue;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;

public class GuiOutput {
    public static void showOutput(final Map<String, String> config) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSensorsGUI gui = new GuiOutput().new JSensorsGUI(config);
                gui.setVisible(true);
            }
        });
    }

    class JSensorsGUI
    extends JFrame {
        private Map<String, String> config;
        private JTable table = new JTable();

        public JSensorsGUI(Map<String, String> config) {
            this.config = config;
            this.initUI();
        }

        private void initUI() {
            this.setTitle("JSensors");
            this.setSize(600, 400);
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(3);
            if (OSDetector.isWindows() && !PowerShellOperations.isAdministrator()) {
                JOptionPane.showMessageDialog(this, "You have not executed jSensors in Administrator mode, so CPU temperature sensors will not be detected.");
            }
            new GuiUpdater(this).execute();
        }

        private DefaultTableModel calculateModel() {
            List<Disk> list;
            List<Gpu> gpus;
            DefaultTableModel model = new DefaultTableModel(new Object[]{"Sensor Name", "Value"}, 0);
            Components components = JSensors.get.config(this.config).components();
            List<Cpu> cpus = components.cpus;
            if (cpus != null) {
                for (Cpu cpu : cpus) {
                    model.addRow(new String[]{"CPU component: " + cpu.name});
                    this.addComponent(cpu, model);
                }
            }
            if ((gpus = components.gpus) != null) {
                for (Gpu gpu : gpus) {
                    model.addRow(new String[]{"GPU component: " + gpu.name});
                    this.addComponent(gpu, model);
                }
            }
            if ((list = components.disks) != null) {
                for (Disk disk : list) {
                    model.addRow(new String[]{"Disk component: " + disk.name});
                    this.addComponent(disk, model);
                }
            }
            return model;
        }

        private void addComponent(Component component, DefaultTableModel model) {
            if (component.sensors != null) {
                List<Temperature> temps = component.sensors.temperatures;
                for (Temperature temperature : temps) {
                    model.addRow(new String[]{temperature.name + ": ", temperature.value + " C"});
                }
                List<Fan> fans = component.sensors.fans;
                for (Fan fan : fans) {
                    model.addRow(new String[]{fan.name + ": ", fan.value + " RPM"});
                }
                List<Load> list = component.sensors.loads;
                for (Load load : list) {
                    model.addRow(new String[]{load.name + ": ", load.value + ""});
                }
            }
        }

        private class GuiUpdater
        extends SwingWorker<Void, Void> {
            public GuiUpdater(JSensorsGUI jSensorsGUI2) {
                JScrollPane scrollPane = new JScrollPane(JSensorsGUI.this.table);
                JSensorsGUI.this.table.setFillsViewportHeight(true);
                jSensorsGUI2.add(scrollPane);
            }

            @Override
            protected Void doInBackground() {
                while (true) {
                    JSensorsGUI.this.table.setModel(JSensorsGUI.this.calculateModel());
                }
            }
        }
    }
}

