/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.technicaldata;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollectionBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import java.util.Date;

public class TechnicalDataBuilder
extends DelegatingSubmodelBuilder {
    private boolean createMultiLanguageProperties = true;
    private int generalInformationCounter = 0;
    private int productClassificationsCounter = 0;
    private int technicalPropertiesCounter = 0;
    private int furtherInformationCounter = 0;

    public TechnicalDataBuilder(Aas.AasBuilder aasBuilder, String identifier) {
        this(aasBuilder, identifier, "TechnicalData");
    }

    private TechnicalDataBuilder(Aas.AasBuilder aasBuilder, String identifier, String idShort) {
        super(aasBuilder.createSubmodelBuilder(idShort, identifier));
        this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/Submodel/1/2"));
    }

    public void setCreateMultiLanguageProperties(boolean createMultiLanguageProperties) {
        this.createMultiLanguageProperties = createMultiLanguageProperties;
    }

    public GeneralInformationBuilder createGeneralInformationBuilder() {
        ++this.generalInformationCounter;
        return new GeneralInformationBuilder(this);
    }

    public ProductClassificationsBuilder createProductClassificationsBuilder() {
        ++this.productClassificationsCounter;
        return new ProductClassificationsBuilder(this);
    }

    public TechnicalPropertiesBuilder createTechnicalPropertiesBuilder() {
        ++this.technicalPropertiesCounter;
        return new TechnicalPropertiesBuilder(this);
    }

    public FurtherInformationBuilder createFurtherInformationBuilder() {
        ++this.furtherInformationCounter;
        return new FurtherInformationBuilder(this);
    }

    @Override
    public Submodel build() {
        Utils.assertThat(this.generalInformationCounter == 1, "Cardinality {} of GeneralInformation must be equal 1.", this.generalInformationCounter);
        Utils.assertThat(0 <= this.productClassificationsCounter && this.productClassificationsCounter <= 1, "Cardinality {} of ProductClassifications must be greater or equal 0 and less or equal 1.", this.productClassificationsCounter);
        Utils.assertThat(this.technicalPropertiesCounter == 1, "Cardinality {} of TechnicalProperties must be equal 1.", this.technicalPropertiesCounter);
        Utils.assertThat(0 <= this.furtherInformationCounter && this.furtherInformationCounter <= 1, "Cardinality {} of FurtherInformation must be greater or equal 0 and less or equal 1.", this.furtherInformationCounter);
        return super.build();
    }

    public class GeneralInformationBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int manufacturerNameCounter;
        private int manufacturerLogoCounter;
        private int manufacturerProductDesignationCounter;
        private int manufacturerArticleNumberCounter;
        private int manufacturerOrderCodeCounter;
        private int productImageCounter;

        protected GeneralInformationBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("GeneralInformation"), smBuilder);
            this.manufacturerNameCounter = 0;
            this.manufacturerLogoCounter = 0;
            this.manufacturerProductDesignationCounter = 0;
            this.manufacturerArticleNumberCounter = 0;
            this.manufacturerOrderCodeCounter = 0;
            this.productImageCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/GeneralInformation/1/1"));
        }

        protected GeneralInformationBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("GeneralInformation", nr)), smBuilder);
            this.manufacturerNameCounter = 0;
            this.manufacturerLogoCounter = 0;
            this.manufacturerProductDesignationCounter = 0;
            this.manufacturerArticleNumberCounter = 0;
            this.manufacturerOrderCodeCounter = 0;
            this.productImageCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/GeneralInformation/1/1"));
        }

        public GeneralInformationBuilder setManufacturerName(String manufacturerName) {
            ++this.manufacturerNameCounter;
            this.createPropertyBuilder("ManufacturerName").setSemanticId(IdentifierType.irdi("0173-1#02-AAO677#002")).setValue(Type.STRING, manufacturerName).build();
            return this;
        }

        public GeneralInformationBuilder setManufacturerLogo(String file, String mimeType) {
            ++this.manufacturerLogoCounter;
            this.createFileDataElementBuilder("ManufacturerLogo", file, mimeType).setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ManufacturerLogo/1/1")).build();
            return this;
        }

        public GeneralInformationBuilder setManufacturerProductDesignation(LangString ... manufacturerProductDesignation) {
            if (manufacturerProductDesignation.length > 0) {
                ++this.manufacturerProductDesignationCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TechnicalDataBuilder.this.createMultiLanguageProperties, "ManufacturerProductDesignation", IdentifierType.irdi("0173-1#02-AAW338#001"), manufacturerProductDesignation);
            return this;
        }

        public GeneralInformationBuilder setManufacturerArticleNumber(String manufacturerArticleNumber) {
            ++this.manufacturerArticleNumberCounter;
            this.createPropertyBuilder("ManufacturerArticleNumber").setSemanticId(IdentifierType.irdi("0173-1#02-AAO676#003")).setValue(Type.STRING, manufacturerArticleNumber).build();
            return this;
        }

        public GeneralInformationBuilder setManufacturerOrderCode(String manufacturerOrderCode) {
            ++this.manufacturerOrderCodeCounter;
            this.createPropertyBuilder("ManufacturerOrderCode").setSemanticId(IdentifierType.irdi("0173-1#02-AAO227#002")).setValue(Type.STRING, manufacturerOrderCode).build();
            return this;
        }

        public GeneralInformationBuilder setProductImage(String file, String mimeType) {
            this.createFileDataElementBuilder(Utils.getCountingIdShort("ProductImage", ++this.productImageCounter), file, mimeType).setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ProductImage/1/1")).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.manufacturerNameCounter == 1, "Cardinality {} of ManufacturerName must be equal 1.", this.manufacturerNameCounter);
            Utils.assertThat(0 <= this.manufacturerLogoCounter && this.manufacturerLogoCounter <= 1, "Cardinality {} of ManufacturerLogo must be greater or equal 0 and less or equal 1.", this.manufacturerLogoCounter);
            Utils.assertThat(this.manufacturerProductDesignationCounter == 1, "Cardinality {} of ManufacturerProductDesignation must be equal 1.", this.manufacturerProductDesignationCounter);
            Utils.assertThat(this.manufacturerArticleNumberCounter == 1, "Cardinality {} of ManufacturerArticleNumber must be equal 1.", this.manufacturerArticleNumberCounter);
            Utils.assertThat(this.manufacturerOrderCodeCounter == 1, "Cardinality {} of ManufacturerOrderCode must be equal 1.", this.manufacturerOrderCodeCounter);
            Utils.assertThat(0 <= this.productImageCounter, "Cardinality {} of ProductImage must be greater or equal 0.", this.productImageCounter);
            return super.build();
        }
    }

    public class ProductClassificationsBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int productClassificationItemCounter;

        protected ProductClassificationsBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("ProductClassifications"), smBuilder);
            this.productClassificationItemCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ProductClassifications/1/1"));
        }

        protected ProductClassificationsBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("ProductClassifications", nr)), smBuilder);
            this.productClassificationItemCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ProductClassifications/1/1"));
        }

        public ProductClassificationItemBuilder createProductClassificationItemBuilder() {
            return new ProductClassificationItemBuilder(this, ++this.productClassificationItemCounter);
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.productClassificationItemCounter, "Cardinality {} of ProductClassificationItem must be greater or equal 0.", this.productClassificationItemCounter);
            return super.build();
        }
    }

    public class TechnicalPropertiesBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int arbitraryCounter;
        private int mainSectionCounter;
        private int subSectionCounter;

        protected TechnicalPropertiesBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("TechnicalProperties"), smBuilder);
            this.arbitraryCounter = 0;
            this.mainSectionCounter = 0;
            this.subSectionCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/TechnicalProperties/1/1"));
        }

        protected TechnicalPropertiesBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("TechnicalProperties", nr)), smBuilder);
            this.arbitraryCounter = 0;
            this.mainSectionCounter = 0;
            this.subSectionCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/TechnicalProperties/1/1"));
        }

        public TechnicalPropertiesBuilder setArbitrary(String idShort, String arbitrary) {
            this.createPropertyBuilder(Utils.getCountingIdShort(idShort, ++this.arbitraryCounter)).setSemanticId(IdentifierType.iri("https://admin-shell.io/SemanticIdNotAvailable/1/1")).setValue(Type.STRING, arbitrary).build();
            return this;
        }

        public SubmodelElementCollection.SubmodelElementCollectionBuilder createMainSectionBuilder() {
            return super.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("MainSection", ++this.mainSectionCounter));
        }

        public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubSectionBuilder() {
            return super.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("SubSection", ++this.subSectionCounter));
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.arbitraryCounter, "Cardinality {} of arbitrary must be greater or equal 0.", this.arbitraryCounter);
            Utils.assertThat(0 <= this.mainSectionCounter, "Cardinality {} of MainSection must be greater or equal 0.", this.mainSectionCounter);
            Utils.assertThat(0 <= this.subSectionCounter, "Cardinality {} of SubSection must be greater or equal 0.", this.subSectionCounter);
            return super.build();
        }
    }

    public class FurtherInformationBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int textStatementCounter;
        private int validDateCounter;

        protected FurtherInformationBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("FurtherInformation"), smBuilder);
            this.textStatementCounter = 0;
            this.validDateCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/FurtherInformation/1/1"));
        }

        protected FurtherInformationBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("FurtherInformation", nr)), smBuilder);
            this.textStatementCounter = 0;
            this.validDateCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/FurtherInformation/1/1"));
        }

        public FurtherInformationBuilder setTextStatement(LangString ... textStatement) {
            Utils.createMultiLanguageProperty(this.getDelegate(), TechnicalDataBuilder.this.createMultiLanguageProperties, Utils.getCountingIdShort("TextStatement", ++this.textStatementCounter), IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/TextStatement/1/1"), textStatement);
            return this;
        }

        public FurtherInformationBuilder setValidDate(Date validDate) {
            ++this.validDateCounter;
            this.createPropertyBuilder("ValidDate").setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ValidDate/1/1")).setValue(Type.DATE_TIME, validDate).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.textStatementCounter, "Cardinality {} of TextStatement must be greater or equal 0.", this.textStatementCounter);
            Utils.assertThat(this.validDateCounter == 1, "Cardinality {} of ValidDate must be equal 1.", this.validDateCounter);
            return super.build();
        }
    }

    public class ProductClassificationItemBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int productClassificationSystemCounter;
        private int classificationSystemVersionCounter;
        private int productClassIdCounter;

        protected ProductClassificationItemBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("ProductClassificationItem"), smBuilder);
            this.productClassificationSystemCounter = 0;
            this.classificationSystemVersionCounter = 0;
            this.productClassIdCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ProductClassificationItem/1/1"));
        }

        protected ProductClassificationItemBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("ProductClassificationItem", nr)), smBuilder);
            this.productClassificationSystemCounter = 0;
            this.classificationSystemVersionCounter = 0;
            this.productClassIdCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ProductClassificationItem/1/1"));
        }

        public ProductClassificationItemBuilder setProductClassificationSystem(String productClassificationSystem) {
            ++this.productClassificationSystemCounter;
            this.createPropertyBuilder("ProductClassificationSystem").setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ProductClassificationSystem/1/1")).setValue(Type.STRING, productClassificationSystem).build();
            return this;
        }

        public ProductClassificationItemBuilder setClassificationSystemVersion(String classificationSystemVersion) {
            ++this.classificationSystemVersionCounter;
            this.createPropertyBuilder("ClassificationSystemVersion").setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ClassificationSystemVersion/1/1")).setValue(Type.STRING, classificationSystemVersion).build();
            return this;
        }

        public ProductClassificationItemBuilder setProductClassId(String productClassId) {
            ++this.productClassIdCounter;
            this.createPropertyBuilder("ProductClassId").setSemanticId(IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ProductClassId/1/1")).setValue(Type.STRING, productClassId).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.productClassificationSystemCounter == 1, "Cardinality {} of ProductClassificationSystem must be equal 1.", this.productClassificationSystemCounter);
            Utils.assertThat(0 <= this.classificationSystemVersionCounter && this.classificationSystemVersionCounter <= 1, "Cardinality {} of ClassificationSystemVersion must be greater or equal 0 and less or equal 1.", this.classificationSystemVersionCounter);
            Utils.assertThat(this.productClassIdCounter == 1, "Cardinality {} of ProductClassId must be equal 1.", this.productClassIdCounter);
            return super.build();
        }
    }
}

