/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors.manager;

import com.profesorfalken.jsensors.model.components.Components;
import com.profesorfalken.jsensors.model.components.Cpu;
import com.profesorfalken.jsensors.model.components.Disk;
import com.profesorfalken.jsensors.model.components.Gpu;
import com.profesorfalken.jsensors.model.components.Mobo;
import com.profesorfalken.jsensors.model.sensors.Fan;
import com.profesorfalken.jsensors.model.sensors.Load;
import com.profesorfalken.jsensors.model.sensors.Sensors;
import com.profesorfalken.jsensors.model.sensors.Temperature;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;

public abstract class SensorsManager {
    protected boolean debugMode = false;

    public SensorsManager debugMode(boolean mode) {
        this.debugMode = mode;
        return this;
    }

    protected abstract String getSensorsData();

    public Components getComponents() {
        String[] componentsData;
        ArrayList<Cpu> cpus = new ArrayList<Cpu>();
        ArrayList<Gpu> gpus = new ArrayList<Gpu>();
        ArrayList<Disk> disks = new ArrayList<Disk>();
        ArrayList<Mobo> mobos = new ArrayList<Mobo>();
        String normalizedSensorsData = this.getSensorsData();
        for (String componentData : componentsData = normalizedSensorsData.split("\\[COMPONENT\\]\\r?\\n")) {
            if (componentData.startsWith("CPU")) {
                cpus.add(this.getCpu(componentData));
                continue;
            }
            if (componentData.startsWith("GPU")) {
                gpus.add(this.getGpu(componentData));
                continue;
            }
            if (componentData.startsWith("DISK")) {
                disks.add(this.getDisk(componentData));
                continue;
            }
            if (!componentData.startsWith("MOBO")) continue;
            mobos.add(this.getMobo(componentData));
        }
        return new Components(cpus, gpus, disks, mobos);
    }

    private Cpu getCpu(String cpuData) {
        return new Cpu(SensorsManager.getName(cpuData), this.getSensors(cpuData));
    }

    private Gpu getGpu(String gpuData) {
        return new Gpu(SensorsManager.getName(gpuData), this.getSensors(gpuData));
    }

    private Disk getDisk(String diskData) {
        return new Disk(SensorsManager.getName(diskData), this.getSensors(diskData));
    }

    private Mobo getMobo(String moboData) {
        return new Mobo(SensorsManager.getName(moboData), this.getSensors(moboData));
    }

    private static String getName(String componentData) {
        String[] dataLines;
        String name = null;
        for (String dataLine : dataLines = componentData.split("\\r?\\n")) {
            if (!dataLine.startsWith("Label")) continue;
            name = dataLine.split(":")[1].trim();
            break;
        }
        return name;
    }

    private Sensors getSensors(String componentData) {
        String[] dataLines;
        ArrayList<Temperature> temperatures = new ArrayList<Temperature>();
        ArrayList<Fan> fans = new ArrayList<Fan>();
        ArrayList<Load> loads = new ArrayList<Load>();
        NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
        for (String dataLine : dataLines = componentData.split("\\r?\\n")) {
            try {
                String[] data;
                if (dataLine.startsWith("Temp")) {
                    data = dataLine.split(":");
                    Temperature temperature = new Temperature(data[0].trim(), data[1].trim().length() > 0 ? nf.parse(data[1].trim()).doubleValue() : 0.0);
                    temperatures.add(temperature);
                    continue;
                }
                if (dataLine.startsWith("Fan")) {
                    data = dataLine.split(":");
                    Fan fan = new Fan(data[0].trim(), data[1].trim().length() > 0 ? nf.parse(data[1].trim()).doubleValue() : 0.0);
                    fans.add(fan);
                    continue;
                }
                if (!dataLine.startsWith("Load")) continue;
                data = dataLine.split(":");
                Load load = new Load(data[0].trim(), data[1].trim().length() > 0 ? nf.parse(data[1].trim()).doubleValue() : 0.0);
                loads.add(load);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return new Sensors(temperatures, fans, loads);
    }
}

