/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.RbacReceiver;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class RbacRoles {
    private static List<AuthenticationDescriptor.Role> roles = new ArrayList<AuthenticationDescriptor.Role>();

    private static void processFields(Class<? extends AuthenticationDescriptor.Role> cls, Consumer<AuthenticationDescriptor.Role> operation) {
        for (Field f : cls.getDeclaredFields()) {
            if (!f.isEnumConstant()) continue;
            try {
                operation.accept((AuthenticationDescriptor.Role)f.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LoggerFactory.getLogger(RbacRoles.class).warn("Cannot process enum constant {}: {}", (Object)f.getName(), (Object)e.getMessage());
            }
        }
    }

    public static void registerRole(Class<? extends AuthenticationDescriptor.Role> cls) {
        RbacRoles.processFields(cls, r -> {
            if (!roles.contains(r)) {
                roles.add((AuthenticationDescriptor.Role)r);
            }
        });
    }

    public static void unregisterRole(Class<? extends AuthenticationDescriptor.Role> cls) {
        RbacRoles.processFields(cls, r -> roles.remove(r));
    }

    public static AuthenticationDescriptor.Role[] all() {
        return (AuthenticationDescriptor.Role[])roles.stream().toArray(AuthenticationDescriptor.Role[]::new);
    }

    public static AuthenticationDescriptor.Role[] allAuthenticated() {
        return (AuthenticationDescriptor.Role[])roles.stream().filter(r -> !r.anonymous()).toArray(AuthenticationDescriptor.Role[]::new);
    }

    public static AuthenticationDescriptor.Role[] allExcept(boolean authenticated, AuthenticationDescriptor.Role ... except) {
        return (AuthenticationDescriptor.Role[])roles.stream().filter(r -> !authenticated || authenticated && !r.anonymous()).filter(r -> !RbacRoles.contains(except, r)).toArray(AuthenticationDescriptor.Role[]::new);
    }

    public static AuthenticationDescriptor.Role[] allAnonymous() {
        return (AuthenticationDescriptor.Role[])roles.stream().filter(r -> r.anonymous()).toArray(AuthenticationDescriptor.Role[]::new);
    }

    public static boolean contains(AuthenticationDescriptor.Role[] roles, AuthenticationDescriptor.Role role) {
        return Stream.of(roles).anyMatch(r -> r == role);
    }

    public static <T extends RbacReceiver<T>> T rbac(T target, AuthenticationDescriptor auth, AuthenticationDescriptor.Role[] roles, AuthenticationDescriptor.RbacAction ... actions) {
        if (null != roles && null != actions) {
            for (AuthenticationDescriptor.Role r : roles) {
                target.rbac(auth, r, actions);
            }
        }
        return target;
    }

    static {
        RbacRoles.registerRole(AuthenticationDescriptor.DefaultRole.class);
    }
}

