/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class SimpleOperationsProvider
implements OperationsProvider {
    private static final String OP_PREFIX = "op_";
    private static final String SERVICE_PREFIX = "service_";
    private Map<String, Function<Object[], Object>> funcs = new HashMap<String, Function<Object[], Object>>();
    private Map<String, Supplier<Object>> get = new HashMap<String, Supplier<Object>>();
    private Map<String, Consumer<Object>> set = new HashMap<String, Consumer<Object>>();
    private OperationsProvider.Interceptor interceptor;

    @Override
    public OperationsProvider defineOperation(String category, String name, Function<Object[], Object> function) {
        this.funcs.put(OP_PREFIX + category + "_" + name, function);
        return this;
    }

    @Override
    public Function<Object[], Object> getOperation(String category, String name) {
        Function<Object[], Object> result = this.funcs.get(OP_PREFIX + category + "_" + name);
        if (this.interceptor != null) {
            result = this.interceptor.getOperation(category, name, result);
        }
        return result;
    }

    @Override
    public Function<Object[], Object> getServiceFunction(String name) {
        return this.funcs.get(SERVICE_PREFIX + name);
    }

    @Override
    public OperationsProvider defineServiceFunction(String name, Function<Object[], Object> function) {
        this.funcs.put(SERVICE_PREFIX + name, function);
        return this;
    }

    @Override
    public OperationsProvider defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
        this.get.put(name, get);
        this.set.put(name, set);
        return this;
    }

    @Override
    public Supplier<Object> getGetter(String name) {
        Supplier<Object> result = this.get.get(name);
        if (this.interceptor != null) {
            result = this.interceptor.getGetter(name, result);
        }
        return result;
    }

    @Override
    public Consumer<Object> getSetter(String name) {
        Consumer<Object> result = this.set.get(name);
        if (this.interceptor != null) {
            result = this.interceptor.getSetter(name, result);
        }
        return result;
    }

    @Override
    public void setInterceptor(OperationsProvider.Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public Set<String> getOperations(boolean qualified) {
        return this.getOperations(null, qualified);
    }

    @Override
    public Set<String> getOperations(String category, boolean qualified) {
        HashSet<String> result = new HashSet<String>();
        if (category != null && !((String)category).endsWith("_")) {
            category = (String)category + "_";
        }
        for (String name : this.funcs.keySet()) {
            if (null != category && !name.startsWith((String)category) && !name.startsWith(OP_PREFIX + (String)category)) continue;
            if (!qualified) {
                int pos = name.indexOf("_");
                if (pos > 0 && name.startsWith(OP_PREFIX)) {
                    pos = name.indexOf("_", pos + 1);
                }
                if (pos > 0) {
                    name = name.substring(pos + 1);
                }
            }
            result.add(name);
        }
        return result;
    }

    @Override
    public Set<String> getServiceOperations(boolean qualified) {
        return this.getOperations(SERVICE_PREFIX, qualified);
    }
}

