/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.common;

import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.RbacReceiver;

public abstract class AbstractDelegatingBuilder {
    private AbstractDelegatingBuilder parent;
    private AuthenticationDescriptor authDesc;
    private AuthenticationDescriptor.Role[] nextRoles;
    private AuthenticationDescriptor.RbacAction[] nextActions;

    protected AbstractDelegatingBuilder() {
    }

    protected AbstractDelegatingBuilder(AbstractDelegatingBuilder parent) {
        this.parent = parent;
    }

    public AbstractDelegatingBuilder setAuthenticationDescriptor(AuthenticationDescriptor authDesc) {
        this.authDesc = authDesc;
        return this;
    }

    public AuthenticationDescriptor getAuthenticationDescriptor() {
        AuthenticationDescriptor result = this.authDesc;
        if (null == result && this.parent != null) {
            result = this.parent.getAuthenticationDescriptor();
        }
        return result;
    }

    public AbstractDelegatingBuilder nextRbac(AuthenticationDescriptor.Role role, AuthenticationDescriptor.RbacAction ... actions) {
        return this.nextRbac(new AuthenticationDescriptor.Role[]{role}, actions);
    }

    public AbstractDelegatingBuilder nextRbac(AuthenticationDescriptor.Role[] roles, AuthenticationDescriptor.RbacAction ... actions) {
        this.nextRoles = roles;
        this.nextActions = actions;
        return this;
    }

    protected <T> T rbac(RbacReceiver<T> element) {
        return element.rbac(this.getAuthenticationDescriptor(), this.nextRoles, this.nextActions);
    }
}

