/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasBasedSetup;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.PlatformAas;
import de.iip_ecosphere.platform.support.iip_aas.SubmodelClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class AasPartRegistryTest
extends TestWithPlugin {
    private static final String NAME_MY_AAS = "myAas";

    @Test
    public void testPartRegistry() throws IOException, ExecutionException {
        Assert.assertTrue((CollectionUtils.toSet((Iterator)AasPartRegistry.contributors()).size() >= 2 ? 1 : 0) != 0);
        Set cClasses = AasPartRegistry.contributorClasses();
        Assert.assertTrue((boolean)cClasses.contains(Contributor1.class));
        Assert.assertTrue((boolean)cClasses.contains(Contributor2.class));
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build(c -> c.getKind() != AasContributor.Kind.ACTIVE || c instanceof PlatformAas);
        Assert.assertNotNull((Object)res.getAas());
        Assert.assertEquals((long)2L, (long)res.getAas().size());
        Assert.assertNotNull((Object)res.getProtocolServerBuilder());
        HashMap<String, Aas> hashedAas = new HashMap<String, Aas>();
        for (Aas a2 : res.getAas()) {
            hashedAas.put(a2.getIdShort(), a2);
        }
        Assert.assertNotNull(hashedAas.get("IIP_Ecosphere"));
        Assert.assertNotNull(hashedAas.get(NAME_MY_AAS));
        Assert.assertNotNull((Object)((Aas)hashedAas.get("IIP_Ecosphere")).getSubmodel("c1"));
        Assert.assertNotNull((Object)((Aas)hashedAas.get(NAME_MY_AAS)).getSubmodel("c2"));
        AasPartRegistry.AasSetup oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup());
        Server server = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]).start();
        Aas deployedAas = AasPartRegistry.retrieveIipAas();
        Assert.assertNotNull((Object)AasPartRegistry.retrieveIipAas());
        Assert.assertEquals((Object)"IIP_Ecosphere", (Object)deployedAas.getIdShort());
        Assert.assertNotNull((Object)deployedAas.getSubmodel("c1"));
        ActiveAasBase.NotificationMode oldP = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        ActiveAasBase.processNotification((String)"c1", (s, a) -> Assert.assertEquals((Object)"c1", (Object)s.getIdShort()));
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.ASYNCHRONOUS);
        AtomicBoolean done = new AtomicBoolean(false);
        ActiveAasBase.processNotification((String)"c1", (s, a) -> {
            Assert.assertEquals((Object)"c1", (Object)s.getIdShort());
            done.set(true);
        });
        while (!done.get()) {
            TimeUtils.sleep((int)200);
        }
        Submodel sub = ActiveAasBase.getSubmodel((String)"platform");
        Assert.assertNotNull((Object)sub);
        sub = ((Aas)hashedAas.get(NAME_MY_AAS)).getSubmodel("c2");
        MyAasClient client = new MyAasClient(sub);
        client.assertProp();
        client.assertOp();
        client.clear();
        server.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldP);
    }

    @Test
    public void testAasClientChecks() {
        SubmodelClient.checkString((Object)"ok");
        try {
            SubmodelClient.checkString((Object)"");
            Assert.fail((String)"No Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SubmodelClient.checkString(null);
            Assert.fail((String)"No Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        SubmodelClient.checkNotNull((Object)"ok");
        try {
            SubmodelClient.checkNotNull(null);
            Assert.fail((String)"No Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGet() {
        ArrayList<Aas> list = new ArrayList<Aas>();
        Assert.assertNull((Object)AasPartRegistry.getAas(list, (String)""));
        list.add((Aas)AasFactory.getInstance().createAasBuilder("test", "urn:::AAS:::test#").build());
        Assert.assertNull((Object)AasPartRegistry.getAas(list, (String)""));
        Assert.assertNotNull((Object)AasPartRegistry.getAas(list, (String)"test"));
        list.add((Aas)AasFactory.getInstance().createAasBuilder("test2", "urn:::AAS:::test2#").build());
        Assert.assertNull((Object)AasPartRegistry.getAas(list, (String)""));
        Assert.assertNotNull((Object)AasPartRegistry.getAas(list, (String)"test"));
    }

    @Test
    public void testSetup_aasPartRegistry() throws IOException {
        TestSetup config = (TestSetup)((Object)TestSetup.readFromYaml(TestSetup.class, (String)"/aasPartRegistry.yml"));
        Assert.assertNotNull((Object)((Object)config));
        Assert.assertEquals((Object)"test", (Object)config.getName());
        AasPartRegistry.AasSetup setup = config.getAas();
        Assert.assertNotNull((Object)setup);
        Assert.assertNotNull((Object)setup.getServer());
        Assert.assertNotNull((Object)setup.getServerEndpoint());
        Assert.assertNotNull((Object)setup.getRegistry());
        Assert.assertNotNull((Object)setup.getMode());
        Assert.assertNotNull((Object)setup.getRegistryEndpoint());
        Assert.assertEquals((Object)"VAB", (Object)setup.getImplementationProtocol());
        Assert.assertNotNull((Object)setup.getImplementationServer());
        Assert.assertEquals((Object)AasPartRegistry.AasMode.REGISTER, (Object)setup.getMode());
        Assert.assertEquals((Object)Schema.HTTP, (Object)setup.getServer().getSchema());
        Assert.assertEquals((Object)"here.de", (Object)setup.getServer().getHost());
        Assert.assertEquals((long)9994L, (long)setup.getServer().getPort());
        Assert.assertEquals((Object)AasPartRegistryTest.aasUrlPath("aas"), (Object)setup.getServer().getPath());
        Assert.assertEquals((long)9994L, (long)setup.getServer().getServerAddress().getPort());
        Assert.assertEquals((Object)Schema.HTTP, (Object)setup.getRegistry().getSchema());
        Assert.assertEquals((Object)"me.de", (Object)setup.getRegistry().getHost());
        Assert.assertEquals((long)9995L, (long)setup.getRegistry().getPort());
        Assert.assertEquals((Object)AasPartRegistryTest.aasUrlPath("registry"), (Object)setup.getRegistry().getPath());
        Assert.assertEquals((long)9995L, (long)setup.getRegistry().getServerAddress().getPort());
        Assert.assertEquals((Object)Schema.TCP, (Object)setup.getImplementation().getSchema());
        Assert.assertEquals((Object)"localhost", (Object)setup.getImplementation().getHost());
        Assert.assertEquals((long)10220L, (long)setup.getImplementation().getPort());
        Assert.assertEquals((Object)"VAB", (Object)setup.getImplementation().getProtocol());
        Assert.assertEquals((long)10220L, (long)setup.getImplementation().getServerAddress().getPort());
    }

    private static String aasUrlPath(String withPath) {
        return AasFactory.getInstance().supportsUrlPaths() ? withPath : "";
    }

    @Test
    public void testSetup_aasPartRegistry_eph() throws IOException {
        TestSetup config = (TestSetup)((Object)TestSetup.readFromYaml(TestSetup.class, (String)"/aasPartRegistry_eph.yml"));
        AasPartRegistry.AasSetup setup = config.getAas();
        Assert.assertNotNull((Object)setup);
        Assert.assertEquals((Object)Schema.TCP, (Object)setup.getImplementation().getSchema());
        Assert.assertEquals((Object)"localhost", (Object)setup.getImplementation().getHost());
        Assert.assertTrue((setup.getImplementation().getPort() < 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"VAB-TCP", (Object)setup.getImplementation().getProtocol());
        Assert.assertTrue((setup.getImplementation().getServerAddress().getPort() > 0 ? 1 : 0) != 0);
    }

    public static class Contributor1
    implements AasContributor {
        public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
            aasBuilder.createSubmodelBuilder("c1", null).build();
            return null;
        }

        public void contributeTo(ProtocolServerBuilder sBuilder) {
        }

        public AasContributor.Kind getKind() {
            return AasContributor.Kind.PASSIVE;
        }

        public boolean isValid() {
            return true;
        }
    }

    public static class Contributor2
    implements AasContributor {
        public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
            Aas.AasBuilder builder = AasFactory.getInstance().createAasBuilder(AasPartRegistryTest.NAME_MY_AAS, "urn:::AAS:::myAas#");
            Submodel.SubmodelBuilder smb = builder.createSubmodelBuilder("c2", null);
            smb.createPropertyBuilder("c2prop").setType(Type.STRING).setValue((Object)"a").build();
            smb.createOperationBuilder("c2op").build();
            smb.build();
            return (Aas)builder.build();
        }

        public void contributeTo(ProtocolServerBuilder sBuilder) {
        }

        public AasContributor.Kind getKind() {
            return AasContributor.Kind.PASSIVE;
        }

        public boolean isValid() {
            return true;
        }
    }

    private static class MyAasClient
    extends SubmodelClient {
        MyAasClient(Submodel submodel) {
            super(submodel);
            Assert.assertEquals((Object)submodel, (Object)this.getSubmodel());
        }

        public void assertProp() throws ExecutionException {
            try {
                this.getProperty("c2prop1");
                Assert.fail((String)"No exception");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            Assert.assertNotNull((Object)this.getProperty("c2prop"));
            Assert.assertNotNull((Object)this.getPropertyStringValue("c2prop", null));
        }

        public void assertOp() throws ExecutionException {
            try {
                this.getOperation("c2op1");
                Assert.fail((String)"No exception");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            Assert.assertNotNull((Object)this.getOperation("c2op"));
        }
    }

    public static class TestSetup
    extends AasBasedSetup {
        private String name = "";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

