/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import iip.datatypes.Abc;
import iip.datatypes.AbcImpl;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void testOptionals() {
        Data obj;
        String data = "{\"intValue\":\"1\"}";
        Json objectMapper = Json.createInstance4All().defineOptionals(Data.class, new String[]{"stringValue"});
        try {
            obj = (Data)objectMapper.readValue(data, Data.class);
            Assert.assertEquals((long)1L, (long)obj.getIntValue());
            Assert.assertNull((Object)obj.getStringValue());
        }
        catch (IOException e) {
            Assert.fail((String)"Shall not occur");
        }
        data = "{\"stringValue\":\"xyz\"}";
        objectMapper = Json.createInstance4All().defineOptionals(Data.class, new String[]{"intValue"});
        try {
            obj = (Data)objectMapper.readValue(data, Data.class);
            Assert.assertEquals((long)0L, (long)obj.getIntValue());
            Assert.assertEquals((Object)"xyz", (Object)obj.getStringValue());
        }
        catch (IOException e) {
            Assert.fail((String)"Shall not occur");
        }
        data = "{}";
        objectMapper = Json.createInstance4All().defineOptionals(Data.class, new String[]{"stringValue", "intValue"});
        try {
            obj = (Data)objectMapper.readValue(data, Data.class);
            Assert.assertEquals((long)0L, (long)obj.getIntValue());
            Assert.assertNull((Object)obj.getStringValue());
        }
        catch (IOException e) {
            Assert.fail((String)"Shall not occur");
        }
    }

    @Test
    public void testToFromJson() {
        String json = JsonUtils.toJson(null);
        Data data = (Data)JsonUtils.fromJson((Object)json, Data.class);
        Assert.assertNull((Object)data);
        data = new Data(25, "abba");
        json = JsonUtils.toJson((Object)data);
        Data tmp = (Data)JsonUtils.fromJson((Object)json, Data.class);
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)data.getStringValue(), (Object)tmp.getStringValue());
        Assert.assertEquals((long)data.getIntValue(), (long)tmp.getIntValue());
    }

    @Test
    public void testServerAddress() {
        ServerAddress addr = null;
        String json = ServerAddressHolder.toJson(addr);
        ServerAddress tmp = ServerAddressHolder.serverAddressFromJson((Object)json);
        Assert.assertNull((Object)tmp);
        addr = new ServerAddress(Schema.TCP, "me.here", 10321);
        json = JsonUtils.toJson((Object)addr);
        tmp = ServerAddressHolder.serverAddressFromJson((Object)json);
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)addr.getSchema(), (Object)tmp.getSchema());
        Assert.assertEquals((Object)addr.getHost(), (Object)tmp.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)tmp.getPort());
    }

    @Test
    public void testEscapeUnescape() {
        JsonUtilsTest.assertEscapeUnescape("");
        JsonUtilsTest.assertEscapeUnescape("aaa");
        JsonUtilsTest.assertEscapeUnescape("{}");
        JsonUtilsTest.assertEscapeUnescape("{\"name\": \"abc\", \"value\": 1, \"enum\":20, \"enumName\":\"TEST1\"}");
        JsonUtilsTest.assertEscapeUnescape("{\"obj\": {\"name\": \"abc\", \"value\": 1}}");
    }

    private static void assertEscapeUnescape(String string) {
        Assert.assertEquals((Object)string, (Object)JsonUtils.unescape((String)JsonUtils.escape((String)string)));
    }

    @Test
    public void testIipTypes() throws IOException {
        AbcImpl abc = new AbcImpl();
        abc.setValue(42);
        Json objectMapper = Json.createInstance4All();
        String str = objectMapper.writeValueAsString((Object)abc);
        objectMapper.handleIipDataClasses();
        Abc test = (Abc)objectMapper.readValue(str, Abc.class);
        Assert.assertNotNull((Object)test);
        Assert.assertEquals((long)abc.getValue(), (long)test.getValue());
    }

    @Test
    public void testPropertyNaming() throws IOException {
        Json objectMapper = Json.createInstance4All();
        String str = "{\"INTVALUE\":1, \"stringVAlue\":\"abba\"}";
        objectMapper.defineFields(new String[]{"INTVALUE", "stringVAlue"});
        PropertyData test = (PropertyData)objectMapper.readValue(str, PropertyData.class);
        Assert.assertNotNull((Object)test);
        Assert.assertEquals((long)1L, (long)test.getINTVALUE());
        Assert.assertEquals((Object)"abba", (Object)test.getStringVAlue());
    }

    @Test
    public void testExceptFields() throws IOException {
        PropertyData data = new PropertyData();
        data.setStringVAlue("abba");
        Json mapper = Json.createInstance4All().exceptFields(new String[]{"stringVAlue"});
        Assert.assertEquals((Object)"", (Object)mapper.toJsonQuiet(null));
        String json = mapper.toJsonQuiet((Object)data);
        Assert.assertTrue((boolean)json.contains("intvalue"));
        Assert.assertFalse((boolean)json.contains("stringVAlue"));
    }

    public static class Data {
        private int intValue;
        private String stringValue;

        private Data() {
        }

        private Data(int intValue, String stringValue) {
            this.intValue = intValue;
            this.stringValue = stringValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        void setIntValue(int intValue) {
            this.intValue = intValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }
    }

    static class PropertyData {
        private int INTVALUE = 5;
        private String stringVAlue;
        private boolean HW_Btn2 = true;

        PropertyData() {
        }

        public int getINTVALUE() {
            return this.INTVALUE;
        }

        public boolean getHW_Btn2() {
            return this.HW_Btn2;
        }

        public String getStringVAlue() {
            return this.stringVAlue;
        }

        public void setINTVALUE(int INTVALUE) {
            this.INTVALUE = INTVALUE;
        }

        public void setStringVAlue(String stringVAlue) {
            this.stringVAlue = stringVAlue;
        }

        public void setHW_Btn2(boolean HW_Btn2) {
            this.HW_Btn2 = HW_Btn2;
        }
    }
}

