/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ApplicationInstanceAasConstructor {
    public static final String NAME_SUBMODEL_APPINSTANCES = "ApplicationInstances";
    public static final String NAME_PROP_APPID = "appId";
    public static final String NAME_PROP_PLANID = "planId";
    public static final String NAME_PROP_INSTANCEID = "instanceId";
    public static final String NAME_PROP_TIMESTAMP = "timestamp";

    public static boolean firstAppWithoutAppId() {
        return Boolean.valueOf(OsUtils.getPropertyOrEnv((String)"iip.firstWithoutAppId", (String)"false"));
    }

    public static String notifyAppNewInstance(String appId, String planId) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        ActiveAasBase.processNotification(NAME_SUBMODEL_APPINSTANCES, ActiveAasBase.NotificationMode.SYNCHRONOUS, (sub, aas) -> {
            int newId = ApplicationInstanceAasConstructor.firstAppWithoutAppId() && sub.getSubmodelElementsCount() == 0 ? 0 : 1;
            String propMaxId = AasUtils.fixId((String)(appId + "_max"));
            Property propMax = sub.getProperty(propMaxId);
            if (null == propMax) {
                Submodel.SubmodelBuilder builder = aas.createSubmodelBuilder(sub.getIdShort(), sub.getIdentification());
                builder.createPropertyBuilder(propMaxId).setValue(Type.INTEGER, (Object)newId).build();
                builder.build();
            } else {
                newId = AasUtils.getPropertyValueAsIntegerSafe((ElementsAccess)sub, (String)propMaxId, (Integer)0) + 1;
                AasUtils.setPropertyValueSafe((ElementsAccess)sub, (String)propMaxId, (Object)newId);
            }
            SubmodelElementCollection.SubmodelElementCollectionBuilder dBuilder = sub.createSubmodelElementCollectionBuilder(ApplicationInstanceAasConstructor.getAasAppInstanceId(appId, newId));
            dBuilder.createPropertyBuilder(NAME_PROP_APPID).setValue(Type.STRING, (Object)appId).build();
            dBuilder.createPropertyBuilder(NAME_PROP_PLANID).setValue(Type.STRING, (Object)planId).build();
            dBuilder.createPropertyBuilder(NAME_PROP_INSTANCEID).setValue(Type.INTEGER, (Object)newId).build();
            dBuilder.createPropertyBuilder(NAME_PROP_TIMESTAMP).setValue(Type.INT64, (Object)System.currentTimeMillis()).build();
            dBuilder.build();
            if (newId > 0) {
                result.set(String.valueOf(newId));
            }
        });
        return result.get();
    }

    private static String getAasAppInstanceId(String appId, int instanceId) {
        return ApplicationInstanceAasConstructor.getAasAppInstanceId(appId, String.valueOf(instanceId));
    }

    private static String getAasAppInstanceId(String appId, String instanceId) {
        return AasUtils.fixId((String)(appId + "-" + instanceId));
    }

    public static int notifyAppInstanceStopped(String appId, String instanceId) {
        AtomicInteger result = new AtomicInteger(0);
        String instId = null == instanceId || instanceId.length() == 0 ? "0" : instanceId;
        ActiveAasBase.processNotification(NAME_SUBMODEL_APPINSTANCES, ActiveAasBase.NotificationMode.SYNCHRONOUS, (sub, aas) -> {
            sub.deleteElement(ApplicationInstanceAasConstructor.getAasAppInstanceId(appId, instId));
            result.set(ApplicationInstanceAasConstructor.countAppInstances(appId, null, sub));
        });
        return result.get();
    }

    static int countAppInstances(String appId, String planId, Submodel sub) {
        int result = 0;
        if (null != sub && appId != null) {
            for (SubmodelElement elt : sub.submodelElements()) {
                SubmodelElementCollection coll;
                if (!(elt instanceof SubmodelElementCollection) || !appId.equals(AasUtils.getPropertyValueAsStringSafe((ElementsAccess)(coll = (SubmodelElementCollection)elt), (String)NAME_PROP_APPID, null)) || null != planId && !planId.isEmpty() && !planId.equals(AasUtils.getPropertyValueAsStringSafe((ElementsAccess)coll, (String)NAME_PROP_PLANID, null))) continue;
                ++result;
            }
        }
        return result;
    }
}

