/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.TechnicalDataBuilder;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationSetup;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.iip_aas.PlatformAas;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class NameplateSetup {
    public static final String SUBMODEL_SERVICES = "services";
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_NETMASK = "netmask";
    public static final String PROPERTY_VERSION = "version";
    private String manufacturerName;
    private String manufacturerProductDesignation;
    private String manufacturerArticleNumber;
    private String manufacturerOrderCodeNumber;
    private String productImage = "";
    private String manufacturerLogo = "";
    private List<ProductClassificationItem> productClassificationItems = new ArrayList<ProductClassificationItem>();
    private ApplicationSetup.Address address = new ApplicationSetup.Address();
    private List<Service> services = new ArrayList<Service>();

    public NameplateSetup() {
    }

    public NameplateSetup(NameplateSetup setup) {
        this.address = new ApplicationSetup.Address(setup.address);
        this.productImage = setup.productImage;
        this.manufacturerArticleNumber = setup.manufacturerArticleNumber;
        this.manufacturerOrderCodeNumber = setup.manufacturerOrderCodeNumber;
        this.manufacturerLogo = setup.manufacturerLogo;
        this.manufacturerName = setup.manufacturerName;
        this.manufacturerProductDesignation = setup.manufacturerProductDesignation;
        this.productClassificationItems.addAll(setup.productClassificationItems);
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getManufacturerArticleNumber() {
        return this.manufacturerArticleNumber;
    }

    public void setManufacturerArticleNumber(String manufacturerArticleNumber) {
        this.manufacturerArticleNumber = manufacturerArticleNumber;
    }

    public String getManufacturerOrderCodeNumber() {
        return this.manufacturerOrderCodeNumber;
    }

    public void setManufacturerOrderCodeNumber(String manufacturerOrderCodeNumber) {
        this.manufacturerOrderCodeNumber = manufacturerOrderCodeNumber;
    }

    public String getManufacturerProductDesignation() {
        return this.manufacturerProductDesignation;
    }

    public Service getService(String key) {
        Service svc = null;
        for (Service s : this.getServices()) {
            if (!s.getKey().equals(key)) continue;
            svc = s;
            break;
        }
        return svc;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public static Map<String, Service> getServicesAsMap(List<Service> services) {
        HashMap<String, Service> result = new HashMap<String, Service>();
        if (null != services) {
            for (Service s : services) {
                result.put(s.getKey(), s);
            }
        }
        return result;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public void setManufacturerProductDesignation(String manufacturerProductDesignation) {
        this.manufacturerProductDesignation = manufacturerProductDesignation;
    }

    public ApplicationSetup.Address getAddress() {
        return this.address;
    }

    public void setAddress(ApplicationSetup.Address address) {
        this.address = address;
    }

    public String getProductImage() {
        return this.productImage;
    }

    public void setProductImage(String productImage) {
        this.productImage = productImage;
    }

    public String getManufacturerLogo() {
        return this.manufacturerLogo;
    }

    public void setManufacturerLogo(String manufacturerLogo) {
        this.manufacturerLogo = manufacturerLogo;
    }

    public static String expandUrn(String urn, String expansion) {
        Object result = urn;
        if (urn.endsWith("#")) {
            result = urn.substring(0, urn.length() - 1) + expansion + "#";
        }
        return result;
    }

    public Aas createAas(String urn, String id, Consumer<Aas.AasBuilder> further) {
        AasFactory factory = AasFactory.getInstance();
        Aas aas = null;
        try {
            aas = AasPartRegistry.retrieveAas(urn);
        }
        catch (IOException e) {
            try {
                Aas.AasBuilder aasBuilder = factory.createAasBuilder(id, urn);
                this.createTechnicalDataNameplate(aasBuilder, urn);
                Submodel.SubmodelBuilder sub = AasPartRegistry.createSubmodelBuilder(aasBuilder, SUBMODEL_SERVICES);
                if (null != this.getServices()) {
                    for (Service s : this.getServices()) {
                        SubmodelElementCollection.SubmodelElementCollectionBuilder smcb = sub.createSubmodelElementCollectionBuilder(s.getKey());
                        smcb.createPropertyBuilder(PROPERTY_KEY).setValue(Type.STRING, (Object)s.getKey()).build();
                        smcb.createPropertyBuilder(PROPERTY_PORT).setValue(Type.INTEGER, (Object)s.getPort()).build();
                        smcb.createPropertyBuilder(PROPERTY_HOST).setValue(Type.STRING, (Object)s.getHost()).build();
                        smcb.createPropertyBuilder(PROPERTY_NETMASK).setValue(Type.STRING, (Object)s.getNetmask()).build();
                        smcb.createPropertyBuilder(PROPERTY_VERSION).setValue(Type.STRING, null == s.getVersion() ? null : s.getVersion().toString()).setSemanticId("irdi:0173-1#02-AAM737#002").build();
                        smcb.build();
                    }
                }
                sub.build();
                if (null != further) {
                    further.accept(aasBuilder);
                }
                aas = (Aas)aasBuilder.build();
                AasPartRegistry.remoteDeploy(CollectionUtils.addAll(new ArrayList(), (Object[])new Aas[]{aas}));
            }
            catch (IOException e1) {
                LoggerFactory.getLogger(this.getClass()).error("Creating nameplate AAS: {}", (Object)e.getMessage());
            }
        }
        return aas;
    }

    private void createTechnicalDataNameplate(Aas.AasBuilder aasBuilder, String urn) {
        TechnicalDataBuilder tdBuilder = new TechnicalDataBuilder(aasBuilder, NameplateSetup.expandUrn(urn, "-technicalData"));
        tdBuilder.rbac(AasPartRegistry.getSubmodelAuthentication());
        TechnicalDataBuilder.GeneralInformationBuilder giBuilder = tdBuilder.createGeneralInformationBuilder().setManufacturerName(this.getManufacturerName()).setManufacturerArticleNumber(this.getManufacturerArticleNumber()).setManufacturerOrderCode(this.getManufacturerOrderCodeNumber()).setManufacturerProductDesignation(new LangString[]{LangString.create((String)this.getManufacturerProductDesignation())});
        PlatformAas.createAddress((SubmodelElementContainerBuilder)giBuilder, this.getAddress());
        AasUtils.resolveImage((String)this.getProductImage(), (ResourceResolver)AasUtils.CLASSPATH_RESOURCE_RESOLVER, (boolean)false, (n, r, m) -> giBuilder.setProductImage(r, m));
        AasUtils.resolveImage((String)this.getManufacturerLogo(), (ResourceResolver)AasUtils.CLASSPATH_RESOURCE_RESOLVER, (boolean)true, (n, r, m) -> giBuilder.setManufacturerLogo(r, m));
        giBuilder.build();
        GregorianCalendar now = new GregorianCalendar();
        TechnicalDataBuilder.FurtherInformationBuilder fiBuilder = tdBuilder.createFurtherInformationBuilder().setValidDate(now.getTime());
        fiBuilder.build();
        tdBuilder.createTechnicalPropertiesBuilder().build();
        TechnicalDataBuilder.ProductClassificationsBuilder pBuilder = tdBuilder.createProductClassificationsBuilder();
        for (ProductClassificationItem item : this.productClassificationItems) {
            pBuilder.createProductClassificationItemBuilder().setClassificationSystemVersion(item.getClassificationSystemVersion()).setProductClassificationSystem(item.getProductClassificationSystem()).setProductClassId(item.getProductClassId()).build();
        }
        pBuilder.build();
        tdBuilder.build();
    }

    public static InputStream resolveNameplateSetup() {
        InputStream is = AasUtils.CLASSPATH_RESOURCE_RESOLVER.resolve("nameplate.yml");
        if (null == is) {
            try {
                is = new FileInputStream("src/test/resources/nameplate.yml");
            }
            catch (IOException e) {
                LoggerFactory.getLogger(NameplateSetup.class).info("Checking AAS for id {}", (Object)Id.getDeviceId());
                is = AasUtils.CLASSPATH_RESOURCE_RESOLVER.resolve(Id.getDeviceId().toUpperCase() + ".yml");
            }
        }
        return is;
    }

    public static NameplateSetup obtainNameplateSetup() throws IOException {
        return (NameplateSetup)AbstractSetup.readFromYaml(NameplateSetup.class, (InputStream)NameplateSetup.resolveNameplateSetup());
    }

    public static NameplateSetup readFromAas(Aas aas) {
        Submodel sub;
        NameplateSetup result = new NameplateSetup();
        if (null != aas && null != (sub = aas.getSubmodel(SUBMODEL_SERVICES))) {
            result.setServices(NameplateSetup.readServices(sub));
        }
        return result;
    }

    private static List<Service> readServices(Submodel sub) {
        ArrayList<Service> result = new ArrayList<Service>();
        for (SubmodelElement elt : sub.submodelElements()) {
            if (!(elt instanceof SubmodelElementCollection)) continue;
            SubmodelElementCollection coll = (SubmodelElementCollection)elt;
            String key = NameplateSetup.getStringProperty(coll, PROPERTY_KEY);
            Integer port = null;
            Property p = coll.getProperty(PROPERTY_PORT);
            if (null != p) {
                try {
                    Object val = p.getValue();
                    if (val instanceof Integer) {
                        port = (Integer)val;
                    }
                }
                catch (ExecutionException val) {
                    // empty catch block
                }
            }
            if (null == key || null == port) continue;
            Service svc = new Service();
            svc.setKey(key);
            svc.setPort(port);
            svc.setHost(NameplateSetup.getStringProperty(coll, PROPERTY_HOST));
            svc.setNetmask(NameplateSetup.getStringProperty(coll, PROPERTY_NETMASK));
            svc.setVersion(NameplateSetup.getStringProperty(coll, PROPERTY_VERSION));
            result.add(svc);
        }
        return result;
    }

    private static String getStringProperty(SubmodelElementCollection coll, String idShort) {
        String result = null;
        Property p = coll.getProperty(idShort);
        if (null != p) {
            try {
                Object val = p.getValue();
                if (val instanceof String) {
                    result = (String)val;
                }
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return result;
    }

    public static NameplateSetup resolveFromAas() throws IOException {
        SubmodelElementCollection device;
        Property prop;
        Submodel resSub;
        NameplateSetup result = null;
        String address = null;
        Aas aas = AasPartRegistry.retrieveIipAas();
        if (null != aas && null != (resSub = aas.getSubmodel("resources")) && null != (prop = (device = resSub.getSubmodelElementCollection(Id.getDeviceIdAas())).getProperty("deviceAas"))) {
            try {
                address = (String)prop.getValue();
            }
            catch (ExecutionException e) {
                LoggerFactory.getLogger(NameplateSetup.class).warn("Cannot read value of AAS my device entry: {}", (Object)e.getMessage());
            }
        }
        if (null != address) {
            aas = NameplateSetup.resolve(address);
            result = NameplateSetup.readFromAas(aas);
        }
        return result;
    }

    public static Service resolveServiceFromAas(String key) {
        Service result = null;
        if (null != key) {
            try {
                NameplateSetup np = NameplateSetup.resolveFromAas();
                if (null != np) {
                    result = np.getService(key);
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(NameplateSetup.class).warn("Cannot resolve service {}: {}", (Object)key, (Object)e.getMessage());
            }
        }
        return result;
    }

    public static Aas resolve(String identifier) throws IOException {
        Registry reg = AasFactory.getInstance().obtainRegistry((SetupSpec)AasPartRegistry.getSetup());
        return reg.retrieveAas(identifier);
    }

    public static class Service {
        private String key;
        private int port;
        private String host;
        private String netmask;
        private Version version;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getHost() {
            if (null == this.host) {
                this.host = NetUtils.getOwnIP((String)NetUtils.getNetMask((String)this.netmask, (String)this.host));
            }
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getNetmask() {
            return this.netmask;
        }

        public void setNetmask(String netmask) {
            this.netmask = netmask;
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = null == version ? null : new Version(version);
        }

        public void setVersion(Version version) {
            this.version = version;
        }
    }

    public static class ProductClassificationItem {
        private String productClassificationSystem;
        private String classificationSystemVersion;
        private String productClassId;

        public String getProductClassificationSystem() {
            return this.productClassificationSystem;
        }

        public void setProductClassificationSystem(String productClassificationSystem) {
            this.productClassificationSystem = productClassificationSystem;
        }

        public String getClassificationSystemVersion() {
            return this.classificationSystemVersion;
        }

        public void setClassificationSystemVersion(String classificationSystemVersion) {
            this.classificationSystemVersion = classificationSystemVersion;
        }

        public String getProductClassId() {
            return this.productClassId;
        }

        public void setProductClassId(String productClassId) {
            this.productClassId = productClassId;
        }
    }
}

