/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.config;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.iip_aas.config.BasicEndpointValidator;
import de.iip_ecosphere.platform.support.iip_aas.config.EndpointHolder;
import de.iip_ecosphere.platform.support.iip_aas.config.EndpointValidator;
import de.iip_ecosphere.platform.support.iip_aas.config.RuntimeSetup;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;

public class RuntimeSetupEndpointValidator
extends BasicEndpointValidator {
    private URI uri;

    private RuntimeSetupEndpointValidator(URI uri) {
        this.uri = uri;
    }

    public static EndpointValidator create(Function<RuntimeSetup, String> accessor) {
        return RuntimeSetupEndpointValidator.create(accessor, true);
    }

    public static EndpointValidator create(Function<RuntimeSetup, String> accessor, boolean failIfNull) {
        BasicEndpointValidator result;
        RuntimeSetup setup = RuntimeSetup.load(() -> null, false);
        if (null == setup) {
            result = new BasicEndpointValidator();
        } else {
            String uri = accessor.apply(setup);
            if (failIfNull || !failIfNull && uri != null) {
                try {
                    result = new RuntimeSetupEndpointValidator(new URI(uri));
                }
                catch (URISyntaxException e) {
                    result = new BasicEndpointValidator();
                }
            } else {
                result = new BasicEndpointValidator();
            }
        }
        return result;
    }

    @Override
    public String validateHost(String host, EndpointHolder holder) {
        return holder.isEphmemeral() ? this.uri.getHost() : host;
    }

    @Override
    public int validatePort(int port, EndpointHolder holder) {
        return holder.isEphmemeral() ? this.uri.getPort() : port;
    }

    @Override
    public Schema validateSchema(Schema schema, EndpointHolder holder) {
        Schema result = schema;
        if (holder.isEphmemeral()) {
            try {
                result = Schema.valueOf((String)this.uri.getScheme().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String validatePath(String path, EndpointHolder holder) {
        String result = path;
        if (holder.isEphmemeral()) {
            result = this.uri.getPath();
            while (result.startsWith("/")) {
                result = result.substring(1);
            }
        }
        return result;
    }
}

