/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import java.io.IOException;

public class NetworkManagerAas
implements AasContributor {
    public static final String NAME_SUBMODEL = "netMgt";
    public static final String OP_RELEASE_PORT = "releasePort";
    public static final String OP_IS_IN_USE_PORT = "isInUsePortPort";
    public static final String OP_IS_IN_USE_ADR = "isInUsePortAdr";
    public static final String OP_GET_PORT = "getPort";
    public static final String PROP_HIGH_PORT = "highPort";
    public static final String PROP_LOW_PORT = "lowPort";
    public static final String OP_OBTAIN_PORT = "obtainPort";
    public static final String OP_RESERVE_PORT = "reservePort";
    public static final String OP_REGISTER_INSTANCE = "registerInstance";
    public static final String OP_UNREGISTER_INSTANCE = "unregisterInstance";
    public static final String OP_GET_REGISTERED_INSTANCES = "getRegisteredInstances";

    @Override
    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        AuthenticationDescriptor auth = this.getSubmodelAuthentication();
        Submodel.SubmodelBuilder smB = AasPartRegistry.createSubmodelBuilderRbac(aasBuilder, NAME_SUBMODEL);
        if (smB.isNew()) {
            smB.createOperationBuilder(OP_RESERVE_PORT).addInputVariable("key", Type.STRING).addInputVariable("address", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_RESERVE_PORT))).build(Type.STRING, auth);
            smB.createOperationBuilder(OP_OBTAIN_PORT).addInputVariable("key", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_OBTAIN_PORT))).build(Type.STRING, auth);
            smB.createOperationBuilder(OP_GET_PORT).addInputVariable("key", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_GET_PORT))).build(Type.STRING, auth);
            smB.createOperationBuilder(OP_IS_IN_USE_PORT).addInputVariable("port", Type.INTEGER).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_IS_IN_USE_PORT))).build(Type.BOOLEAN, auth);
            smB.createOperationBuilder(OP_IS_IN_USE_ADR).addInputVariable("adr", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_IS_IN_USE_ADR))).build(Type.BOOLEAN, auth);
            smB.createOperationBuilder(OP_RELEASE_PORT).addInputVariable("key", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_RELEASE_PORT))).build(auth);
            smB.createOperationBuilder(OP_REGISTER_INSTANCE).addInputVariable("key", Type.STRING).addInputVariable("hostId", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_REGISTER_INSTANCE))).build(auth);
            smB.createOperationBuilder(OP_UNREGISTER_INSTANCE).addInputVariable("key", Type.STRING).addInputVariable("hostId", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_UNREGISTER_INSTANCE))).build(auth);
            smB.createOperationBuilder(OP_GET_REGISTERED_INSTANCES).addInputVariable("key", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_GET_REGISTERED_INSTANCES))).build(Type.INTEGER, auth);
            AasUtils.setValue((Property.PropertyBuilder)smB.createPropertyBuilder(PROP_HIGH_PORT).setType(Type.INTEGER), (Object)NetworkManagerFactory.getInstance().getHighPort(), (Invokable)iCreator.createGetter(NetworkManagerAas.getQName(PROP_HIGH_PORT)), (Invokable)Property.PropertyBuilder.READ_ONLY).build(auth);
            AasUtils.setValue((Property.PropertyBuilder)smB.createPropertyBuilder(PROP_LOW_PORT).setType(Type.INTEGER), (Object)NetworkManagerFactory.getInstance().getLowPort(), (Invokable)iCreator.createGetter(NetworkManagerAas.getQName(PROP_LOW_PORT)), (Invokable)Property.PropertyBuilder.READ_ONLY).build(auth);
            smB.build();
        }
        return null;
    }

    @Override
    public void contributeTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_RESERVE_PORT), p -> NetworkManagerAas.toJson(NetworkManagerFactory.getInstance().reservePort(AasUtils.readString((Object[])p, (int)0, null), ServerAddressHolder.serverAddressFromJson(AasUtils.readString((Object[])p, (int)1, null)))));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_OBTAIN_PORT), p -> NetworkManagerAas.toJson(NetworkManagerFactory.getInstance().obtainPort(AasUtils.readString((Object[])p, (int)0, null))));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_GET_PORT), p -> NetworkManagerAas.toJson(NetworkManagerFactory.getInstance().getPort(AasUtils.readString((Object[])p, (int)0, null))));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_IS_IN_USE_PORT), p -> NetworkManagerFactory.getInstance().isInUse(AasUtils.readInt((Object[])p, (int)0, (int)-1)));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_IS_IN_USE_ADR), p -> NetworkManagerFactory.getInstance().isInUse(ServerAddressHolder.serverAddressFromJson(AasUtils.readString((Object[])p, (int)0, null))));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_RELEASE_PORT), p -> {
            NetworkManagerFactory.getInstance().releasePort(AasUtils.readString((Object[])p, (int)0, null));
            return null;
        });
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_REGISTER_INSTANCE), p -> {
            NetworkManagerFactory.getInstance().registerInstance(AasUtils.readString((Object[])p, (int)0, null), AasUtils.readString((Object[])p, (int)1, null));
            return null;
        });
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_UNREGISTER_INSTANCE), p -> {
            NetworkManagerFactory.getInstance().unregisterInstance(AasUtils.readString((Object[])p, (int)0, null), AasUtils.readString((Object[])p, (int)1, null));
            return null;
        });
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_GET_REGISTERED_INSTANCES), p -> NetworkManagerFactory.getInstance().getRegisteredInstances(AasUtils.readString((Object[])p, (int)0, null)));
        sBuilder.defineProperty(NetworkManagerAas.getQName(PROP_HIGH_PORT), () -> NetworkManagerFactory.getInstance().getHighPort(), Property.PropertyBuilder.READ_ONLY_FUNC);
        sBuilder.defineProperty(NetworkManagerAas.getQName(PROP_LOW_PORT), () -> NetworkManagerFactory.getInstance().getLowPort(), Property.PropertyBuilder.READ_ONLY_FUNC);
    }

    public static String getQName(String elementName) {
        return AasFactory.composeIdShort((String[])new String[]{NAME_SUBMODEL, elementName});
    }

    public static ManagedServerAddress managedServerAddressFromJson(Object json) {
        ManagedServerAddress result = null;
        if (null != json) {
            try {
                Json mapper = Json.createInstance(ManagedServerAddressHolder.class);
                ManagedServerAddressHolder tmp = (ManagedServerAddressHolder)mapper.fromJson((Object)json.toString(), ManagedServerAddressHolder.class);
                result = new ManagedServerAddress(tmp.getSchema(), tmp.getHost(), tmp.getPort(), tmp.isNew());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toJson(ManagedServerAddress address) {
        String result = "";
        if (null != address) {
            try {
                ManagedServerAddressHolder tmp = new ManagedServerAddressHolder(address);
                result = Json.writeValueAsStringDflt((Object)tmp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    @Override
    public boolean isValid() {
        return NetworkManagerFactory.getInstance() != null;
    }

    static class ManagedServerAddressHolder
    extends ServerAddressHolder {
        private boolean isNew;

        ManagedServerAddressHolder() {
        }

        ManagedServerAddressHolder(ManagedServerAddress addr) {
            super((ServerAddress)addr);
            this.isNew = addr.isNew();
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setNew(boolean isNew) {
            this.isNew = isNew;
        }
    }
}

