/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.config;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Ignore;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.IdentityStoreAuthenticationDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.config.BasicEndpointValidator;
import de.iip_ecosphere.platform.support.iip_aas.config.EndpointValidator;
import de.iip_ecosphere.platform.support.iip_aas.config.TlsServerAddressHolder;

public class EndpointHolder
extends TlsServerAddressHolder {
    private String path = "";
    private String idStorePrefix = null;
    private boolean ignorePath = false;
    private transient EndpointValidator validator = new BasicEndpointValidator();

    public EndpointHolder() {
    }

    public EndpointHolder(Schema schema, String host, int port, String path) {
        super(schema, host, port);
        this.path = path;
    }

    public EndpointHolder(Endpoint endpoint) {
        super(endpoint.getSchema(), endpoint.getHost(), endpoint.getPort());
        this.path = endpoint.getEndpoint();
    }

    public EndpointHolder(EndpointHolder holder) {
        super(holder);
        this.path = holder.path;
        this.ignorePath = holder.ignorePath;
    }

    public void setValidator(EndpointValidator validator) {
        if (null != validator) {
            this.validator = validator;
        }
    }

    public String getPath() {
        return this.ignorePath ? "" : this.validator.validatePath(this.path, this);
    }

    public EndpointHolder ignorePath(boolean ignorePath) {
        this.ignorePath = ignorePath;
        return this;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public int getPort() {
        return this.validator.validatePort(super.getPort(), this);
    }

    @Override
    public String getHost() {
        return this.validator.validateHost(super.getHost(), this);
    }

    @Override
    public Schema getSchema() {
        return this.validator.validateSchema(super.getSchema(), this);
    }

    @Ignore
    public Endpoint getEndpoint() {
        return new Endpoint(this.getServerAddress(), this.getPath());
    }

    public AuthenticationDescriptor getAuthentication() {
        IdentityStoreAuthenticationDescriptor result = null;
        if (this.idStorePrefix != null) {
            result = this.idStorePrefix.length() > 0 ? new IdentityStoreAuthenticationDescriptor() : new IdentityStoreAuthenticationDescriptor(this.idStorePrefix);
        }
        return result;
    }
}

