/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ClassUtility;
import de.iip_ecosphere.platform.support.iip_aas.Skip;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class ClassUtilityTest
extends TestWithPlugin {
    private static final String NAME_AAS = "test";
    private static final String URN_AAS = "urn:::AAS:::types#";
    private static final String NAME_TEST_SUBMODEL = "test";
    private static final String NAME_TEST_VAR_PRIMITIVE = "prim";
    private static final String NAME_TEST_VAR_SIMPLE = "input";
    private static final String NAME_TEST_VAR_COMPLEX = "input1";

    @Test
    public void testAddTypeToClass() throws ExecutionException {
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder("test", URN_AAS);
        Submodel.SubmodelBuilder smBuilder = aasBuilder.createSubmodelBuilder("test", null);
        this.populateModel(smBuilder);
        smBuilder.build();
        Aas aas = (Aas)aasBuilder.build();
        aas.accept((AasVisitor)new AasPrintVisitor());
        this.assertTypeSubmodel(aas);
    }

    private void populateModel(Submodel.SubmodelBuilder smBuilder) {
        ClassUtility.addTypeSubModelElement((SubmodelElementContainerBuilder)smBuilder, (String)NAME_TEST_VAR_PRIMITIVE, Integer.class);
        ClassUtility.addTypeSubModelElement((SubmodelElementContainerBuilder)smBuilder, (String)NAME_TEST_VAR_SIMPLE, Simple.class);
        ClassUtility.addTypeSubModelElement((SubmodelElementContainerBuilder)smBuilder, (String)NAME_TEST_VAR_COMPLEX, Complex.class);
    }

    private void assertTypeSubmodel(Aas aas) throws ExecutionException {
        Submodel smType = aas.getSubmodel("types");
        SubmodelElementCollection typeC = smType.getSubmodelElementCollection(ClassUtility.getName(Simple.class));
        Assert.assertNotNull((Object)typeC);
        Assert.assertNotNull((Object)typeC.getProperty("attr_value"));
        Assert.assertEquals((Object)"int", (Object)typeC.getProperty("attr_value").getValue());
        Assert.assertNull((Object)typeC.getProperty("attr_secret"));
        typeC = smType.getSubmodelElementCollection(ClassUtility.getName(Complex.class));
        Assert.assertNotNull((Object)typeC);
        Assert.assertNotNull((Object)typeC.getProperty("attr_unknown"));
        Assert.assertEquals((Object)"String", (Object)typeC.getProperty("attr_unknown").getValue());
        SubmodelElementCollection smc = typeC.getSubmodelElementCollection("attr_values");
        Assert.assertNotNull((Object)smc);
        Assert.assertEquals((Object)"int", (Object)smc.getProperty("type").getValue());
        Assert.assertEquals((Object)1, (Object)smc.getProperty("nesting").getValue());
        Assert.assertNotNull((Object)typeC.getProperty("attr_otherValue"));
        Assert.assertEquals((Object)"int", (Object)typeC.getProperty("attr_otherValue").getValue());
        Assert.assertNotNull((Object)typeC.getReferenceElement("attr_simple"));
        Assert.assertNotNull((Object)typeC.getReferenceElement("attr_simple").getValue());
        Submodel smTest = aas.getSubmodel("test");
        Property primitive = smTest.getProperty(NAME_TEST_VAR_PRIMITIVE);
        Assert.assertNotNull((Object)primitive);
        Assert.assertEquals((Object)"int", (Object)primitive.getValue());
        ReferenceElement ref = smTest.getReferenceElement(NAME_TEST_VAR_SIMPLE);
        Assert.assertNotNull((Object)ref);
        Assert.assertNotNull((Object)ref.getValue().hasReference());
        ref = smTest.getReferenceElement(NAME_TEST_VAR_COMPLEX);
        Assert.assertNotNull((Object)ref);
        Assert.assertNotNull((Object)ref.getValue().hasReference());
    }

    @Test
    public void testGetId() {
        String prefix = "prefix_";
        Object o = new Object();
        String id1 = ClassUtility.getId((String)"", (Object)o);
        Assert.assertNotNull((Object)id1);
        Assert.assertTrue((id1.length() > 0 ? 1 : 0) != 0);
        String id2 = ClassUtility.getId((String)"prefix_", (Object)o);
        Assert.assertNotNull((Object)id2);
        Assert.assertTrue((id2.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)id2.startsWith("prefix_"));
    }

    @Test
    public void addTestTypeToClassWithDeployment() throws IOException, ExecutionException {
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder("test", URN_AAS);
        AasPartRegistry.createSubmodelBuilder((Aas.AasBuilder)aasBuilder, (String)"types").build();
        aasBuilder.createSubmodelBuilder("test", null).build();
        AasPartRegistry.AasSetup spec = AasPartRegistry.AasSetup.createLocalEphemeralSetup();
        AasServer httpServer = AasFactory.getInstance().createDeploymentRecipe((SetupSpec)spec).forRegistry().deploy((Aas)aasBuilder.build()).createServer(new String[0]).start();
        factory = AasFactory.getInstance();
        Aas aas = factory.obtainRegistry((SetupSpec)spec).retrieveAas(URN_AAS);
        Submodel.SubmodelBuilder smBuilder = aas.createSubmodelBuilder("test", null);
        this.populateModel(smBuilder);
        smBuilder.build();
        aas.accept((AasVisitor)new AasPrintVisitor());
        this.assertTypeSubmodel(aas);
        factory = AasFactory.getInstance();
        aas = factory.obtainRegistry((SetupSpec)spec).retrieveAas(URN_AAS);
        aas.accept((AasVisitor)new AasPrintVisitor());
        this.assertTypeSubmodel(aas);
        httpServer.stop(true);
    }

    private static class Simple {
        private int value;
        @Skip
        private int secret;

        private Simple() {
        }
    }

    private static class Complex
    extends Base {
        private int otherValue;
        private Simple simple;

        private Complex() {
        }
    }

    private static class Base {
        private String unknown;
        private int[] values;

        private Base() {
        }
    }
}

