/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.IterImpl;
import com.jsoniter.JsonIterator;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.Slice;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class ReflectionEnumDecoder
implements Decoder {
    private final Map<Slice, Object> enumMap = new HashMap<Slice, Object>();
    private Class clazz;

    public ReflectionEnumDecoder(Class clazz) {
        this.clazz = clazz;
        for (Object e : clazz.getEnumConstants()) {
            this.enumMap.put(Slice.make(e.toString()), e);
        }
    }

    @Override
    public Object decode(JsonIterator iter) throws IOException {
        if (iter.readNull()) {
            return null;
        }
        Slice slice = IterImpl.readSlice(iter);
        Object e = this.enumMap.get(slice);
        if (e == null) {
            throw iter.reportError("ReflectionEnumDecoder", slice + " is not valid enum for " + this.clazz);
        }
        return e;
    }
}

