/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.Codegen;
import com.jsoniter.CodegenAccess;
import com.jsoniter.JsonIterator;
import com.jsoniter.any.Any;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.ClassInfo;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.Slice;
import com.jsoniter.spi.WrapperDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ReflectionObjectDecoder {
    private static Object NOT_SET = new Object(){

        public String toString() {
            return "NOT_SET";
        }
    };
    private Map<Slice, Binding> allBindings = new HashMap<Slice, Binding>();
    private String tempCacheKey;
    private String ctorArgsCacheKey;
    private int tempCount;
    private long expectedTracker;
    private int requiredIdx;
    private int tempIdx;
    private ClassDescriptor desc;

    public ReflectionObjectDecoder(ClassInfo classInfo) {
        try {
            this.init(classInfo);
        }
        catch (JsonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    private final void init(ClassInfo classInfo) throws Exception {
        Class clazz = classInfo.clazz;
        ClassDescriptor desc = ClassDescriptor.getDecodingClassDescriptor(classInfo, true);
        for (Binding binding : desc.ctor.parameters) {
            this.addBinding(classInfo, binding);
        }
        this.desc = desc;
        if (desc.ctor.objectFactory == null && desc.ctor.ctor == null && desc.ctor.staticFactory == null) {
            throw new JsonException("no constructor for: " + desc.clazz);
        }
        for (Binding binding : desc.fields) {
            this.addBinding(classInfo, binding);
        }
        for (Binding binding : desc.setters) {
            this.addBinding(classInfo, binding);
        }
        for (WrapperDescriptor wrapperDescriptor : desc.bindingTypeWrappers) {
            for (Binding param : wrapperDescriptor.parameters) {
                this.addBinding(classInfo, param);
            }
        }
        if (this.requiredIdx > 63) {
            throw new JsonException("too many required properties to track");
        }
        this.expectedTracker = Long.MAX_VALUE >> 63 - this.requiredIdx;
        if (!desc.ctor.parameters.isEmpty() || !desc.bindingTypeWrappers.isEmpty()) {
            this.tempCount = this.tempIdx;
            this.tempCacheKey = "temp@" + clazz.getCanonicalName();
            this.ctorArgsCacheKey = "ctor@" + clazz.getCanonicalName();
        }
    }

    private void addBinding(ClassInfo classInfo, final Binding binding) {
        if (binding.fromNames.length == 0) {
            return;
        }
        if (binding.asMissingWhenNotPresent) {
            binding.mask = 1L << this.requiredIdx;
            ++this.requiredIdx;
        }
        if (binding.asExtraWhenPresent) {
            binding.decoder = new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    throw new JsonException("found should not present property: " + binding.name);
                }
            };
        }
        if (binding.decoder == null) {
            binding.decoder = JsoniterSpi.getDecoder(binding.decoderCacheKey());
        }
        if (binding.decoder == null) {
            binding.decoder = Codegen.getDecoder(binding.valueTypeLiteral.getDecoderCacheKey(), binding.valueType);
        }
        binding.idx = this.tempIdx;
        for (String fromName : binding.fromNames) {
            Slice slice = Slice.make(fromName);
            if (this.allBindings.containsKey(slice)) {
                throw new JsonException("name conflict found in " + classInfo.clazz + ": " + fromName);
            }
            this.allBindings.put(slice, binding);
        }
        ++this.tempIdx;
    }

    public Decoder create() {
        if (this.desc.ctor.parameters.isEmpty()) {
            if (this.desc.bindingTypeWrappers.isEmpty()) {
                return new OnlyField();
            }
            return new WithWrapper();
        }
        return new WithCtor();
    }

    private void setToBinding(Object obj, Binding binding, Object value) throws Exception {
        if (binding.field != null) {
            binding.field.set(obj, value);
        } else {
            binding.method.invoke(obj, value);
        }
    }

    private void setExtra(Object obj, Map<String, Object> extra) throws Exception {
        if (extra == null) {
            return;
        }
        if (this.desc.asExtraForUnknownProperties) {
            if (this.desc.onExtraProperties == null) {
                Iterator<Object> iterator = extra.keySet().iterator();
                if (iterator.hasNext()) {
                    String fieldName = (String)iterator.next();
                    throw new JsonException("unknown property: " + fieldName);
                }
            } else {
                this.setToBinding(obj, this.desc.onExtraProperties, extra);
            }
        }
        for (Method wrapper : this.desc.keyValueTypeWrappers) {
            for (Map.Entry<String, Object> entry : extra.entrySet()) {
                Any value = (Any)entry.getValue();
                wrapper.invoke(obj, entry.getKey(), value.object());
            }
        }
    }

    private boolean canNotSetDirectly(Binding binding) {
        return binding.field == null && binding.method == null;
    }

    private Object decodeBinding(JsonIterator iter, Binding binding) throws Exception {
        Object value = binding.decoder.decode(iter);
        return value;
    }

    private Object decodeBinding(JsonIterator iter, Object obj, Binding binding) throws Exception {
        if (binding.valueCanReuse) {
            CodegenAccess.setExistingObject(iter, binding.field.get(obj));
        }
        return this.decodeBinding(iter, binding);
    }

    private Map<String, Object> onUnknownProperty(JsonIterator iter, Slice fieldName, Map<String, Object> extra) throws IOException {
        boolean shouldReadValue;
        boolean bl = shouldReadValue = this.desc.asExtraForUnknownProperties || !this.desc.keyValueTypeWrappers.isEmpty();
        if (shouldReadValue) {
            Any value = iter.readAny();
            if (extra == null) {
                extra = new HashMap<String, Object>();
            }
            extra.put(fieldName.toString(), value);
        } else {
            iter.skip();
        }
        return extra;
    }

    private List<String> collectMissingFields(long tracker) {
        ArrayList<String> missingFields = new ArrayList<String>();
        for (Binding binding : this.allBindings.values()) {
            if (!binding.asMissingWhenNotPresent) continue;
            long mask = binding.mask;
            CodegenAccess.addMissingField(missingFields, tracker, mask, binding.name);
        }
        return missingFields;
    }

    private void applyWrappers(Object[] temp, Object obj) throws Exception {
        for (WrapperDescriptor wrapper : this.desc.bindingTypeWrappers) {
            Object[] args = new Object[wrapper.parameters.size()];
            for (int i = 0; i < wrapper.parameters.size(); ++i) {
                Object arg = temp[wrapper.parameters.get((int)i).idx];
                if (arg == NOT_SET) continue;
                args[i] = arg;
            }
            wrapper.method.invoke(obj, args);
        }
    }

    private Object createNewObject(JsonIterator iter, Object[] temp) throws Exception {
        Object[] ctorArgs;
        if (iter.tempObjects == null) {
            iter.tempObjects = new HashMap<String, Object>();
        }
        if ((ctorArgs = (Object[])iter.tempObjects.get(this.ctorArgsCacheKey)) == null) {
            ctorArgs = new Object[this.desc.ctor.parameters.size()];
            iter.tempObjects.put(this.ctorArgsCacheKey, ctorArgs);
        }
        Arrays.fill(ctorArgs, null);
        for (int i = 0; i < this.desc.ctor.parameters.size(); ++i) {
            Object arg = temp[this.desc.ctor.parameters.get((int)i).idx];
            if (arg == NOT_SET) continue;
            ctorArgs[i] = arg;
        }
        return this.createNewObject(ctorArgs);
    }

    private Object createNewObject(Object ... args) throws Exception {
        if (this.desc.ctor.objectFactory != null) {
            return this.desc.ctor.objectFactory.create(this.desc.clazz);
        }
        if (this.desc.ctor.staticFactory != null) {
            return this.desc.ctor.staticFactory.invoke(null, args);
        }
        return this.desc.ctor.ctor.newInstance(args);
    }

    public class WithWrapper
    implements Decoder {
        @Override
        public Object decode(JsonIterator iter) throws IOException {
            try {
                return this.decode_(iter);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }

        private Object decode_(JsonIterator iter) throws Exception {
            Object[] temp;
            if (iter.readNull()) {
                CodegenAccess.resetExistingObject(iter);
                return null;
            }
            Object obj = ReflectionObjectDecoder.this.createNewObject(new Object[0]);
            if (!CodegenAccess.readObjectStart(iter)) {
                if (ReflectionObjectDecoder.this.requiredIdx > 0) {
                    if (((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.onMissingProperties == null) {
                        throw new JsonException("missing required properties: " + ReflectionObjectDecoder.this.collectMissingFields(0L));
                    }
                    ReflectionObjectDecoder.this.setToBinding(obj, ((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.onMissingProperties, ReflectionObjectDecoder.this.collectMissingFields(0L));
                }
                return obj;
            }
            Map extra = null;
            long tracker = 0L;
            if (iter.tempObjects == null) {
                iter.tempObjects = new HashMap<String, Object>();
            }
            if ((temp = (Object[])iter.tempObjects.get(ReflectionObjectDecoder.this.tempCacheKey)) == null) {
                temp = new Object[ReflectionObjectDecoder.this.tempCount];
                iter.tempObjects.put(ReflectionObjectDecoder.this.tempCacheKey, temp);
            }
            Arrays.fill(temp, NOT_SET);
            Slice fieldName = CodegenAccess.readObjectFieldAsSlice(iter);
            Binding binding = (Binding)ReflectionObjectDecoder.this.allBindings.get(fieldName);
            if (binding == null) {
                extra = ReflectionObjectDecoder.this.onUnknownProperty(iter, fieldName, extra);
            } else {
                if (binding.asMissingWhenNotPresent) {
                    tracker |= binding.mask;
                }
                if (ReflectionObjectDecoder.this.canNotSetDirectly(binding)) {
                    temp[binding.idx] = ReflectionObjectDecoder.this.decodeBinding(iter, obj, binding);
                } else {
                    ReflectionObjectDecoder.this.setToBinding(obj, binding, ReflectionObjectDecoder.this.decodeBinding(iter, obj, binding));
                }
            }
            while (CodegenAccess.nextToken(iter) == 44) {
                fieldName = CodegenAccess.readObjectFieldAsSlice(iter);
                binding = (Binding)ReflectionObjectDecoder.this.allBindings.get(fieldName);
                if (binding == null) {
                    extra = ReflectionObjectDecoder.this.onUnknownProperty(iter, fieldName, extra);
                    continue;
                }
                if (binding.asMissingWhenNotPresent) {
                    tracker |= binding.mask;
                }
                if (ReflectionObjectDecoder.this.canNotSetDirectly(binding)) {
                    temp[binding.idx] = ReflectionObjectDecoder.this.decodeBinding(iter, obj, binding);
                    continue;
                }
                ReflectionObjectDecoder.this.setToBinding(obj, binding, ReflectionObjectDecoder.this.decodeBinding(iter, obj, binding));
            }
            if (tracker != ReflectionObjectDecoder.this.expectedTracker) {
                if (((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.onMissingProperties == null) {
                    throw new JsonException("missing required properties: " + ReflectionObjectDecoder.this.collectMissingFields(tracker));
                }
                ReflectionObjectDecoder.this.setToBinding(obj, ((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.onMissingProperties, ReflectionObjectDecoder.this.collectMissingFields(tracker));
            }
            ReflectionObjectDecoder.this.setExtra(obj, extra);
            ReflectionObjectDecoder.this.applyWrappers(temp, obj);
            return obj;
        }
    }

    public class WithCtor
    implements Decoder {
        @Override
        public Object decode(JsonIterator iter) throws IOException {
            try {
                return this.decode_(iter);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }

        private Object decode_(JsonIterator iter) throws Exception {
            Object val;
            Object[] temp;
            if (iter.readNull()) {
                CodegenAccess.resetExistingObject(iter);
                return null;
            }
            if (iter.tempObjects == null) {
                iter.tempObjects = new HashMap<String, Object>();
            }
            if ((temp = (Object[])iter.tempObjects.get(ReflectionObjectDecoder.this.tempCacheKey)) == null) {
                temp = new Object[ReflectionObjectDecoder.this.tempCount];
                iter.tempObjects.put(ReflectionObjectDecoder.this.tempCacheKey, temp);
            }
            Arrays.fill(temp, NOT_SET);
            if (!CodegenAccess.readObjectStart(iter)) {
                if (ReflectionObjectDecoder.this.requiredIdx > 0) {
                    throw new JsonException("missing required properties: " + ReflectionObjectDecoder.this.collectMissingFields(0L));
                }
                return ReflectionObjectDecoder.this.createNewObject(iter, temp);
            }
            Map extra = null;
            long tracker = 0L;
            Slice fieldName = CodegenAccess.readObjectFieldAsSlice(iter);
            Binding binding = (Binding)ReflectionObjectDecoder.this.allBindings.get(fieldName);
            if (binding == null) {
                extra = ReflectionObjectDecoder.this.onUnknownProperty(iter, fieldName, extra);
            } else {
                if (binding.asMissingWhenNotPresent) {
                    tracker |= binding.mask;
                }
                temp[binding.idx] = ReflectionObjectDecoder.this.decodeBinding(iter, binding);
            }
            while (CodegenAccess.nextToken(iter) == 44) {
                fieldName = CodegenAccess.readObjectFieldAsSlice(iter);
                binding = (Binding)ReflectionObjectDecoder.this.allBindings.get(fieldName);
                if (binding == null) {
                    extra = ReflectionObjectDecoder.this.onUnknownProperty(iter, fieldName, extra);
                    continue;
                }
                if (binding.asMissingWhenNotPresent) {
                    tracker |= binding.mask;
                }
                temp[binding.idx] = ReflectionObjectDecoder.this.decodeBinding(iter, binding);
            }
            if (tracker != ReflectionObjectDecoder.this.expectedTracker) {
                throw new JsonException("missing required properties: " + ReflectionObjectDecoder.this.collectMissingFields(tracker));
            }
            Object obj = ReflectionObjectDecoder.this.createNewObject(iter, temp);
            ReflectionObjectDecoder.this.setExtra(obj, extra);
            for (Binding field : ((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.fields) {
                val = temp[field.idx];
                if (val == NOT_SET || field.fromNames.length <= 0) continue;
                field.field.set(obj, val);
            }
            for (Binding setter : ((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.setters) {
                val = temp[setter.idx];
                if (val == NOT_SET) continue;
                setter.method.invoke(obj, val);
            }
            ReflectionObjectDecoder.this.applyWrappers(temp, obj);
            return obj;
        }
    }

    public class OnlyField
    implements Decoder {
        @Override
        public Object decode(JsonIterator iter) throws IOException {
            try {
                return this.decode_(iter);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }

        private Object decode_(JsonIterator iter) throws Exception {
            Object obj;
            if (iter.readNull()) {
                CodegenAccess.resetExistingObject(iter);
                return null;
            }
            Object object = obj = CodegenAccess.existingObject(iter) == null ? ReflectionObjectDecoder.this.createNewObject(new Object[0]) : CodegenAccess.resetExistingObject(iter);
            if (!CodegenAccess.readObjectStart(iter)) {
                if (ReflectionObjectDecoder.this.requiredIdx > 0) {
                    if (((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.onMissingProperties == null) {
                        throw new JsonException("missing required properties: " + ReflectionObjectDecoder.this.collectMissingFields(0L));
                    }
                    ReflectionObjectDecoder.this.setToBinding(obj, ((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.onMissingProperties, ReflectionObjectDecoder.this.collectMissingFields(0L));
                }
                return obj;
            }
            Map extra = null;
            long tracker = 0L;
            Slice fieldName = CodegenAccess.readObjectFieldAsSlice(iter);
            Binding binding = (Binding)ReflectionObjectDecoder.this.allBindings.get(fieldName);
            if (binding == null) {
                extra = ReflectionObjectDecoder.this.onUnknownProperty(iter, fieldName, extra);
            } else {
                if (binding.asMissingWhenNotPresent) {
                    tracker |= binding.mask;
                }
                ReflectionObjectDecoder.this.setToBinding(obj, binding, ReflectionObjectDecoder.this.decodeBinding(iter, obj, binding));
            }
            while (CodegenAccess.nextToken(iter) == 44) {
                fieldName = CodegenAccess.readObjectFieldAsSlice(iter);
                binding = (Binding)ReflectionObjectDecoder.this.allBindings.get(fieldName);
                if (binding == null) {
                    extra = ReflectionObjectDecoder.this.onUnknownProperty(iter, fieldName, extra);
                    continue;
                }
                if (binding.asMissingWhenNotPresent) {
                    tracker |= binding.mask;
                }
                ReflectionObjectDecoder.this.setToBinding(obj, binding, ReflectionObjectDecoder.this.decodeBinding(iter, obj, binding));
            }
            if (tracker != ReflectionObjectDecoder.this.expectedTracker) {
                if (((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.onMissingProperties == null) {
                    throw new JsonException("missing required properties: " + ReflectionObjectDecoder.this.collectMissingFields(tracker));
                }
                ReflectionObjectDecoder.this.setToBinding(obj, ((ReflectionObjectDecoder)ReflectionObjectDecoder.this).desc.onMissingProperties, ReflectionObjectDecoder.this.collectMissingFields(tracker));
            }
            ReflectionObjectDecoder.this.setExtra(obj, extra);
            return obj;
        }
    }
}

