/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

public class Slice {
    private byte[] data;
    private int head;
    private int tail;
    private int hash;

    public Slice(byte[] data, int head, int tail) {
        this.data = data;
        this.head = head;
        this.tail = tail;
    }

    public void reset(byte[] data, int head, int tail) {
        this.data = data;
        this.head = head;
        this.tail = tail;
        this.hash = 0;
    }

    public final byte at(int pos) {
        return this.data[this.head + pos];
    }

    public final int len() {
        return this.tail - this.head;
    }

    public final byte[] data() {
        return this.data;
    }

    public final int head() {
        return this.head;
    }

    public final int tail() {
        return this.tail;
    }

    public static Slice make(String str) {
        byte[] data = str.getBytes();
        return new Slice(data, 0, data.length);
    }

    public final boolean equals(Object o) {
        Slice slice = (Slice)o;
        if (this.tail - this.head != slice.tail - slice.head) {
            return false;
        }
        int i = this.head;
        int j = slice.head;
        while (i < this.tail) {
            if (this.data[i] != slice.data[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public final int hashCode() {
        if (this.hash == 0 && this.tail - this.head > 0) {
            for (int i = this.head; i < this.tail; ++i) {
                this.hash = 31 * this.hash + this.data[i];
            }
        }
        return this.hash;
    }

    public String toString() {
        return new String(this.data, this.head, this.tail - this.head);
    }
}

