package iip.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.oktoflow.platform.support.json.jackson.JsonUtils;
import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingCommand.
 * Generated by: EASy-Producer.
 */
public class RoutingCommandOldSerializer {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    static {
        JsonUtils.handleIipDataClasses(MAPPER);
    }

    /**
     * Turns serialized data to an object.
     * 
     * @param data the data
     * @return the object
     * @throws IOException if deserialization fails
     */
    public RoutingCommandOld from(byte[] data) throws IOException {
        try {
            return MAPPER.readValue(data, RoutingCommandOldImpl.class);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    /**
     * Serializes an object.
     * 
     * @param source the source object
     * @return the serialized data
     * @throws IOException if serialization fails
     */
    public byte[] to(RoutingCommandOld source) throws IOException {
        try {
            return MAPPER.writeValueAsBytes(source);
        } catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    /**
     * Creates a cloned copy.
     * 
     * @param origin the original object
     * @return the copied object
     * @throws IOException if cloning fails
     */
    public RoutingCommandOld clone(RoutingCommandOld origin) throws IOException {
        return new RoutingCommandOldImpl(origin);
    }

    /**
     * Returns the handled type.
     * 
     * @return the type
     */
    public Class<RoutingCommandOld> getType() {
        return RoutingCommandOld.class;
    }

}
