/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.jsoniter.output.MapKeyEncoders;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;

class ReflectionMapEncoder
implements Encoder.ReflectionEncoder {
    private final TypeLiteral valueTypeLiteral;
    private final Encoder mapKeyEncoder;

    public ReflectionMapEncoder(Class clazz, Type[] typeArgs) {
        Object keyType = Object.class;
        Object valueType = Object.class;
        if (typeArgs.length == 2) {
            keyType = typeArgs[0];
            valueType = typeArgs[1];
        }
        this.mapKeyEncoder = MapKeyEncoders.registerOrGetExisting(keyType);
        this.valueTypeLiteral = TypeLiteral.create(valueType);
    }

    @Override
    public void encode(Object obj, JsonStream stream) throws IOException {
        if (obj == null) {
            stream.writeNull();
            return;
        }
        Map map = (Map)obj;
        Iterator iter = map.entrySet().iterator();
        if (!iter.hasNext()) {
            stream.write((byte)123, (byte)125);
            return;
        }
        stream.writeObjectStart();
        boolean notFirst = false;
        Map.Entry<Object, Object> entry = iter.next();
        notFirst = this.writeEntry(stream, notFirst, entry);
        while (iter.hasNext()) {
            entry = iter.next();
            notFirst = this.writeEntry(stream, notFirst, entry);
        }
        stream.writeObjectEnd();
    }

    private boolean writeEntry(JsonStream stream, boolean notFirst, Map.Entry<Object, Object> entry) throws IOException {
        if (notFirst) {
            stream.writeMore();
        } else {
            stream.writeIndention();
            notFirst = true;
        }
        stream.writeObjectField(entry.getKey(), this.mapKeyEncoder);
        stream.writeVal(this.valueTypeLiteral, entry.getValue());
        return notFirst;
    }

    @Override
    public Any wrap(Object obj) {
        Map map = (Map)obj;
        return Any.wrap(map);
    }
}

