/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

import com.jsoniter.annotation.JsonCreator;
import com.jsoniter.annotation.JsonExtraProperties;
import com.jsoniter.annotation.JsonIgnore;
import com.jsoniter.annotation.JsonMissingProperties;
import com.jsoniter.annotation.JsonObject;
import com.jsoniter.annotation.JsonProperty;
import com.jsoniter.annotation.JsonUnwrapper;
import com.jsoniter.annotation.JsonWrapper;
import com.jsoniter.annotation.JsonWrapperType;
import com.jsoniter.output.EncodingMode;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.DecodingMode;
import com.jsoniter.spi.EmptyExtension;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.GenericsHelper;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.OmitValue;
import com.jsoniter.spi.TypeLiteral;
import com.jsoniter.spi.UnwrapperDescriptor;
import com.jsoniter.spi.WrapperDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Config
extends EmptyExtension {
    private final String configName;
    private final Builder builder;
    private static volatile Map<String, Config> configs = new HashMap<String, Config>();
    private volatile Map<Type, String> decoderCacheKeys = new HashMap<Type, String>();
    private volatile Map<Type, String> encoderCacheKeys = new HashMap<Type, String>();
    private static final Map<Class, OmitValue> primitiveOmitValues = new HashMap<Class, OmitValue>(){
        {
            this.put(Boolean.TYPE, new OmitValue.False());
            this.put(Character.TYPE, new OmitValue.ZeroChar());
            this.put(Byte.TYPE, new OmitValue.ZeroByte());
            this.put(Short.TYPE, new OmitValue.ZeroShort());
            this.put(Integer.TYPE, new OmitValue.ZeroInt());
            this.put(Long.TYPE, new OmitValue.ZeroLong());
            this.put(Float.TYPE, new OmitValue.ZeroFloat());
            this.put(Double.TYPE, new OmitValue.ZeroDouble());
        }
    };
    public static final Config INSTANCE = new Builder().build();

    protected Config(String configName, Builder builder) {
        this.configName = configName;
        this.builder = builder;
    }

    public String configName() {
        return this.configName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDecoderCacheKey(Type type) {
        String cacheKey = this.decoderCacheKeys.get(type);
        if (cacheKey != null) {
            return cacheKey;
        }
        Config config = this;
        synchronized (config) {
            cacheKey = this.decoderCacheKeys.get(type);
            if (cacheKey != null) {
                return cacheKey;
            }
            cacheKey = TypeLiteral.create(type).getDecoderCacheKey(this.configName);
            HashMap<Type, String> newCache = new HashMap<Type, String>(this.decoderCacheKeys);
            newCache.put(type, cacheKey);
            this.decoderCacheKeys = newCache;
            return cacheKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoderCacheKey(Type type) {
        String cacheKey = this.encoderCacheKeys.get(type);
        if (cacheKey != null) {
            return cacheKey;
        }
        Config config = this;
        synchronized (config) {
            cacheKey = this.encoderCacheKeys.get(type);
            if (cacheKey != null) {
                return cacheKey;
            }
            cacheKey = TypeLiteral.create(type).getEncoderCacheKey(this.configName);
            HashMap<Type, String> newCache = new HashMap<Type, String>(this.encoderCacheKeys);
            newCache.put(type, cacheKey);
            this.encoderCacheKeys = newCache;
            return cacheKey;
        }
    }

    public DecodingMode decodingMode() {
        return this.builder.decodingMode;
    }

    protected Builder builder() {
        return this.builder;
    }

    public Builder copyBuilder() {
        return this.builder.copy();
    }

    public int indentionStep() {
        return this.builder.indentionStep;
    }

    public boolean omitDefaultValue() {
        return this.builder.omitDefaultValue;
    }

    public boolean escapeUnicode() {
        return this.builder.escapeUnicode;
    }

    public EncodingMode encodingMode() {
        return this.builder.encodingMode;
    }

    @Override
    public void updateClassDescriptor(ClassDescriptor desc) {
        JsonObject jsonObject = desc.clazz.getAnnotation(JsonObject.class);
        if (jsonObject != null) {
            Binding binding;
            if (jsonObject.asExtraForUnknownProperties()) {
                desc.asExtraForUnknownProperties = true;
            }
            for (String fieldName : jsonObject.unknownPropertiesWhitelist()) {
                binding = new Binding(desc.classInfo, desc.lookup, (Type)((Object)Object.class));
                binding.name = fieldName;
                binding.fromNames = new String[]{binding.name};
                binding.toNames = new String[0];
                binding.shouldSkip = true;
                desc.fields.add(binding);
            }
            for (String fieldName : jsonObject.unknownPropertiesBlacklist()) {
                binding = new Binding(desc.classInfo, desc.lookup, (Type)((Object)Object.class));
                binding.name = fieldName;
                binding.fromNames = new String[]{binding.name};
                binding.toNames = new String[0];
                binding.asExtraWhenPresent = true;
                desc.fields.add(binding);
            }
        }
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Class current = desc.clazz; current != null; current = current.getSuperclass()) {
            allMethods.addAll(Arrays.asList(current.getDeclaredMethods()));
        }
        this.updateBindings(desc);
        this.detectCtor(desc);
        this.detectStaticFactory(desc, allMethods);
        this.detectWrappers(desc, allMethods);
        this.detectUnwrappers(desc, allMethods);
    }

    private void detectUnwrappers(ClassDescriptor desc, List<Method> allMethods) {
        for (Method method : allMethods) {
            if (Modifier.isStatic(method.getModifiers()) || this.getJsonUnwrapper(method.getAnnotations()) == null) continue;
            desc.unwrappers.add(new UnwrapperDescriptor(method));
        }
    }

    private void detectWrappers(ClassDescriptor desc, List<Method> allMethods) {
        for (Method method : allMethods) {
            JsonWrapper jsonWrapper;
            if (Modifier.isStatic(method.getModifiers()) || (jsonWrapper = this.getJsonWrapper(method.getAnnotations())) == null) continue;
            Annotation[][] annotations = method.getParameterAnnotations();
            String[] paramNames = this.getParamNames(method, annotations.length);
            Iterator<Binding> iter = desc.setters.iterator();
            while (iter.hasNext()) {
                if (!method.equals(iter.next().method)) continue;
                iter.remove();
            }
            if (JsonWrapperType.BINDING.equals((Object)jsonWrapper.value())) {
                WrapperDescriptor wrapper = new WrapperDescriptor();
                wrapper.method = method;
                for (int i = 0; i < annotations.length; ++i) {
                    Annotation[] paramAnnotations = annotations[i];
                    Binding binding = new Binding(desc.classInfo, desc.lookup, method.getGenericParameterTypes()[i]);
                    JsonProperty jsonProperty = this.getJsonProperty(paramAnnotations);
                    if (jsonProperty != null) {
                        this.updateBindingWithJsonProperty(binding, jsonProperty);
                    }
                    if (binding.name == null || binding.name.length() == 0) {
                        binding.name = paramNames[i];
                    }
                    binding.fromNames = new String[]{binding.name};
                    binding.toNames = new String[]{binding.name};
                    binding.annotations = paramAnnotations;
                    wrapper.parameters.add(binding);
                }
                desc.bindingTypeWrappers.add(wrapper);
                continue;
            }
            if (JsonWrapperType.KEY_VALUE.equals((Object)jsonWrapper.value())) {
                desc.keyValueTypeWrappers.add(method);
                continue;
            }
            throw new JsonException("unknown json wrapper type: " + (Object)((Object)jsonWrapper.value()));
        }
    }

    private String[] getParamNames(Object obj, int paramCount) {
        String[] paramNames = new String[paramCount];
        try {
            Object params = this.reflectCall(obj, "getParameters", new Object[0]);
            for (int i = 0; i < paramNames.length; ++i) {
                paramNames[i] = (String)this.reflectCall(Array.get(params, i), "getName", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paramNames;
    }

    private Object reflectCall(Object obj, String methodName, Object ... args) throws Exception {
        Method method = obj.getClass().getMethod(methodName, new Class[0]);
        return method.invoke(obj, args);
    }

    private void detectStaticFactory(ClassDescriptor desc, List<Method> allMethods) {
        for (Method method : allMethods) {
            JsonCreator jsonCreator;
            if (!Modifier.isStatic(method.getModifiers()) || (jsonCreator = this.getJsonCreator(method.getAnnotations())) == null) continue;
            desc.ctor.staticMethodName = method.getName();
            desc.ctor.staticFactory = method;
            desc.ctor.ctor = null;
            Annotation[][] annotations = method.getParameterAnnotations();
            String[] paramNames = this.getParamNames(method, annotations.length);
            for (int i = 0; i < annotations.length; ++i) {
                Annotation[] paramAnnotations = annotations[i];
                JsonProperty jsonProperty = this.getJsonProperty(paramAnnotations);
                Binding binding = new Binding(desc.classInfo, desc.lookup, method.getGenericParameterTypes()[i]);
                if (jsonProperty != null) {
                    this.updateBindingWithJsonProperty(binding, jsonProperty);
                }
                if (binding.name == null || binding.name.length() == 0) {
                    binding.name = paramNames[i];
                }
                binding.fromNames = new String[]{binding.name};
                binding.toNames = new String[]{binding.name};
                binding.annotations = paramAnnotations;
                desc.ctor.parameters.add(binding);
            }
        }
    }

    private void detectCtor(ClassDescriptor desc) {
        if (desc.ctor == null) {
            return;
        }
        for (Constructor<?> ctor : desc.clazz.getDeclaredConstructors()) {
            JsonCreator jsonCreator = this.getJsonCreator(ctor.getAnnotations());
            if (jsonCreator == null) continue;
            desc.ctor.staticMethodName = null;
            desc.ctor.ctor = ctor;
            desc.ctor.staticFactory = null;
            Annotation[][] annotations = ctor.getParameterAnnotations();
            String[] paramNames = this.getParamNames(ctor, annotations.length);
            for (int i = 0; i < annotations.length; ++i) {
                Annotation[] paramAnnotations = annotations[i];
                JsonProperty jsonProperty = this.getJsonProperty(paramAnnotations);
                Binding binding = new Binding(desc.classInfo, desc.lookup, ctor.getGenericParameterTypes()[i]);
                if (jsonProperty != null) {
                    this.updateBindingWithJsonProperty(binding, jsonProperty);
                }
                if (binding.name == null || binding.name.length() == 0) {
                    binding.name = paramNames[i];
                }
                binding.fromNames = new String[]{binding.name};
                binding.toNames = new String[]{binding.name};
                binding.annotations = paramAnnotations;
                desc.ctor.parameters.add(binding);
            }
        }
    }

    private void updateBindings(ClassDescriptor desc) {
        boolean globalOmitDefault = JsoniterSpi.getCurrentConfig().omitDefaultValue();
        for (Binding binding : desc.allBindings()) {
            JsonProperty jsonProperty;
            JsonUnwrapper jsonUnwrapper;
            boolean annotated = false;
            JsonIgnore jsonIgnore = this.getJsonIgnore(binding.annotations);
            if (jsonIgnore != null) {
                annotated = true;
                if (jsonIgnore.ignoreDecoding()) {
                    binding.fromNames = new String[0];
                }
                if (jsonIgnore.ignoreEncoding()) {
                    binding.toNames = new String[0];
                }
            }
            if ((jsonUnwrapper = this.getJsonUnwrapper(binding.annotations)) != null) {
                annotated = true;
                binding.fromNames = new String[0];
                binding.toNames = new String[0];
            }
            if (globalOmitDefault) {
                binding.defaultValueToOmit = this.createOmitValue(binding.valueType);
            }
            if ((jsonProperty = this.getJsonProperty(binding.annotations)) != null) {
                annotated = true;
                this.updateBindingWithJsonProperty(binding, jsonProperty);
            }
            if (Config.getAnnotation(binding.annotations, JsonMissingProperties.class) != null) {
                annotated = true;
                binding.fromNames = new String[0];
                desc.onMissingProperties = binding;
            }
            if (Config.getAnnotation(binding.annotations, JsonExtraProperties.class) != null) {
                annotated = true;
                binding.fromNames = new String[0];
                desc.onExtraProperties = binding;
            }
            if (!annotated || binding.field == null) continue;
            if (desc.setters != null) {
                for (Binding setter : desc.setters) {
                    if (!binding.field.getName().equals(setter.name)) continue;
                    setter.fromNames = new String[0];
                    setter.toNames = new String[0];
                }
            }
            if (desc.getters == null) continue;
            for (Binding getter : desc.getters) {
                if (!binding.field.getName().equals(getter.name)) continue;
                getter.fromNames = new String[0];
                getter.toNames = new String[0];
            }
        }
    }

    private void updateBindingWithJsonProperty(Binding binding, JsonProperty jsonProperty) {
        Class<? extends Encoder> encoderClass;
        Class<? extends Decoder> decoderClass;
        String altName;
        binding.asMissingWhenNotPresent = jsonProperty.required();
        binding.isNullable = jsonProperty.nullable();
        binding.isCollectionValueNullable = jsonProperty.collectionValueNullable();
        String defaultValueToOmit = jsonProperty.defaultValueToOmit();
        if (!defaultValueToOmit.isEmpty()) {
            binding.defaultValueToOmit = OmitValue.Parsed.parse(binding.valueType, defaultValueToOmit);
        }
        if (!(altName = jsonProperty.value()).isEmpty()) {
            if (binding.name == null) {
                binding.name = altName;
            }
            binding.fromNames = new String[]{altName};
            binding.toNames = new String[]{altName};
        }
        if (jsonProperty.from().length > 0) {
            binding.fromNames = jsonProperty.from();
        }
        if (jsonProperty.to().length > 0) {
            binding.toNames = jsonProperty.to();
        }
        if ((decoderClass = jsonProperty.decoder()) != Decoder.class) {
            try {
                try {
                    Constructor<? extends Decoder> decoderCtor = decoderClass.getConstructor(Binding.class);
                    binding.decoder = decoderCtor.newInstance(binding);
                }
                catch (NoSuchMethodException e) {
                    binding.decoder = decoderClass.newInstance();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }
        if ((encoderClass = jsonProperty.encoder()) != Encoder.class) {
            try {
                try {
                    Constructor<? extends Encoder> encoderCtor = encoderClass.getConstructor(Binding.class);
                    binding.encoder = encoderCtor.newInstance(binding);
                }
                catch (NoSuchMethodException e) {
                    binding.encoder = encoderClass.newInstance();
                }
            }
            catch (JsonException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }
        if (jsonProperty.implementation() != Object.class) {
            binding.valueType = GenericsHelper.useImpl(binding.valueType, jsonProperty.implementation());
            binding.valueTypeLiteral = TypeLiteral.create(binding.valueType);
        }
    }

    protected OmitValue createOmitValue(Type valueType) {
        OmitValue omitValue = primitiveOmitValues.get(valueType);
        if (omitValue != null) {
            return omitValue;
        }
        return new OmitValue.Null();
    }

    protected JsonWrapper getJsonWrapper(Annotation[] annotations) {
        return Config.getAnnotation(annotations, JsonWrapper.class);
    }

    protected JsonUnwrapper getJsonUnwrapper(Annotation[] annotations) {
        return Config.getAnnotation(annotations, JsonUnwrapper.class);
    }

    protected JsonCreator getJsonCreator(Annotation[] annotations) {
        return Config.getAnnotation(annotations, JsonCreator.class);
    }

    protected JsonProperty getJsonProperty(Annotation[] annotations) {
        return Config.getAnnotation(annotations, JsonProperty.class);
    }

    protected JsonIgnore getJsonIgnore(Annotation[] annotations) {
        return Config.getAnnotation(annotations, JsonIgnore.class);
    }

    protected static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    public static class Builder {
        private DecodingMode decodingMode;
        private EncodingMode encodingMode;
        private int indentionStep;
        private boolean escapeUnicode = true;
        private boolean omitDefaultValue = false;

        public Builder() {
            String envMode = System.getenv("JSONITER_DECODING_MODE");
            this.decodingMode = envMode != null ? DecodingMode.valueOf(envMode) : DecodingMode.REFLECTION_MODE;
            envMode = System.getenv("JSONITER_ENCODING_MODE");
            this.encodingMode = envMode != null ? EncodingMode.valueOf(envMode) : EncodingMode.REFLECTION_MODE;
        }

        public Builder decodingMode(DecodingMode decodingMode) {
            this.decodingMode = decodingMode;
            return this;
        }

        public Builder encodingMode(EncodingMode encodingMode) {
            this.encodingMode = encodingMode;
            return this;
        }

        public Builder indentionStep(int indentionStep) {
            this.indentionStep = indentionStep;
            return this;
        }

        public Builder omitDefaultValue(boolean omitDefaultValue) {
            this.omitDefaultValue = omitDefaultValue;
            return this;
        }

        public Builder escapeUnicode(boolean escapeUnicode) {
            this.escapeUnicode = escapeUnicode;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Config build() {
            String configName = JsoniterSpi.assignConfigName(this);
            Config config = (Config)configs.get(configName);
            if (config != null) {
                return config;
            }
            Class<Config> clazz = Config.class;
            synchronized (Config.class) {
                config = (Config)configs.get(configName);
                if (config != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return config;
                }
                config = this.doBuild(configName);
                HashMap<String, Config> newCache = new HashMap<String, Config>(configs);
                newCache.put(configName, config);
                configs = newCache;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return config;
            }
        }

        protected Config doBuild(String configName) {
            return new Config(configName, this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            if (this.indentionStep != builder.indentionStep) {
                return false;
            }
            if (this.escapeUnicode != builder.escapeUnicode) {
                return false;
            }
            if (this.decodingMode != builder.decodingMode) {
                return false;
            }
            if (this.omitDefaultValue != builder.omitDefaultValue) {
                return false;
            }
            return this.encodingMode == builder.encodingMode;
        }

        public int hashCode() {
            int result = this.decodingMode != null ? this.decodingMode.hashCode() : 0;
            result = 31 * result + (this.encodingMode != null ? this.encodingMode.hashCode() : 0);
            result = 31 * result + this.indentionStep;
            result = 31 * result + (this.escapeUnicode ? 1 : 0);
            result = 31 * result + (this.omitDefaultValue ? 1 : 0);
            return result;
        }

        public Builder copy() {
            Builder builder = new Builder();
            builder.encodingMode = this.encodingMode;
            builder.decodingMode = this.decodingMode;
            builder.indentionStep = this.indentionStep;
            builder.escapeUnicode = this.escapeUnicode;
            builder.omitDefaultValue = this.omitDefaultValue;
            return builder;
        }

        public String toString() {
            return "Config{decodingMode=" + (Object)((Object)this.decodingMode) + ", encodingMode=" + (Object)((Object)this.encodingMode) + ", indentionStep=" + this.indentionStep + ", escapeUnicode=" + this.escapeUnicode + ", omitDefaultValue=" + this.omitDefaultValue + '}';
        }
    }
}

