/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

import com.jsoniter.spi.JsonException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class GenericsHelper {
    public static GenericArrayType createGenericArrayType(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    public static ParameterizedType createParameterizedType(Type[] actualTypeArguments, Type ownerType, Type rawType) {
        return new ParameterizedTypeImpl(actualTypeArguments, ownerType, rawType);
    }

    public static boolean isSameClass(Type type, Class clazz) {
        if (type == clazz) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return pType.getRawType() == clazz;
        }
        return false;
    }

    public static Type useImpl(Type type, Class clazz) {
        if (type instanceof Class) {
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return GenericsHelper.createParameterizedType(pType.getActualTypeArguments(), pType.getOwnerType(), clazz);
        }
        throw new JsonException("can not change impl for: " + type);
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Type ownerType;
        private final Type rawType;

        public ParameterizedTypeImpl(Type[] actualTypeArguments, Type ownerType, Type rawType) {
            this.actualTypeArguments = actualTypeArguments;
            this.ownerType = ownerType;
            this.rawType = rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
            if (!Arrays.equals(this.actualTypeArguments, that.actualTypeArguments)) {
                return false;
            }
            if (this.ownerType != null ? !this.ownerType.equals(that.ownerType) : that.ownerType != null) {
                return false;
            }
            return this.rawType != null ? this.rawType.equals(that.rawType) : that.rawType == null;
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.actualTypeArguments);
            result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
            result = 31 * result + (this.rawType != null ? this.rawType.hashCode() : 0);
            return result;
        }

        public String toString() {
            String rawTypeName = this.rawType.toString();
            if (this.rawType instanceof Class) {
                Class clazz = (Class)this.rawType;
                rawTypeName = clazz.getName();
            }
            return "ParameterizedTypeImpl{actualTypeArguments=" + Arrays.toString(this.actualTypeArguments) + ", ownerType=" + this.ownerType + ", rawType=" + rawTypeName + '}';
        }
    }

    private static class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        GenericArrayTypeImpl(Type componentType) {
            this.componentType = componentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericArrayTypeImpl that = (GenericArrayTypeImpl)o;
            return this.componentType != null ? this.componentType.equals(that.componentType) : that.componentType == null;
        }

        public int hashCode() {
            return this.componentType != null ? this.componentType.hashCode() : 0;
        }

        public String toString() {
            return "GenericArrayTypeImpl{componentType=" + this.componentType + '}';
        }
    }
}

