/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.json.jackson;

import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.spi.JsonException;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class JsoniterAny
implements de.iip_ecosphere.platform.support.json.JsonIterator {
    private static final Class<?> LAZY_ANY_CLS;
    private static final Field LAZY_ANY_HEAD_FIELD;
    private static final Field LAZY_ANY_TAIL_FIELD;
    private static final Map<ValueType, JsonIterator.ValueType> IMPL_TYPE2TYPE;
    private Any any;

    JsoniterAny(Any any) {
        this.any = any;
    }

    public JsonIterator.ValueType valueType() {
        return IMPL_TYPE2TYPE.get(this.any.valueType());
    }

    public boolean containsKey(String key) {
        return this.any.keys().contains(key);
    }

    public de.iip_ecosphere.platform.support.json.JsonIterator get(String key) {
        Any tmp = this.any.get((Object)key);
        return null == tmp ? null : new JsoniterAny(tmp);
    }

    public byte[] slice(byte[] data, de.iip_ecosphere.platform.support.json.JsonIterator iter) throws IOException {
        byte[] topData;
        boolean deserialized = false;
        Any nested = ((JsoniterAny)iter).any;
        if (nested.valueType() == ValueType.STRING) {
            nested = JsonIterator.deserialize((String)nested.toString());
            deserialized = true;
        }
        byte[] actData = topData = data;
        if (LAZY_ANY_CLS.isInstance(nested)) {
            try {
                int head = (Integer)LAZY_ANY_HEAD_FIELD.get(nested);
                int tail = (Integer)LAZY_ANY_TAIL_FIELD.get(nested);
                actData = new byte[tail - head];
                System.arraycopy(topData, head, actData, 0, actData.length);
                if (deserialized) {
                    String tmp = JsonUtils.unescape((String)new String(actData));
                    actData = tmp.getBytes();
                }
            }
            catch (IllegalAccessException e) {
                throw new IOException("Cannot determine head/tail to slice input data: " + e.getMessage());
            }
        }
        return actData;
    }

    public int size() {
        int size = 0;
        try {
            size = this.any.size();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            size = 0;
            LoggerFactory.getLogger((Object)this).warn("Cannot read JSON due to syntax errors: {}", (Object)LoggerFactory.classAndMessage((Throwable)e));
        }
        return size;
    }

    public de.iip_ecosphere.platform.support.json.JsonIterator get(int index) {
        return new JsoniterAny(this.any.get(index));
    }

    public JsonIterator.EntryIterator entries() {
        final Any.EntryIterator iter = this.any.entries();
        return new JsonIterator.EntryIterator(){

            public boolean next() {
                return iter.next();
            }

            public String key() {
                return iter.key();
            }

            public de.iip_ecosphere.platform.support.json.JsonIterator value() {
                return new JsoniterAny(iter.value());
            }
        };
    }

    public String getAnyKey() {
        String result;
        try {
            result = ((String)this.any.asMap().keySet().iterator().next()).toString();
        }
        catch (ClassCastException e) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return this.any.toString();
    }

    public String toStringValue() throws IOException {
        try {
            return this.any.toString();
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public double toDoubleValue() throws IOException {
        try {
            return this.any.toDouble();
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public float toFloatValue() throws IOException {
        try {
            return this.any.toFloat();
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public long toLongValue() throws IOException {
        try {
            return this.any.toLong();
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public boolean toBooleanValue() throws IOException {
        try {
            return this.any.toBoolean();
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public int toIntValue() throws IOException {
        try {
            return this.any.toInt();
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public BigInteger toBigIntegerValue() throws IOException {
        try {
            return this.any.toBigInteger();
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public BigDecimal toBigDecimalValue() throws IOException {
        try {
            return this.any.toBigDecimal();
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }

    public Map<String, Object> asMap() throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Any.EntryIterator iter = this.any.entries();
        while (iter.next()) {
            String key = iter.key();
            Any value = iter.value();
            this.collectAll(key, value, result);
        }
        return result;
    }

    private void collectAll(String name, Any any, Map<String, Object> fields) {
        Any.EntryIterator iter = any.entries();
        HashMap<String, Object> nested = null;
        while (iter.next()) {
            if (null == nested) {
                nested = new HashMap<String, Object>();
            }
            String key = iter.key();
            Any value = iter.value();
            this.collectAll(key, value, nested);
            fields.put(name, nested);
        }
        if (null == nested) {
            fields.put(name, any.object());
        }
    }

    static {
        IMPL_TYPE2TYPE = new HashMap<ValueType, JsonIterator.ValueType>();
        Class cls = JsoniterAny.class;
        Field hf = null;
        Field tf = null;
        try {
            cls = Class.forName("com.jsoniter.any.LazyAny");
            hf = cls.getDeclaredField("head");
            hf.setAccessible(true);
            tf = cls.getDeclaredField("tail");
            tf.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            LoggerFactory.getLogger(JsoniterAny.class).error("Cannot find LazyAny class or its fields: " + e.getMessage() + " Disabling JSON stepIn-slicing.");
        }
        if (tf == null) {
            cls = JsoniterAny.class;
            tf = null;
        }
        LAZY_ANY_CLS = cls;
        LAZY_ANY_HEAD_FIELD = hf;
        LAZY_ANY_TAIL_FIELD = tf;
        IMPL_TYPE2TYPE.put(ValueType.INVALID, JsonIterator.ValueType.INVALID);
        IMPL_TYPE2TYPE.put(ValueType.STRING, JsonIterator.ValueType.STRING);
        IMPL_TYPE2TYPE.put(ValueType.NUMBER, JsonIterator.ValueType.NUMBER);
        IMPL_TYPE2TYPE.put(ValueType.NULL, JsonIterator.ValueType.NULL);
        IMPL_TYPE2TYPE.put(ValueType.BOOLEAN, JsonIterator.ValueType.BOOLEAN);
        IMPL_TYPE2TYPE.put(ValueType.ARRAY, JsonIterator.ValueType.ARRAY);
        IMPL_TYPE2TYPE.put(ValueType.OBJECT, JsonIterator.ValueType.OBJECT);
    }
}

