/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.metrics.micrometer;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Clock;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MeterFilter;
import de.iip_ecosphere.platform.support.metrics.MeterRegistry;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.oktoflow.platform.support.metrics.micrometer.AbstractMeter;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerClock;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerCounter;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerGauge;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerMeterFilter;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerTimer;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerUtils;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.search.MeterNotFoundException;
import io.micrometer.core.instrument.search.RequiredSearch;
import java.util.ArrayList;
import java.util.List;

class MicrometerMeterRegistry
implements de.iip_ecosphere.platform.support.metrics.MeterRegistry,
MeterRegistry.Config {
    private MeterRegistry registry;

    MicrometerMeterRegistry(MeterRegistry registry) {
        this.registry = registry;
    }

    public MeterRegistry.Config config() {
        return this;
    }

    public de.iip_ecosphere.platform.support.metrics.Meter remove(de.iip_ecosphere.platform.support.metrics.Meter meter) {
        return null == meter ? null : this.remove(meter.getName());
    }

    public de.iip_ecosphere.platform.support.metrics.Meter remove(String name) {
        de.iip_ecosphere.platform.support.metrics.Meter result;
        try {
            result = MicrometerMeterRegistry.wrap(this.registry.remove(this.registry.get(name).meter()), de.iip_ecosphere.platform.support.metrics.Meter.class);
        }
        catch (MeterNotFoundException e) {
            result = null;
        }
        return result;
    }

    public de.iip_ecosphere.platform.support.metrics.Meter remove(Meter.Id id) {
        de.iip_ecosphere.platform.support.metrics.Meter result;
        if (id instanceof AbstractMeter.MicrometerId) {
            result = MicrometerMeterRegistry.wrap(this.registry.remove(MicrometerUtils.idValue(id)), de.iip_ecosphere.platform.support.metrics.Meter.class);
        } else {
            LoggerFactory.getLogger((Object)this).warn("Cannot convert {} to {}", (Object)id, (Object)AbstractMeter.MicrometerId.class.getName());
            result = null;
        }
        return result;
    }

    static <T extends de.iip_ecosphere.platform.support.metrics.Meter> T wrap(Meter meter, Class<T> filter) {
        AbstractMeter result = null;
        if (MicrometerMeterRegistry.applies(filter, Gauge.class) && meter instanceof io.micrometer.core.instrument.Gauge) {
            result = new MicrometerGauge((io.micrometer.core.instrument.Gauge)meter);
        } else if (MicrometerMeterRegistry.applies(filter, Timer.class) && meter instanceof io.micrometer.core.instrument.Timer) {
            result = new MicrometerTimer((io.micrometer.core.instrument.Timer)meter);
        } else if (MicrometerMeterRegistry.applies(filter, de.iip_ecosphere.platform.support.metrics.Counter.class) && meter instanceof Counter) {
            result = new MicrometerCounter((Counter)meter);
        } else if (MicrometerMeterRegistry.applies(filter, de.iip_ecosphere.platform.support.metrics.Meter.class) && meter != null) {
            result = new GenericMeterWrapper(meter);
        }
        return (T)((de.iip_ecosphere.platform.support.metrics.Meter)filter.cast(result));
    }

    static boolean applies(Class<? extends de.iip_ecosphere.platform.support.metrics.Meter> filter, Class<? extends de.iip_ecosphere.platform.support.metrics.Meter> provided) {
        return filter == de.iip_ecosphere.platform.support.metrics.Meter.class || filter == provided;
    }

    public de.iip_ecosphere.platform.support.metrics.Meter getMeter(String name) {
        return MicrometerMeterRegistry.wrap(this.getMeterImpl(name, null), de.iip_ecosphere.platform.support.metrics.Meter.class);
    }

    public de.iip_ecosphere.platform.support.metrics.Meter getMeter(String name, Iterable<de.iip_ecosphere.platform.support.metrics.Tag> tags) {
        return MicrometerMeterRegistry.wrap(this.getMeterImpl(name, MicrometerUtils.wrapTagIterable(tags)), de.iip_ecosphere.platform.support.metrics.Meter.class);
    }

    public Gauge getGauge(String name) {
        return MicrometerMeterRegistry.wrap(this.getMeterImpl(name, null), Gauge.class);
    }

    public de.iip_ecosphere.platform.support.metrics.Counter getCounter(String name) {
        return MicrometerMeterRegistry.wrap(this.getMeterImpl(name, null), de.iip_ecosphere.platform.support.metrics.Counter.class);
    }

    public Timer getTimer(String name) {
        return MicrometerMeterRegistry.wrap(this.getMeterImpl(name, null), Timer.class);
    }

    private Meter getMeterImpl(String name, Iterable<Tag> tags) {
        Meter result;
        try {
            RequiredSearch s = this.registry.get(name);
            if (null != tags) {
                s = s.tags(tags);
            }
            result = s.meter();
        }
        catch (MeterNotFoundException e) {
            result = null;
        }
        return result;
    }

    MeterRegistry getRegistry() {
        return this.registry;
    }

    public MeterRegistry.Config meterFilter(MeterFilter filter) {
        if (filter instanceof MicrometerMeterFilter) {
            this.registry.config().meterFilter(((MicrometerMeterFilter)filter).getFilter());
        }
        return this;
    }

    public Clock clock() {
        return new MicrometerClock(this.registry.config().clock());
    }

    public <T extends Number> T gauge(String name, T number) {
        return (T)this.registry.gauge(name, number);
    }

    public de.iip_ecosphere.platform.support.metrics.Counter counter(String name, String ... tags) {
        return MicrometerMeterRegistry.wrap((Meter)this.registry.counter(name, tags), de.iip_ecosphere.platform.support.metrics.Counter.class);
    }

    public Timer timer(String name, String ... tags) {
        return MicrometerMeterRegistry.wrap((Meter)this.registry.timer(name, tags), Timer.class);
    }

    public List<de.iip_ecosphere.platform.support.metrics.Meter> getMeters() {
        ArrayList<de.iip_ecosphere.platform.support.metrics.Meter> result = new ArrayList<de.iip_ecosphere.platform.support.metrics.Meter>();
        for (Meter m : this.registry.getMeters()) {
            result.add(MicrometerMeterRegistry.wrap(m, de.iip_ecosphere.platform.support.metrics.Meter.class));
        }
        return result;
    }

    private static class GenericMeterWrapper
    extends AbstractMeter<Meter> {
        protected GenericMeterWrapper(Meter meter) {
            super(meter);
        }
    }
}

