/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IdentityStoreAuthenticationDescriptor
implements AuthenticationDescriptor {
    public static final String DEFAULT_ID = "aas";
    private String clientId;
    private List<AuthenticationDescriptor.RbacRule> rbacRules;

    public IdentityStoreAuthenticationDescriptor() {
        this(DEFAULT_ID);
    }

    public IdentityStoreAuthenticationDescriptor(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public IdentityToken getClientToken() {
        return IdentityStore.getInstance().getToken(this.clientId, new String[0]);
    }

    @Override
    public List<AuthenticationDescriptor.IdentityTokenWithRole> getServerUsers() {
        ArrayList<AuthenticationDescriptor.IdentityTokenWithRole> result = new ArrayList<AuthenticationDescriptor.IdentityTokenWithRole>();
        IdentityStore store = IdentityStore.getInstance();
        for (AuthenticationDescriptor.DefaultRole role : AuthenticationDescriptor.DefaultRole.values()) {
            for (IdentityToken tok : store.enumerateTokens(this.clientId + "-" + role.name() + "-")) {
                result.add(new AuthenticationDescriptor.IdentityTokenWithRole(tok, role));
            }
        }
        return result;
    }

    @Override
    public void addAccessRule(AuthenticationDescriptor.RbacRule rule) {
        if (null != rule) {
            this.enableRbac();
            this.rbacRules.add(rule);
        }
    }

    @Override
    public List<AuthenticationDescriptor.RbacRule> getAccessRules() {
        return null == this.rbacRules ? null : Collections.unmodifiableList(this.rbacRules);
    }

    @Override
    public void enableRbac() {
        if (null == this.rbacRules) {
            this.rbacRules = new ArrayList<AuthenticationDescriptor.RbacRule>();
        }
    }

    @Override
    public AuthenticationDescriptor.OAuth2Setup getOAuth2Setup() {
        return null;
    }
}

