/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;

public class SerialPayloadCodec
implements ProtocolServerBuilder.PayloadCodec {
    private Charset charset = Charset.forName("UTF-8");

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Schema intendedSchema() {
        return Schema.TCP;
    }

    @Override
    public byte[] encode(String info, byte[] payload) {
        byte[] result;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeUTF(info);
            oos.writeInt(payload.length);
            oos.write(payload);
            oos.flush();
            result = bos.toByteArray();
            bos.close();
        }
        catch (IOException e) {
            result = new byte[]{};
        }
        return result;
    }

    @Override
    public int getDataBytesLength() {
        return 0;
    }

    @Override
    public int decodeDataLength(byte[] data) {
        return 0;
    }

    @Override
    public void decode(byte[] data, ProtocolServerBuilder.PayloadConsumer consumer) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bis);
            String info = ois.readUTF();
            int len = ois.readInt();
            byte[] payload = new byte[len];
            ois.readFully(payload);
            bis.close();
            consumer.decoded(info, payload);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

