/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.contactInformations;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollectionBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;

public class ContactInformationsBuilder
extends DelegatingSubmodelBuilder {
    private boolean createMultiLanguageProperties = true;
    private int contactInformationCounter = 0;

    public ContactInformationsBuilder(Aas.AasBuilder aasBuilder, String identifier) {
        this(aasBuilder, identifier, "ContactInformations");
    }

    private ContactInformationsBuilder(Aas.AasBuilder aasBuilder, String identifier, String idShort) {
        super(aasBuilder.createSubmodelBuilder(idShort, identifier));
        this.setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations"));
    }

    public void setCreateMultiLanguageProperties(boolean createMultiLanguageProperties) {
        this.createMultiLanguageProperties = createMultiLanguageProperties;
    }

    public ContactInformationBuilder createContactInformationBuilder() {
        return new ContactInformationBuilder(this, ++this.contactInformationCounter);
    }

    @Override
    public Submodel build() {
        Utils.assertThat(1 <= this.contactInformationCounter, "Cardinality {} of ContactInformation must be greater or equal 1.", this.contactInformationCounter);
        return super.build();
    }

    public class ContactInformationBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int roleOfContactPersonCounter;
        private int nationalCodeCounter;
        private int languageCounter;
        private int timeZoneCounter;
        private int cityTownCounter;
        private int companyCounter;
        private int departmentCounter;
        private int phoneCounter;
        private int faxCounter;
        private int emailCounter;
        private int iPCommunicationCounter;
        private int streetCounter;
        private int zipcodeCounter;
        private int pOBoxCounter;
        private int zipCodeOfPOBoxCounter;
        private int stateCountyCounter;
        private int nameOfContactCounter;
        private int firstNameCounter;
        private int middleNamesCounter;
        private int titleCounter;
        private int academicTitleCounter;
        private int furtherDetailsOfContactCounter;
        private int addressOfAdditionalLinkCounter;

        protected ContactInformationBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("ContactInformation"), smBuilder);
            this.roleOfContactPersonCounter = 0;
            this.nationalCodeCounter = 0;
            this.languageCounter = 0;
            this.timeZoneCounter = 0;
            this.cityTownCounter = 0;
            this.companyCounter = 0;
            this.departmentCounter = 0;
            this.phoneCounter = 0;
            this.faxCounter = 0;
            this.emailCounter = 0;
            this.iPCommunicationCounter = 0;
            this.streetCounter = 0;
            this.zipcodeCounter = 0;
            this.pOBoxCounter = 0;
            this.zipCodeOfPOBoxCounter = 0;
            this.stateCountyCounter = 0;
            this.nameOfContactCounter = 0;
            this.firstNameCounter = 0;
            this.middleNamesCounter = 0;
            this.titleCounter = 0;
            this.academicTitleCounter = 0;
            this.furtherDetailsOfContactCounter = 0;
            this.addressOfAdditionalLinkCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation"));
        }

        protected ContactInformationBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("ContactInformation", nr)), smBuilder);
            this.roleOfContactPersonCounter = 0;
            this.nationalCodeCounter = 0;
            this.languageCounter = 0;
            this.timeZoneCounter = 0;
            this.cityTownCounter = 0;
            this.companyCounter = 0;
            this.departmentCounter = 0;
            this.phoneCounter = 0;
            this.faxCounter = 0;
            this.emailCounter = 0;
            this.iPCommunicationCounter = 0;
            this.streetCounter = 0;
            this.zipcodeCounter = 0;
            this.pOBoxCounter = 0;
            this.zipCodeOfPOBoxCounter = 0;
            this.stateCountyCounter = 0;
            this.nameOfContactCounter = 0;
            this.firstNameCounter = 0;
            this.middleNamesCounter = 0;
            this.titleCounter = 0;
            this.academicTitleCounter = 0;
            this.furtherDetailsOfContactCounter = 0;
            this.addressOfAdditionalLinkCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation"));
        }

        public ContactInformationBuilder setRoleOfContactPerson(IRoleOfContactPerson roleOfContactPerson) {
            ++this.roleOfContactPersonCounter;
            this.createPropertyBuilder("RoleOfContactPerson").setSemanticId(IdentifierType.irdi("0173-1#02-AAO204#003")).setValue(Type.STRING, roleOfContactPerson.getValue()).build();
            return this;
        }

        public ContactInformationBuilder setNationalCode(LangString ... nationalCode) {
            if (nationalCode.length > 0) {
                ++this.nationalCodeCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "NationalCode", IdentifierType.irdi("0173-1#02-AAO134#002"), nationalCode);
            return this;
        }

        public ContactInformationBuilder setLanguage(String language) {
            this.createPropertyBuilder(Utils.getCountingIdShort("Language", ++this.languageCounter)).setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/Language")).setValue(Type.STRING, language).build();
            return this;
        }

        public ContactInformationBuilder setTimeZone(String timeZone) {
            ++this.timeZoneCounter;
            this.createPropertyBuilder("TimeZone").setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/TimeZone")).setValue(Type.STRING, timeZone).build();
            return this;
        }

        public ContactInformationBuilder setCityTown(LangString ... cityTown) {
            if (cityTown.length > 0) {
                ++this.cityTownCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "CityTown", IdentifierType.irdi("0173-1#02-AAO132#002"), cityTown);
            return this;
        }

        public ContactInformationBuilder setCompany(LangString ... company) {
            if (company.length > 0) {
                ++this.companyCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "Company", IdentifierType.irdi("0173-1#02-AAW001#001"), company);
            return this;
        }

        public ContactInformationBuilder setDepartment(LangString ... department) {
            if (department.length > 0) {
                ++this.departmentCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "Department", IdentifierType.irdi("0173-1#02-AAO127#003"), department);
            return this;
        }

        public PhoneBuilder createPhoneBuilder() {
            ++this.phoneCounter;
            return new PhoneBuilder(this);
        }

        public FaxBuilder createFaxBuilder() {
            ++this.faxCounter;
            return new FaxBuilder(this);
        }

        public EmailBuilder createEmailBuilder() {
            ++this.emailCounter;
            return new EmailBuilder(this);
        }

        public IPCommunicationBuilder createIPCommunicationBuilder() {
            return new IPCommunicationBuilder(this, ++this.iPCommunicationCounter);
        }

        public ContactInformationBuilder setStreet(LangString ... street) {
            if (street.length > 0) {
                ++this.streetCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "Street", IdentifierType.irdi("0173-1#02-AAO128#002"), street);
            return this;
        }

        public ContactInformationBuilder setZipcode(LangString ... zipcode) {
            if (zipcode.length > 0) {
                ++this.zipcodeCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "Zipcode", IdentifierType.irdi("0173-1#02-AAO129#002"), zipcode);
            return this;
        }

        public ContactInformationBuilder setPOBox(LangString ... pOBox) {
            if (pOBox.length > 0) {
                ++this.pOBoxCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "POBox", IdentifierType.irdi("0173-1#02-AAO130#002"), pOBox);
            return this;
        }

        public ContactInformationBuilder setZipCodeOfPOBox(LangString ... zipCodeOfPOBox) {
            if (zipCodeOfPOBox.length > 0) {
                ++this.zipCodeOfPOBoxCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "ZipCodeOfPOBox", IdentifierType.irdi("0173-1#02-AAO131#002"), zipCodeOfPOBox);
            return this;
        }

        public ContactInformationBuilder setStateCounty(LangString ... stateCounty) {
            if (stateCounty.length > 0) {
                ++this.stateCountyCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "StateCounty", IdentifierType.irdi("0173-1#02-AAO133#002"), stateCounty);
            return this;
        }

        public ContactInformationBuilder setNameOfContact(LangString ... nameOfContact) {
            if (nameOfContact.length > 0) {
                ++this.nameOfContactCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "NameOfContact", IdentifierType.irdi("0173-1#02-AAO205#002"), nameOfContact);
            return this;
        }

        public ContactInformationBuilder setFirstName(LangString ... firstName) {
            if (firstName.length > 0) {
                ++this.firstNameCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "FirstName", IdentifierType.irdi("0173-1#02-AAO206#002"), firstName);
            return this;
        }

        public ContactInformationBuilder setMiddleNames(LangString ... middleNames) {
            if (middleNames.length > 0) {
                ++this.middleNamesCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "MiddleNames", IdentifierType.irdi("0173-1#02-AAO207#002"), middleNames);
            return this;
        }

        public ContactInformationBuilder setTitle(LangString ... title) {
            if (title.length > 0) {
                ++this.titleCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "Title", IdentifierType.irdi("0173-1#02-AAO208#003"), title);
            return this;
        }

        public ContactInformationBuilder setAcademicTitle(LangString ... academicTitle) {
            if (academicTitle.length > 0) {
                ++this.academicTitleCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "AcademicTitle", IdentifierType.irdi("0173-1#02-AAO209#003"), academicTitle);
            return this;
        }

        public ContactInformationBuilder setFurtherDetailsOfContact(LangString ... furtherDetailsOfContact) {
            if (furtherDetailsOfContact.length > 0) {
                ++this.furtherDetailsOfContactCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "FurtherDetailsOfContact", IdentifierType.irdi("0173-1#02-AAO210#002"), furtherDetailsOfContact);
            return this;
        }

        public ContactInformationBuilder setAddressOfAdditionalLink(String addressOfAdditionalLink) {
            ++this.addressOfAdditionalLinkCounter;
            this.createPropertyBuilder("AddressOfAdditionalLink").setSemanticId(IdentifierType.irdi("0173-1#02-AAQ326#002")).setValue(Type.STRING, addressOfAdditionalLink).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.roleOfContactPersonCounter && this.roleOfContactPersonCounter <= 1, "Cardinality {} of RoleOfContactPerson must be greater or equal 0 and less or equal 1.", this.roleOfContactPersonCounter);
            Utils.assertThat(0 <= this.nationalCodeCounter && this.nationalCodeCounter <= 1, "Cardinality {} of NationalCode must be greater or equal 0 and less or equal 1.", this.nationalCodeCounter);
            Utils.assertThat(0 <= this.languageCounter, "Cardinality {} of Language must be greater or equal 0.", this.languageCounter);
            Utils.assertThat(0 <= this.timeZoneCounter && this.timeZoneCounter <= 1, "Cardinality {} of TimeZone must be greater or equal 0 and less or equal 1.", this.timeZoneCounter);
            Utils.assertThat(0 <= this.cityTownCounter && this.cityTownCounter <= 1, "Cardinality {} of CityTown must be greater or equal 0 and less or equal 1.", this.cityTownCounter);
            Utils.assertThat(0 <= this.companyCounter && this.companyCounter <= 1, "Cardinality {} of Company must be greater or equal 0 and less or equal 1.", this.companyCounter);
            Utils.assertThat(0 <= this.departmentCounter && this.departmentCounter <= 1, "Cardinality {} of Department must be greater or equal 0 and less or equal 1.", this.departmentCounter);
            Utils.assertThat(0 <= this.phoneCounter && this.phoneCounter <= 1, "Cardinality {} of Phone must be greater or equal 0 and less or equal 1.", this.phoneCounter);
            Utils.assertThat(0 <= this.faxCounter && this.faxCounter <= 1, "Cardinality {} of Fax must be greater or equal 0 and less or equal 1.", this.faxCounter);
            Utils.assertThat(0 <= this.emailCounter && this.emailCounter <= 1, "Cardinality {} of Email must be greater or equal 0 and less or equal 1.", this.emailCounter);
            Utils.assertThat(0 <= this.iPCommunicationCounter, "Cardinality {} of IPCommunication must be greater or equal 0.", this.iPCommunicationCounter);
            Utils.assertThat(0 <= this.streetCounter && this.streetCounter <= 1, "Cardinality {} of Street must be greater or equal 0 and less or equal 1.", this.streetCounter);
            Utils.assertThat(0 <= this.zipcodeCounter && this.zipcodeCounter <= 1, "Cardinality {} of Zipcode must be greater or equal 0 and less or equal 1.", this.zipcodeCounter);
            Utils.assertThat(0 <= this.pOBoxCounter && this.pOBoxCounter <= 1, "Cardinality {} of POBox must be greater or equal 0 and less or equal 1.", this.pOBoxCounter);
            Utils.assertThat(0 <= this.zipCodeOfPOBoxCounter && this.zipCodeOfPOBoxCounter <= 1, "Cardinality {} of ZipCodeOfPOBox must be greater or equal 0 and less or equal 1.", this.zipCodeOfPOBoxCounter);
            Utils.assertThat(0 <= this.stateCountyCounter && this.stateCountyCounter <= 1, "Cardinality {} of StateCounty must be greater or equal 0 and less or equal 1.", this.stateCountyCounter);
            Utils.assertThat(0 <= this.nameOfContactCounter && this.nameOfContactCounter <= 1, "Cardinality {} of NameOfContact must be greater or equal 0 and less or equal 1.", this.nameOfContactCounter);
            Utils.assertThat(0 <= this.firstNameCounter && this.firstNameCounter <= 1, "Cardinality {} of FirstName must be greater or equal 0 and less or equal 1.", this.firstNameCounter);
            Utils.assertThat(0 <= this.middleNamesCounter && this.middleNamesCounter <= 1, "Cardinality {} of MiddleNames must be greater or equal 0 and less or equal 1.", this.middleNamesCounter);
            Utils.assertThat(0 <= this.titleCounter && this.titleCounter <= 1, "Cardinality {} of Title must be greater or equal 0 and less or equal 1.", this.titleCounter);
            Utils.assertThat(0 <= this.academicTitleCounter && this.academicTitleCounter <= 1, "Cardinality {} of AcademicTitle must be greater or equal 0 and less or equal 1.", this.academicTitleCounter);
            Utils.assertThat(0 <= this.furtherDetailsOfContactCounter && this.furtherDetailsOfContactCounter <= 1, "Cardinality {} of FurtherDetailsOfContact must be greater or equal 0 and less or equal 1.", this.furtherDetailsOfContactCounter);
            Utils.assertThat(0 <= this.addressOfAdditionalLinkCounter && this.addressOfAdditionalLinkCounter <= 1, "Cardinality {} of AddressOfAdditionalLink must be greater or equal 0 and less or equal 1.", this.addressOfAdditionalLinkCounter);
            return super.build();
        }
    }

    public class IPCommunicationBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int addressOfAdditionalLinkCounter;
        private int typeOfCommunicationCounter;
        private int availableTimeCounter;

        protected IPCommunicationBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("IPCommunication"), smBuilder);
            this.addressOfAdditionalLinkCounter = 0;
            this.typeOfCommunicationCounter = 0;
            this.availableTimeCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/IPCommunication/"));
        }

        protected IPCommunicationBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("IPCommunication", nr)), smBuilder);
            this.addressOfAdditionalLinkCounter = 0;
            this.typeOfCommunicationCounter = 0;
            this.availableTimeCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/IPCommunication/"));
        }

        public IPCommunicationBuilder setAddressOfAdditionalLink(String addressOfAdditionalLink) {
            ++this.addressOfAdditionalLinkCounter;
            this.createPropertyBuilder("AddressOfAdditionalLink").setSemanticId(IdentifierType.irdi("0173-1#02-AAQ326#002")).setValue(Type.STRING, addressOfAdditionalLink).build();
            return this;
        }

        public IPCommunicationBuilder setTypeOfCommunication(String typeOfCommunication) {
            ++this.typeOfCommunicationCounter;
            this.createPropertyBuilder("TypeOfCommunication").setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/IPCommunication/TypeOfCommunication")).setValue(Type.STRING, typeOfCommunication).build();
            return this;
        }

        public IPCommunicationBuilder setAvailableTime(LangString ... availableTime) {
            if (availableTime.length > 0) {
                ++this.availableTimeCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "AvailableTime", IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/AvailableTime/"), availableTime);
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.addressOfAdditionalLinkCounter == 1, "Cardinality {} of AddressOfAdditionalLink must be equal 1.", this.addressOfAdditionalLinkCounter);
            Utils.assertThat(0 <= this.typeOfCommunicationCounter && this.typeOfCommunicationCounter <= 1, "Cardinality {} of TypeOfCommunication must be greater or equal 0 and less or equal 1.", this.typeOfCommunicationCounter);
            Utils.assertThat(0 <= this.availableTimeCounter && this.availableTimeCounter <= 1, "Cardinality {} of AvailableTime must be greater or equal 0 and less or equal 1.", this.availableTimeCounter);
            return super.build();
        }
    }

    public class EmailBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int emailAddressCounter;
        private int publicKeyCounter;
        private int typeOfEmailAddressCounter;
        private int typeOfPublicKeyCounter;

        protected EmailBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("Email"), smBuilder);
            this.emailAddressCounter = 0;
            this.publicKeyCounter = 0;
            this.typeOfEmailAddressCounter = 0;
            this.typeOfPublicKeyCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#02-AAQ836#005"));
        }

        protected EmailBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("Email", nr)), smBuilder);
            this.emailAddressCounter = 0;
            this.publicKeyCounter = 0;
            this.typeOfEmailAddressCounter = 0;
            this.typeOfPublicKeyCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#02-AAQ836#005"));
        }

        public EmailBuilder setEmailAddress(String emailAddress) {
            ++this.emailAddressCounter;
            this.createPropertyBuilder("EmailAddress").setSemanticId(IdentifierType.irdi("0173-1#02-AAO198#002")).setValue(Type.STRING, emailAddress).build();
            return this;
        }

        public EmailBuilder setPublicKey(LangString ... publicKey) {
            if (publicKey.length > 0) {
                ++this.publicKeyCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "PublicKey", IdentifierType.irdi("0173-1#02-AAO200#002"), publicKey);
            return this;
        }

        public EmailBuilder setTypeOfEmailAddress(TypeOfEmailAddress typeOfEmailAddress) {
            ++this.typeOfEmailAddressCounter;
            this.createPropertyBuilder("TypeOfEmailAddress").setSemanticId(IdentifierType.irdi("0173-1#02-AAO199#003")).setValue(Type.STRING, typeOfEmailAddress.getValue()).build();
            return this;
        }

        public EmailBuilder setTypeOfPublicKey(LangString ... typeOfPublicKey) {
            if (typeOfPublicKey.length > 0) {
                ++this.typeOfPublicKeyCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "TypeOfPublicKey", IdentifierType.irdi("0173-1#02-AAO201#002"), typeOfPublicKey);
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.emailAddressCounter == 1, "Cardinality {} of EmailAddress must be equal 1.", this.emailAddressCounter);
            Utils.assertThat(0 <= this.publicKeyCounter && this.publicKeyCounter <= 1, "Cardinality {} of PublicKey must be greater or equal 0 and less or equal 1.", this.publicKeyCounter);
            Utils.assertThat(0 <= this.typeOfEmailAddressCounter && this.typeOfEmailAddressCounter <= 1, "Cardinality {} of TypeOfEmailAddress must be greater or equal 0 and less or equal 1.", this.typeOfEmailAddressCounter);
            Utils.assertThat(0 <= this.typeOfPublicKeyCounter && this.typeOfPublicKeyCounter <= 1, "Cardinality {} of TypeOfPublicKey must be greater or equal 0 and less or equal 1.", this.typeOfPublicKeyCounter);
            return super.build();
        }
    }

    public class FaxBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int faxNumberCounter;
        private int typeOfFaxNumberCounter;

        protected FaxBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("Fax"), smBuilder);
            this.faxNumberCounter = 0;
            this.typeOfFaxNumberCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#02-AAQ834#005"));
        }

        protected FaxBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("Fax", nr)), smBuilder);
            this.faxNumberCounter = 0;
            this.typeOfFaxNumberCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#02-AAQ834#005"));
        }

        public FaxBuilder setFaxNumber(LangString ... faxNumber) {
            if (faxNumber.length > 0) {
                ++this.faxNumberCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "FaxNumber", IdentifierType.irdi("0173-1#02-AAO195#002"), faxNumber);
            return this;
        }

        public FaxBuilder setTypeOfFaxNumber(TypeOfFaxNumber typeOfFaxNumber) {
            ++this.typeOfFaxNumberCounter;
            this.createPropertyBuilder("TypeOfFaxNumber").setSemanticId(IdentifierType.irdi("0173-1#02-AAO196#003")).setValue(Type.STRING, typeOfFaxNumber.getValue()).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.faxNumberCounter == 1, "Cardinality {} of FaxNumber must be equal 1.", this.faxNumberCounter);
            Utils.assertThat(0 <= this.typeOfFaxNumberCounter && this.typeOfFaxNumberCounter <= 1, "Cardinality {} of TypeOfFaxNumber must be greater or equal 0 and less or equal 1.", this.typeOfFaxNumberCounter);
            return super.build();
        }
    }

    public class PhoneBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int telephoneNumberCounter;
        private int typeOfTelephoneCounter;
        private int availableTimeCounter;

        protected PhoneBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("Phone"), smBuilder);
            this.telephoneNumberCounter = 0;
            this.typeOfTelephoneCounter = 0;
            this.availableTimeCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/Phone"));
        }

        protected PhoneBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("Phone", nr)), smBuilder);
            this.telephoneNumberCounter = 0;
            this.typeOfTelephoneCounter = 0;
            this.availableTimeCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/Phone"));
        }

        public PhoneBuilder setTelephoneNumber(LangString ... telephoneNumber) {
            if (telephoneNumber.length > 0) {
                ++this.telephoneNumberCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "TelephoneNumber", IdentifierType.irdi("0173-1#02-AAO136#002"), telephoneNumber);
            return this;
        }

        public PhoneBuilder setTypeOfTelephone(TypeOfTelephone typeOfTelephone) {
            ++this.typeOfTelephoneCounter;
            this.createPropertyBuilder("TypeOfTelephone").setSemanticId(IdentifierType.irdi("0173-1#02-AAO137#003")).setValue(Type.STRING, typeOfTelephone.getValue()).build();
            return this;
        }

        public PhoneBuilder setAvailableTime(LangString ... availableTime) {
            if (availableTime.length > 0) {
                ++this.availableTimeCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), ContactInformationsBuilder.this.createMultiLanguageProperties, "AvailableTime", IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/AvailableTime/"), availableTime);
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.telephoneNumberCounter == 1, "Cardinality {} of TelephoneNumber must be equal 1.", this.telephoneNumberCounter);
            Utils.assertThat(0 <= this.typeOfTelephoneCounter && this.typeOfTelephoneCounter <= 1, "Cardinality {} of TypeOfTelephone must be greater or equal 0 and less or equal 1.", this.typeOfTelephoneCounter);
            Utils.assertThat(0 <= this.availableTimeCounter && this.availableTimeCounter <= 1, "Cardinality {} of AvailableTime must be greater or equal 0 and less or equal 1.", this.availableTimeCounter);
            return super.build();
        }
    }

    public static enum TypeOfEmailAddress {
        OFFICE(0, IdentifierType.irdi("0173-1#07-AAS754#001"), "office"),
        SECRETARY(0, IdentifierType.irdi("0173-1#07-AAS756#001"), "secretary"),
        SUBSTITUTE(0, IdentifierType.irdi("0173-1#07-AAS757#001"), "substitute"),
        HOME(0, IdentifierType.irdi("0173-1#07-AAS758#001"), "home");

        private int valueId;
        private String semanticId;
        private String value;

        private TypeOfEmailAddress(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum TypeOfFaxNumber {
        OFFICE(0, IdentifierType.irdi("0173-1#07-AAS754#001"), "office"),
        SECRETARY(0, IdentifierType.irdi("0173-1#07-AAS756#001"), "secretary"),
        HOME(0, IdentifierType.irdi("0173-1#07-AAS758#001"), "home");

        private int valueId;
        private String semanticId;
        private String value;

        private TypeOfFaxNumber(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum TypeOfTelephone {
        OFFICE(0, IdentifierType.irdi("0173-1#07-AAS754#001"), "office"),
        OFFICE_MOBILE(0, IdentifierType.irdi("0173-1#07-AAS755#001"), "office mobile"),
        SECRETARY(0, IdentifierType.irdi("0173-1#07-AAS756#001"), "secretary"),
        SUBSTITUTE(0, IdentifierType.irdi("0173-1#07-AAS757#001"), "substitute"),
        HOME(0, IdentifierType.irdi("0173-1#07-AAS758#001"), "home"),
        PRIVATE_MOBILE(0, IdentifierType.irdi("0173-1#07-AAS759#001"), "private mobile");

        private int valueId;
        private String semanticId;
        private String value;

        private TypeOfTelephone(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum RoleOfContactPerson implements IRoleOfContactPerson
    {
        ADMINISTRATIV_CONTACT(0, IdentifierType.irdi("0173-1#07-AAS927#001"), "administrativ contact"),
        COMMERCIAL_CONTACT(0, IdentifierType.irdi("0173-1#07-AAS928#001"), "commercial contact"),
        OTHER_CONTACT(0, IdentifierType.irdi("0173-1#07-AAS929#001"), "other contact"),
        HAZARDOUS_GOODS_CONTACT(0, IdentifierType.irdi("0173-1#07-AAS930#001"), "hazardous goods contact"),
        TECHNICAL_CONTACT(0, IdentifierType.irdi("0173-1#07-AAS931#001"), "technical contact");

        private int valueId;
        private String semanticId;
        private String value;

        private RoleOfContactPerson(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        @Override
        public int getValueId() {
            return this.valueId;
        }

        @Override
        public String getSemanticId() {
            return this.semanticId;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static interface IRoleOfContactPerson {
        public int getValueId();

        public String getSemanticId();

        public String getValue();
    }
}

