/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.documentation;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.Entity;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollectionBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import java.util.Date;

public class HandoverDocumentationBuilder
extends DelegatingSubmodelBuilder {
    private boolean createMultiLanguageProperties = true;
    private int documentCounter = 0;
    private int entityCounter = 0;

    public HandoverDocumentationBuilder(Aas.AasBuilder aasBuilder, String identifier) {
        this(aasBuilder, identifier, "HandoverDocumentation");
    }

    public HandoverDocumentationBuilder(Aas.AasBuilder aasBuilder, String identifier, String idShort) {
        super(aasBuilder.createSubmodelBuilder(idShort, identifier));
        this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF578#001"));
    }

    public void setCreateMultiLanguageProperties(boolean createMultiLanguageProperties) {
        this.createMultiLanguageProperties = createMultiLanguageProperties;
    }

    public DocumentBuilder createDocumentBuilder() {
        return new DocumentBuilder(this, ++this.documentCounter);
    }

    public Entity.EntityBuilder createEntityBuilder(Entity.EntityType type) {
        return super.createEntityBuilder(Utils.getCountingIdShort("Entity", ++this.entityCounter), type, null);
    }

    @Override
    public Submodel build() {
        Utils.assertThat(0 <= this.documentCounter, "Cardinality {} of Document must be greater or equal 0.", this.documentCounter);
        Utils.assertThat(0 <= this.entityCounter, "Cardinality {} of Entity must be greater or equal 0.", this.entityCounter);
        return super.build();
    }

    public class DocumentBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int documentIdCounter;
        private int documentClassificationCounter;
        private int documentVersionCounter;
        private int documentedEntityCounter;

        protected DocumentBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("Document"), smBuilder);
            this.documentIdCounter = 0;
            this.documentClassificationCounter = 0;
            this.documentVersionCounter = 0;
            this.documentedEntityCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF579#001"));
        }

        protected DocumentBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("Document", nr)), smBuilder);
            this.documentIdCounter = 0;
            this.documentClassificationCounter = 0;
            this.documentVersionCounter = 0;
            this.documentedEntityCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF579#001"));
        }

        public DocumentIdBuilder createDocumentIdBuilder() {
            return new DocumentIdBuilder(this, ++this.documentIdCounter);
        }

        public DocumentClassificationBuilder createDocumentClassificationBuilder() {
            return new DocumentClassificationBuilder(this, ++this.documentClassificationCounter);
        }

        public DocumentVersionBuilder createDocumentVersionBuilder() {
            return new DocumentVersionBuilder(this, ++this.documentVersionCounter);
        }

        public DocumentBuilder setDocumentedEntity(Reference reference, String semanticId) {
            this.createReferenceElementBuilder(Utils.getCountingIdShort("DocumentedEntity", ++this.documentedEntityCounter)).setSemanticId(semanticId != null && semanticId.length() > 0 ? semanticId : "").setValue(reference).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(1 <= this.documentIdCounter, "Cardinality {} of DocumentId must be greater or equal 1.", this.documentIdCounter);
            Utils.assertThat(1 <= this.documentClassificationCounter, "Cardinality {} of DocumentClassification must be greater or equal 1.", this.documentClassificationCounter);
            Utils.assertThat(0 <= this.documentVersionCounter, "Cardinality {} of DocumentVersion must be greater or equal 0.", this.documentVersionCounter);
            Utils.assertThat(0 <= this.documentedEntityCounter, "Cardinality {} of DocumentedEntity must be greater or equal 0.", this.documentedEntityCounter);
            return super.build();
        }
    }

    public class DocumentVersionBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int languageCounter;
        private int documentVersionIdCounter;
        private int titleCounter;
        private int subTitleCounter;
        private int summaryCounter;
        private int keyWordsCounter;
        private int statusSetDateCounter;
        private int statusValueCounter;
        private int organizationNameCounter;
        private int organizationOfficialNameCounter;
        private int digitalFileCounter;
        private int previewFileCounter;
        private int refersToCounter;
        private int basedOnCounter;
        private int translationOfCounter;

        protected DocumentVersionBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("DocumentVersion"), smBuilder);
            this.languageCounter = 0;
            this.documentVersionIdCounter = 0;
            this.titleCounter = 0;
            this.subTitleCounter = 0;
            this.summaryCounter = 0;
            this.keyWordsCounter = 0;
            this.statusSetDateCounter = 0;
            this.statusValueCounter = 0;
            this.organizationNameCounter = 0;
            this.organizationOfficialNameCounter = 0;
            this.digitalFileCounter = 0;
            this.previewFileCounter = 0;
            this.refersToCounter = 0;
            this.basedOnCounter = 0;
            this.translationOfCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF582#001"));
        }

        protected DocumentVersionBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("DocumentVersion", nr)), smBuilder);
            this.languageCounter = 0;
            this.documentVersionIdCounter = 0;
            this.titleCounter = 0;
            this.subTitleCounter = 0;
            this.summaryCounter = 0;
            this.keyWordsCounter = 0;
            this.statusSetDateCounter = 0;
            this.statusValueCounter = 0;
            this.organizationNameCounter = 0;
            this.organizationOfficialNameCounter = 0;
            this.digitalFileCounter = 0;
            this.previewFileCounter = 0;
            this.refersToCounter = 0;
            this.basedOnCounter = 0;
            this.translationOfCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF582#001"));
        }

        public DocumentVersionBuilder setLanguage(String language) {
            this.createPropertyBuilder(Utils.getCountingIdShort("Language", ++this.languageCounter)).setSemanticId(IdentifierType.irdi("0173-1#02-AAN468#006")).setValue(Type.STRING, language).build();
            return this;
        }

        public DocumentVersionBuilder setDocumentVersionId(String documentVersionId) {
            ++this.documentVersionIdCounter;
            this.createPropertyBuilder("DocumentVersionId").setSemanticId(IdentifierType.irdi("0173-1#02-AAO100#002")).setValue(Type.STRING, documentVersionId).build();
            return this;
        }

        public DocumentVersionBuilder setTitle(LangString ... title) {
            if (title.length > 0) {
                ++this.titleCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), HandoverDocumentationBuilder.this.createMultiLanguageProperties, "Title", IdentifierType.irdi("0173-1#02-AAO105#002"), title);
            return this;
        }

        public DocumentVersionBuilder setSubTitle(LangString ... subTitle) {
            if (subTitle.length > 0) {
                ++this.subTitleCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), HandoverDocumentationBuilder.this.createMultiLanguageProperties, "SubTitle", IdentifierType.irdi("0173-1#02-ABH998#001"), subTitle);
            return this;
        }

        public DocumentVersionBuilder setSummary(LangString ... summary) {
            if (summary.length > 0) {
                ++this.summaryCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), HandoverDocumentationBuilder.this.createMultiLanguageProperties, "Summary", IdentifierType.irdi("0173-1#02-AAO106#002"), summary);
            return this;
        }

        public DocumentVersionBuilder setKeyWords(LangString ... keyWords) {
            if (keyWords.length > 0) {
                ++this.keyWordsCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), HandoverDocumentationBuilder.this.createMultiLanguageProperties, "KeyWords", IdentifierType.irdi("0173-1#02-ABH999#001"), keyWords);
            return this;
        }

        public DocumentVersionBuilder setStatusSetDate(Date statusSetDate) {
            ++this.statusSetDateCounter;
            this.createPropertyBuilder("StatusSetDate").setSemanticId(IdentifierType.irdi("0173-1#02-ABI000#001")).setValue(Type.DATE_TIME, statusSetDate).build();
            return this;
        }

        public DocumentVersionBuilder setStatusValue(StatusValue statusValue) {
            ++this.statusValueCounter;
            this.createPropertyBuilder("StatusValue").setSemanticId(IdentifierType.irdi("0173-1#02-ABI001#001")).setValue(Type.STRING, statusValue.getValue()).build();
            return this;
        }

        public DocumentVersionBuilder setOrganizationName(String organizationName) {
            ++this.organizationNameCounter;
            this.createPropertyBuilder("OrganizationName").setSemanticId(IdentifierType.irdi("0173-1#02-ABI002#001")).setValue(Type.STRING, organizationName).build();
            return this;
        }

        public DocumentVersionBuilder setOrganizationOfficialName(String organizationOfficialName) {
            ++this.organizationOfficialNameCounter;
            this.createPropertyBuilder("OrganizationOfficialName").setSemanticId(IdentifierType.irdi("0173-1#02-ABI004#001")).setValue(Type.STRING, organizationOfficialName).build();
            return this;
        }

        public DocumentVersionBuilder setDigitalFile(String file, String mimeType, String semanticId) {
            this.createFileDataElementBuilder(Utils.getCountingIdShort("DigitalFile", ++this.digitalFileCounter), file, mimeType).setSemanticId(semanticId != null && semanticId.length() > 0 ? semanticId : IdentifierType.irdi("0173-1#01-AHF583#001")).build();
            return this;
        }

        public DocumentVersionBuilder setPreviewFile(String file, String mimeType, String semanticId) {
            this.createFileDataElementBuilder(Utils.getCountingIdShort("PreviewFile", ++this.previewFileCounter), file, mimeType).setSemanticId(semanticId != null && semanticId.length() > 0 ? semanticId : IdentifierType.irdi("0173-1#01-AHF584#001")).build();
            return this;
        }

        public DocumentVersionBuilder setRefersTo(Reference reference) {
            this.createReferenceElementBuilder(Utils.getCountingIdShort("RefersTo", ++this.refersToCounter)).setSemanticId(IdentifierType.irdi("0173-1#02-ABI006#001")).setValue(reference).build();
            return this;
        }

        public DocumentVersionBuilder setBasedOn(Reference reference) {
            this.createReferenceElementBuilder(Utils.getCountingIdShort("BasedOn", ++this.basedOnCounter)).setSemanticId(IdentifierType.irdi("0173-1#02-ABI007#001")).setValue(reference).build();
            return this;
        }

        public DocumentVersionBuilder setTranslationOf(Reference reference) {
            this.createReferenceElementBuilder(Utils.getCountingIdShort("TranslationOf", ++this.translationOfCounter)).setSemanticId(IdentifierType.irdi("0173-1#02-ABI008#001")).setValue(reference).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(1 <= this.languageCounter, "Cardinality {} of Language must be greater or equal 1.", this.languageCounter);
            Utils.assertThat(this.documentVersionIdCounter == 1, "Cardinality {} of DocumentVersionId must be equal 1.", this.documentVersionIdCounter);
            Utils.assertThat(this.titleCounter == 1, "Cardinality {} of Title must be equal 1.", this.titleCounter);
            Utils.assertThat(0 <= this.subTitleCounter && this.subTitleCounter <= 1, "Cardinality {} of SubTitle must be greater or equal 0 and less or equal 1.", this.subTitleCounter);
            Utils.assertThat(this.summaryCounter == 1, "Cardinality {} of Summary must be equal 1.", this.summaryCounter);
            Utils.assertThat(this.keyWordsCounter == 1, "Cardinality {} of KeyWords must be equal 1.", this.keyWordsCounter);
            Utils.assertThat(this.statusSetDateCounter == 1, "Cardinality {} of StatusSetDate must be equal 1.", this.statusSetDateCounter);
            Utils.assertThat(this.statusValueCounter == 1, "Cardinality {} of StatusValue must be equal 1.", this.statusValueCounter);
            Utils.assertThat(this.organizationNameCounter == 1, "Cardinality {} of OrganizationName must be equal 1.", this.organizationNameCounter);
            Utils.assertThat(this.organizationOfficialNameCounter == 1, "Cardinality {} of OrganizationOfficialName must be equal 1.", this.organizationOfficialNameCounter);
            Utils.assertThat(1 <= this.digitalFileCounter, "Cardinality {} of DigitalFile must be greater or equal 1.", this.digitalFileCounter);
            Utils.assertThat(0 <= this.previewFileCounter && this.previewFileCounter <= 1, "Cardinality {} of PreviewFile must be greater or equal 0 and less or equal 1.", this.previewFileCounter);
            Utils.assertThat(0 <= this.refersToCounter, "Cardinality {} of RefersTo must be greater or equal 0.", this.refersToCounter);
            Utils.assertThat(0 <= this.basedOnCounter, "Cardinality {} of BasedOn must be greater or equal 0.", this.basedOnCounter);
            Utils.assertThat(0 <= this.translationOfCounter, "Cardinality {} of TranslationOf must be greater or equal 0.", this.translationOfCounter);
            return super.build();
        }
    }

    public class DocumentClassificationBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int classIdCounter;
        private int classNameCounter;
        private int classificationSystemCounter;

        protected DocumentClassificationBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("DocumentClassification"), smBuilder);
            this.classIdCounter = 0;
            this.classNameCounter = 0;
            this.classificationSystemCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF581#001"));
        }

        protected DocumentClassificationBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("DocumentClassification", nr)), smBuilder);
            this.classIdCounter = 0;
            this.classNameCounter = 0;
            this.classificationSystemCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF581#001"));
        }

        public DocumentClassificationBuilder setClassId(String classId) {
            ++this.classIdCounter;
            this.createPropertyBuilder("ClassId").setSemanticId(IdentifierType.irdi("0173-1#02-ABH996#001")).setValue(Type.STRING, classId).build();
            return this;
        }

        public DocumentClassificationBuilder setClassName(LangString ... className) {
            if (className.length > 0) {
                ++this.classNameCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), HandoverDocumentationBuilder.this.createMultiLanguageProperties, "ClassName", IdentifierType.irdi("0173-1#02-AAO102#003"), className);
            return this;
        }

        public DocumentClassificationBuilder setClassificationSystem(String classificationSystem) {
            ++this.classificationSystemCounter;
            this.createPropertyBuilder("ClassificationSystem").setSemanticId(IdentifierType.irdi("0173-1#02-ABH997#001")).setValue(Type.STRING, classificationSystem).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.classIdCounter == 1, "Cardinality {} of ClassId must be equal 1.", this.classIdCounter);
            Utils.assertThat(this.classNameCounter == 1, "Cardinality {} of ClassName must be equal 1.", this.classNameCounter);
            Utils.assertThat(this.classificationSystemCounter == 1, "Cardinality {} of ClassificationSystem must be equal 1.", this.classificationSystemCounter);
            return super.build();
        }
    }

    public class DocumentIdBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int documentDomainIdCounter;
        private int valueIdCounter;
        private int isPrimaryCounter;

        protected DocumentIdBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("DocumentId"), smBuilder);
            this.documentDomainIdCounter = 0;
            this.valueIdCounter = 0;
            this.isPrimaryCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF580#001"));
        }

        protected DocumentIdBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("DocumentId", nr)), smBuilder);
            this.documentDomainIdCounter = 0;
            this.valueIdCounter = 0;
            this.isPrimaryCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#01-AHF580#001"));
        }

        public DocumentIdBuilder setDocumentDomainId(String documentDomainId) {
            ++this.documentDomainIdCounter;
            this.createPropertyBuilder("DocumentDomainId").setSemanticId(IdentifierType.irdi("0173-1#02-ABH994#001")).setValue(Type.STRING, documentDomainId).build();
            return this;
        }

        public DocumentIdBuilder setValueId(String valueId) {
            ++this.valueIdCounter;
            this.createPropertyBuilder("ValueId").setSemanticId(IdentifierType.irdi("0173-1#02-AAO099#002")).setValue(Type.STRING, valueId).build();
            return this;
        }

        public DocumentIdBuilder setIsPrimary(boolean isPrimary) {
            ++this.isPrimaryCounter;
            this.createPropertyBuilder("IsPrimary").setSemanticId(IdentifierType.irdi("0173-1#02-ABH995#001")).setValue(Type.BOOLEAN, isPrimary).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.documentDomainIdCounter == 1, "Cardinality {} of DocumentDomainId must be equal 1.", this.documentDomainIdCounter);
            Utils.assertThat(this.valueIdCounter == 1, "Cardinality {} of ValueId must be equal 1.", this.valueIdCounter);
            Utils.assertThat(0 <= this.isPrimaryCounter && this.isPrimaryCounter <= 1, "Cardinality {} of IsPrimary must be greater or equal 0 and less or equal 1.", this.isPrimaryCounter);
            return super.build();
        }
    }

    public static enum StatusValue {
        UNDER_REVIEW(0, "0173-1#07-ABZ640#001", "under review"),
        RELEASED(0, "0173-1#07-ABZ641#001", "released");

        private int valueId;
        private String semanticId;
        private String value;

        private StatusValue(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }
}

