/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.identities;

import de.iip_ecosphere.platform.support.identities.IdentityStoreDescriptor;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.identities.YamlIdentityStore;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.net.SslUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public abstract class IdentityStore {
    private static IdentityStore instance;

    public static IdentityStore getInstance() {
        if (null == instance) {
            Optional desc = ServiceLoaderUtils.findFirst(IdentityStoreDescriptor.class);
            if (desc.isPresent()) {
                instance = ((IdentityStoreDescriptor)desc.get()).createStore();
            }
            if (null == instance) {
                instance = new YamlIdentityStore();
            }
        }
        return instance;
    }

    public IdentityToken getToken(String identity, String ... fallback) {
        return this.getToken(identity, false, fallback);
    }

    public abstract Iterable<String> enumerateIdentities(String var1);

    public Iterable<IdentityToken> enumerateTokens(String prefixId) {
        ArrayList<IdentityToken> result = new ArrayList<IdentityToken>();
        for (String id : this.enumerateIdentities(prefixId)) {
            result.add(this.getToken(id, new String[0]));
        }
        return result;
    }

    public abstract IdentityToken getToken(String var1, boolean var2, String ... var3);

    public abstract InputStream getKeystoreAsStream(String var1, String ... var2);

    public abstract KeyStore getKeystoreFile(String var1, String ... var2) throws IOException;

    public abstract KeystoreCoordinate getKeystoreCoordinate(String var1, String ... var2) throws IOException;

    public abstract KeyManager[] getKeyManagers(String var1, String var2, String ... var3) throws IOException;

    public KeyManager[] getKeyManagers(String identity, String ... fallback) throws IOException {
        return this.getKeyManagers(identity, KeyManagerFactory.getDefaultAlgorithm(), fallback);
    }

    public SSLContext createTlsContext(String identity, String keyAlias, String ... fallback) throws IOException {
        return this.createTlsContext(identity, KeyManagerFactory.getDefaultAlgorithm(), keyAlias, "TLS", fallback);
    }

    public SSLContext createTlsContext(String identity, String algorithm, String keyAlias, String contextAlg, String ... fallback) throws IOException {
        SSLContext ctx = null;
        KeyStore ks = this.getKeystoreFile(identity, fallback);
        if (null != ks) {
            try {
                TrustManagerFactory tmf = SslUtils.createTrustManagerFactory(ks);
                KeyManager[] kms = this.getKeyManagers(identity, algorithm, fallback);
                if (null != keyAlias) {
                    kms = SslUtils.createProjectingKeyManagers(keyAlias, kms);
                }
                ctx = SSLContext.getInstance(contextAlg);
                ctx.init(kms, tmf.getTrustManagers(), null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
        }
        return ctx;
    }

    public Key getKeystoreKey(String identity, String keyAlias, String ... fallback) throws IOException {
        return this.getKeystoreKey(identity, (KeyStore)null, keyAlias, fallback);
    }

    public abstract Key getKeystoreKey(String var1, KeyStore var2, String var3, String ... var4) throws IOException;

    public static class KeystoreCoordinate {
        private String file;
        private String password;

        public KeystoreCoordinate(String file, String password) {
            this.file = file;
            this.password = password;
        }

        public String getFile() {
            return this.file;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

