/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactoryDescriptor;
import de.iip_ecosphere.platform.support.aas.AasServerRecipeDescriptor;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolDescriptor;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.SimpleLocalProtocolCreator;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.jsl.ExcludeFirst;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.SingletonPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;

public abstract class AasFactory {
    public static final String DEFAULT_PROTOCOL = "";
    public static final String LOCAL_PROTOCOL = "local";
    public static final String DEFAULT_PLUGIN_ID = "aas-default";
    public static final String PROPERTY_PLUGIN_ID = "okto.aasFactoryId";
    public static final AasFactory DUMMY = new AasFactory(){

        @Override
        public String getName() {
            return "Dummy";
        }

        @Override
        public Aas.AasBuilder createAasBuilder(String idShort, String urn) {
            return null;
        }

        @Override
        public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String urn) {
            return null;
        }

        @Override
        protected ServerRecipe createDefaultServerRecipe() {
            return null;
        }

        @Override
        public Registry obtainRegistry(SetupSpec spec) throws IOException {
            return new Registry(){

                @Override
                public Aas retrieveAas(String aasUrn) throws IOException {
                    return null;
                }

                @Override
                public Aas retrieveAas(String identifier, boolean populate) throws IOException {
                    return null;
                }

                @Override
                public Submodel retrieveSubmodel(String aasUrn, String submodelUrn) throws IOException {
                    return null;
                }

                @Override
                public void createAas(Aas aas, String endpointURL) {
                }

                @Override
                public void createSubmodel(Aas aas, Submodel submodel) {
                }

                @Override
                public void register(Aas aas, Submodel submodel, String endpointUrl) {
                }

                @Override
                public String getEndpoint(Aas aas) {
                    return null;
                }

                @Override
                public String getEndpoint(Aas aas, Submodel submodel) {
                    return null;
                }

                @Override
                public String getEndpoint(String aasIdShort) {
                    return null;
                }

                @Override
                public List<String> getAasIdShorts() {
                    return new ArrayList<String>();
                }

                @Override
                public List<String> getAasIdentifiers() {
                    return new ArrayList<String>();
                }
            };
        }

        @Override
        public Registry obtainRegistry(SetupSpec spec, Schema aasSchema) throws IOException {
            return this.obtainRegistry(spec);
        }

        @Override
        public DeploymentRecipe createDeploymentRecipe(SetupSpec spec) {
            return null;
        }

        @Override
        public PersistenceRecipe createPersistenceRecipe() {
            return null;
        }

        @Override
        protected boolean accept(ProtocolDescriptor creator) {
            return true;
        }

        @Override
        public String getMetaModelVersion() {
            return "v0";
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(AasFactory.class);
    private static AasFactory instance = DUMMY;
    private static String pluginId = OsUtils.getPropertyOrEnv((String)"okto.aasFactoryId", (String)"aas-default");
    private static boolean noInstanceWarningEmitted = false;
    private Map<String, ProtocolCreator> protocolCreators = new HashMap<String, ProtocolCreator>();
    private String[] protocols;
    private Map<SetupSpec.AasComponent, Function<SetupSpec.ComponentSetup, Boolean>> available = new HashMap<SetupSpec.AasComponent, Function<SetupSpec.ComponentSetup, Boolean>>();

    protected AasFactory() {
        ServiceLoader loader = ServiceLoaderUtils.load(ProtocolDescriptor.class);
        for (ProtocolDescriptor desc : loader) {
            if (!this.accept(desc)) continue;
            ProtocolCreator creator = desc.createInstance();
            this.registerProtocolCreator(desc.getName(), creator);
            if (1 != this.protocolCreators.size()) continue;
            this.registerProtocolCreator(DEFAULT_PROTOCOL, creator);
        }
        this.registerProtocolCreator(LOCAL_PROTOCOL, new SimpleLocalProtocolCreator());
    }

    protected boolean accept(ProtocolDescriptor creator) {
        return !creator.getClass().isAnnotationPresent(ExcludeFirst.class);
    }

    public String[] getProtocols() {
        if (null == this.protocols) {
            this.protocols = new String[this.protocolCreators.size()];
            this.protocolCreators.keySet().toArray(this.protocols);
        }
        return this.protocols;
    }

    public static void setPluginId(String id) {
        if (id != null && id.length() > 0 && !id.equals(pluginId)) {
            pluginId = id;
            instance = DUMMY;
        }
    }

    public static String getPluginId() {
        return pluginId;
    }

    public static AasFactory getInstance() {
        if (DUMMY == instance) {
            Plugin plugin = PluginManager.getPlugin((String)pluginId, AasFactory.class);
            if (null != plugin) {
                instance = (AasFactory)plugin.getInstance();
                AasFactory.emitFactoryInstanceNotice();
            }
            if (DUMMY == instance || null == instance) {
                Optional first = ServiceLoaderUtils.filterExcluded(AasFactoryDescriptor.class);
                if (first.isPresent()) {
                    instance = ((AasFactoryDescriptor)first.get()).createInstance();
                    AasFactory.emitFactoryInstanceNotice();
                } else if (!noInstanceWarningEmitted) {
                    noInstanceWarningEmitted = true;
                    LOGGER.warn("No AAS factory implementation known. This may be intended in a simple testing setup where AAS operations are optional, but also a severe misconfiguration if this occurs in the context of a full platform instance where AAS operations are mandatory.");
                }
            }
        }
        return instance;
    }

    private static void emitFactoryInstanceNotice() {
        if (null != instance) {
            LOGGER.info("Using AAS factory implementation: {}", (Object)instance.getClass().getName());
        }
    }

    public static boolean isNoInstanceWarningEmitted() {
        return noInstanceWarningEmitted;
    }

    public static boolean isFullInstance() {
        return AasFactory.isFullInstance(AasFactory.getInstance());
    }

    public static boolean isFullInstance(AasFactory factory) {
        return factory != DUMMY && !ServiceLoaderUtils.hasExcludeFirst((Object)factory);
    }

    public static AasFactory setInstance(AasFactory newInstance) {
        AasFactory oldInstance = instance;
        if (null != newInstance) {
            instance = newInstance;
        }
        return oldInstance;
    }

    protected void registerProtocolCreator(String protocol, ProtocolCreator creator) {
        this.protocolCreators.put(protocol, creator);
    }

    public abstract String getName();

    public abstract Aas.AasBuilder createAasBuilder(String var1, String var2);

    public abstract Submodel.SubmodelBuilder createSubmodelBuilder(String var1, String var2);

    public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String identifier, SetupSpec spec) {
        return this.createSubmodelBuilder(idShort, identifier);
    }

    public final ServerRecipe createServerRecipe() {
        ServerRecipe result = null;
        Optional first = ServiceLoaderUtils.filterExcluded(AasServerRecipeDescriptor.class);
        if (first.isPresent()) {
            result = ((AasServerRecipeDescriptor)first.get()).createInstance();
        }
        if (null == result) {
            result = this.createDefaultServerRecipe();
        }
        return result;
    }

    protected abstract ServerRecipe createDefaultServerRecipe();

    public abstract Registry obtainRegistry(SetupSpec var1) throws IOException;

    public abstract Registry obtainRegistry(SetupSpec var1, Schema var2) throws IOException;

    public abstract DeploymentRecipe createDeploymentRecipe(SetupSpec var1);

    public abstract PersistenceRecipe createPersistenceRecipe();

    public InvocablesCreator createInvocablesCreator(SetupSpec spec) {
        ProtocolCreator creator;
        String protocol = spec.getAssetServerProtocol();
        if (null == protocol) {
            protocol = DEFAULT_PROTOCOL;
        }
        if (null == (creator = this.protocolCreators.get(protocol))) {
            throw new IllegalArgumentException("Unknown/unregistered protocol: " + protocol);
        }
        return creator.createInvocablesCreator(spec);
    }

    public ProtocolServerBuilder createProtocolServerBuilder(SetupSpec spec) {
        ProtocolCreator creator = this.protocolCreators.get(spec.getAssetServerProtocol());
        if (null == creator) {
            throw new IllegalArgumentException("Unknown/unregistered protocol: " + spec.getAssetServerProtocol());
        }
        return creator.createProtocolServerBuilder(spec);
    }

    protected boolean needsIdFix(String id) {
        return false;
    }

    public String fixId(String id) {
        Object result = id;
        if (id != null && ((String)id).length() > 0) {
            if (!Character.isAlphabetic(((String)id).charAt(0)) || this.needsIdFix((String)id)) {
                id = "a" + (String)id;
            }
            result = DEFAULT_PROTOCOL;
            for (int i = 0; i < ((String)id).length(); ++i) {
                char c = ((String)id).charAt(i);
                result = Character.isAlphabetic(c) || Character.isDigit(c) || c == '_' ? (String)result + c : (String)result + "_";
            }
        }
        return result;
    }

    public abstract String getMetaModelVersion();

    public boolean supportsSamePorts() {
        return false;
    }

    public boolean supportsUrlPaths() {
        return false;
    }

    public boolean supportsPropertyFunctions() {
        return false;
    }

    public boolean supportsAuthentication() {
        return true;
    }

    public boolean supportsOperationExecutionAuthorization() {
        return true;
    }

    public boolean createPropertiesEarly() {
        return false;
    }

    public static String composeIdShort(String ... names) {
        Object result = DEFAULT_PROTOCOL;
        for (String s : names) {
            if (s.length() <= 0) continue;
            if (((String)result).length() > 0) {
                result = (String)result + "_";
            }
            result = (String)result + s;
        }
        return result;
    }

    public boolean isAvailable(SetupSpec spec, SetupSpec.AasComponent component) {
        Function<SetupSpec.ComponentSetup, Boolean> func = this.available.get((Object)component);
        boolean result = null == func ? true : func.apply(spec.getSetup(component));
        return result;
    }

    protected void registerAvailabilityFunction(Function<SetupSpec.ComponentSetup, Boolean> func, SetupSpec.AasComponent ... components) {
        for (SetupSpec.AasComponent c : components) {
            this.available.put(c, func);
        }
    }

    public static interface ProtocolCreator {
        public InvocablesCreator createInvocablesCreator(SetupSpec var1);

        public ProtocolServerBuilder createProtocolServerBuilder(SetupSpec var1);
    }

    public static abstract class AbstractDescriptor
    implements AasFactoryDescriptor,
    PluginDescriptor<AasFactory> {
        public Class<AasFactory> getType() {
            return AasFactory.class;
        }

        public Plugin<AasFactory> createPlugin(File installDir) {
            return new SingletonPlugin(this.getId(), this.getFurtherIds(), AasFactory.class, p -> this.createInstance(), installDir);
        }
    }
}

