/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.FileFormat;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public interface PersistenceRecipe {
    public Collection<FileFormat> getSupportedFormats();

    default public void writeTo(List<Aas> aas, File file) throws IOException {
        this.writeTo(aas, null, null, file);
    }

    public void writeTo(List<Aas> var1, File var2, List<FileResource> var3, File var4) throws IOException;

    public List<Aas> readFrom(File var1) throws IOException;

    public static class FileResource {
        private byte[] fileContent;
        private String path;

        public FileResource(File file, String path) throws IOException {
            this(FileUtils.readFileToByteArray((File)file), path);
        }

        public FileResource(byte[] fileContent, String path) {
            this.fileContent = fileContent;
            this.path = path;
        }

        public byte[] getFileContent() {
            return this.fileContent;
        }

        public String getPath() {
            return this.path;
        }
    }
}

