/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.IdentifierType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public abstract class SemanticIdRecognizer {
    public static final SemanticIdRecognizer ECLASS_IRDI_RECOGNIZER = new EclassIrdiRecognizer();
    public static final SemanticIdRecognizer IEC_CCD_IRDI_RECOGNIZER = new IecCcdIrdiRecognizer();
    public static final SemanticIdRecognizer IDTA_IRI_RECOGNIZER = new IdtaIriRecognizer();
    public static final SemanticIdRecognizer URL_IRI_RECOGNIZER = new UrlIriRecognizer();
    private static final List<SemanticIdRecognizer> INSTANCES = new ArrayList<SemanticIdRecognizer>();

    public abstract boolean isFallback();

    public abstract boolean handles(String var1);

    public abstract String getIdentifierPrefix();

    public abstract String parseSemanticId(String var1);

    public String lastOfPath(String value) {
        return value;
    }

    public abstract boolean isASemanticId(String var1);

    public static SemanticIdRecognizer register(SemanticIdRecognizer recognizer) {
        if (null != recognizer) {
            if (recognizer.isFallback()) {
                INSTANCES.add(recognizer);
            } else {
                INSTANCES.add(0, recognizer);
            }
        }
        return recognizer;
    }

    public static void unregister(SemanticIdRecognizer recognizer) {
        if (null != recognizer) {
            INSTANCES.remove(recognizer);
        }
    }

    public static String getIdentifierPrefix(String value) {
        String result;
        block1: {
            result = null;
            if (null == value) break block1;
            for (SemanticIdRecognizer r : INSTANCES) {
                if (r.handles(value) && null != (result = r.getIdentifierPrefix())) break;
            }
        }
        return result;
    }

    public static String trySemanticIdWithDictionaryFrom(String value, String separator, boolean addPrefix, boolean fromPath) {
        int pos2;
        int pos;
        String result = null;
        if (null != separator && separator.length() > 0 && (pos = value.indexOf(separator)) > 0) {
            value = value.substring(0, pos);
        }
        if ((pos = value.indexOf("[")) >= 0 && (pos2 = value.indexOf("]", pos + 1)) > 0) {
            value = value.substring(pos2 + 1).trim();
        }
        String[] tmp = value.split(" ");
        for (pos = tmp.length; pos > 0 && result == null; --pos) {
            result = SemanticIdRecognizer.getSemanticIdFrom(String.join((CharSequence)" ", Arrays.copyOfRange(tmp, 0, pos)), addPrefix, fromPath);
        }
        return result;
    }

    public static String trySafeSemanticIdWithDictionaryFrom(String value, String separator, boolean addPrefix, boolean fromPath) {
        String result = null;
        if (value != null) {
            result = SemanticIdRecognizer.trySemanticIdWithDictionaryFrom(value, separator, addPrefix, fromPath);
        }
        return null == result ? value : result;
    }

    public static String getSemanticIdFrom(String value, boolean addPrefix) {
        return SemanticIdRecognizer.getSemanticIdFrom(value, addPrefix, false);
    }

    public static String getSemanticIdFrom(String value, boolean addPrefix, boolean fromPath) {
        String result = null;
        if (null != value) {
            for (SemanticIdRecognizer r : INSTANCES) {
                if (!r.handles(value) || null == (result = fromPath ? r.parseSemanticId(r.lastOfPath(value)) : r.parseSemanticId(value))) continue;
                if (!addPrefix) break;
                result = IdentifierType.compose(r.getIdentifierPrefix(), result);
                break;
            }
        }
        return result;
    }

    public static boolean isSemanticId(String value) {
        SemanticIdRecognizer r;
        boolean result = false;
        Iterator<SemanticIdRecognizer> iterator = INSTANCES.iterator();
        while (!(!iterator.hasNext() || (r = iterator.next()).handles(value) && (result = r.isASemanticId(value)))) {
        }
        return result;
    }

    public static String replaceWhitespace(String data, String replacement) {
        String result = data;
        if (data != null) {
            result = data.replace("\n", replacement).replace("\r", replacement).replace(" ", replacement);
        }
        return result;
    }

    protected String splitAndCombine(String value, SplitAndCombinePredicate predicate) {
        value = SemanticIdRecognizer.replaceWhitespace(value, " ");
        String[] tmp = value.split(" ");
        Object result = tmp[0];
        for (int i = 1; i < tmp.length; ++i) {
            if (null != predicate && !predicate.isCombinable((String)result, tmp[i])) continue;
            String tmpId = (String)result + tmp[i];
            if (!this.isASemanticId(tmpId)) break;
            result = tmpId;
        }
        if (!this.isASemanticId((String)result)) {
            result = null;
        }
        return result;
    }

    static {
        SemanticIdRecognizer.register(ECLASS_IRDI_RECOGNIZER);
        SemanticIdRecognizer.register(IEC_CCD_IRDI_RECOGNIZER);
        SemanticIdRecognizer.register(IDTA_IRI_RECOGNIZER);
        SemanticIdRecognizer.register(URL_IRI_RECOGNIZER);
    }

    protected static interface SplitAndCombinePredicate {
        public boolean isCombinable(String var1, String var2);
    }

    private static class EclassIrdiRecognizer
    extends PatternIrdiRecognizer {
        private static final Pattern PATTERN = Pattern.compile("^\\d+-\\d#\\d+-[A-Z]+\\d+#\\d+$");

        private EclassIrdiRecognizer() {
        }

        @Override
        protected Pattern getPattern() {
            return PATTERN;
        }

        @Override
        public boolean handles(String value) {
            return value.startsWith("0173-");
        }

        @Override
        public String lastOfPath(String value) {
            String result = value;
            int pos = value.lastIndexOf("/");
            if (pos > 0) {
                result = value.substring(pos + 1);
            }
            return result;
        }
    }

    private static class IecCcdIrdiRecognizer
    extends PatternIrdiRecognizer {
        private static final Pattern PATTERN = Pattern.compile("^\\d+/\\d+///\\d+#[A-Z0-9]+\\d+.*$");

        private IecCcdIrdiRecognizer() {
        }

        @Override
        protected Pattern getPattern() {
            return PATTERN;
        }

        @Override
        public boolean handles(String value) {
            return value.startsWith("0112/");
        }
    }

    private static class IdtaIriRecognizer
    extends UrlIriRecognizer {
        private IdtaIriRecognizer() {
        }

        @Override
        public boolean isFallback() {
            return false;
        }

        @Override
        public boolean handles(String value) {
            return value.startsWith("https://admin-shell.io/");
        }
    }

    private static class UrlIriRecognizer
    extends SemanticIdRecognizer {
        private static final Pattern HANDLES_PATTERN = Pattern.compile("^(https?|ftp|file)://.*");
        private static final Pattern PATTERN = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");

        private UrlIriRecognizer() {
        }

        @Override
        public boolean isFallback() {
            return true;
        }

        @Override
        public boolean handles(String value) {
            return HANDLES_PATTERN.matcher(value).matches();
        }

        @Override
        public String getIdentifierPrefix() {
            return "iri:";
        }

        @Override
        public String parseSemanticId(String value) {
            return this.splitAndCombine(value, (b, a) -> this.isCombinable(b, a));
        }

        private boolean isCombinable(String before, String after) {
            boolean result = before.endsWith("-") ? true : (Character.isDigit(before.charAt(before.length() - 1)) ? after.startsWith("/") : before.endsWith("/") || after.startsWith("/") || after.contains("/") || after.length() < 10);
            return result;
        }

        @Override
        public boolean isASemanticId(String value) {
            return PATTERN.matcher(value).matches();
        }
    }

    private static abstract class PatternIrdiRecognizer
    extends SemanticIdRecognizer {
        private PatternIrdiRecognizer() {
        }

        protected abstract Pattern getPattern();

        @Override
        public boolean isFallback() {
            return false;
        }

        @Override
        public String getIdentifierPrefix() {
            return "irdi:";
        }

        @Override
        public String parseSemanticId(String value) {
            return this.splitAndCombine(value, null);
        }

        @Override
        public boolean isASemanticId(String value) {
            return this.getPattern().matcher(value).matches();
        }
    }
}

