/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;

public interface SetupSpec {
    public ComponentSetup getSetup(AasComponent var1);

    default public Endpoint getAasRegistryEndpoint() {
        return this.getSetup(AasComponent.AAS_REGISTRY).getEndpoint();
    }

    default public KeyStoreDescriptor getAasRegistryKeyStore() {
        return this.getSetup(AasComponent.AAS_REGISTRY).getKeyStore();
    }

    default public State getAasRegistryState() {
        return this.getSetup(AasComponent.AAS_REGISTRY).getState();
    }

    default public void notifyAasRegistryStateChange(State state) {
        this.getSetup(AasComponent.AAS_REGISTRY).notifyStateChange(state);
    }

    default public Endpoint getSubmodelRegistryEndpoint() {
        return this.getSetup(AasComponent.SUBMODEL_REGISTRY).getEndpoint();
    }

    default public KeyStoreDescriptor getSubmodelRegistryKeyStore() {
        return this.getSetup(AasComponent.SUBMODEL_REGISTRY).getKeyStore();
    }

    default public State getSubmodelRegistryState() {
        return this.getSetup(AasComponent.SUBMODEL_REGISTRY).getState();
    }

    default public void notifySubmodelRegistryStateChange(State state) {
        this.getSetup(AasComponent.SUBMODEL_REGISTRY).notifyStateChange(state);
    }

    default public Endpoint getAasRepositoryEndpoint() {
        return this.getSetup(AasComponent.AAS_REPOSITORY).getEndpoint();
    }

    default public State getAasRepositoryState() {
        return this.getSetup(AasComponent.AAS_REPOSITORY).getState();
    }

    default public void notifyAasRepositoryStateChange(State state) {
        this.getSetup(AasComponent.AAS_REPOSITORY).notifyStateChange(state);
    }

    default public KeyStoreDescriptor getAasRepositoryKeyStore() {
        return this.getSetup(AasComponent.AAS_REPOSITORY).getKeyStore();
    }

    default public Endpoint getSubmodelRepositoryEndpoint() {
        return this.getSetup(AasComponent.SUBMODEL_REPOSITORY).getEndpoint();
    }

    default public State getSubmodelRepositoryState() {
        return this.getSetup(AasComponent.SUBMODEL_REPOSITORY).getState();
    }

    default public void notifySubmodelRepositoryStateChange(State state) {
        this.getSetup(AasComponent.SUBMODEL_REPOSITORY).notifyStateChange(state);
    }

    default public KeyStoreDescriptor getSubmodelRepositoryKeyStore() {
        return this.getSetup(AasComponent.SUBMODEL_REPOSITORY).getKeyStore();
    }

    default public boolean areRegistriesRunning() {
        return this.getAasRegistryState() == State.RUNNING && this.getSubmodelRegistryState() == State.RUNNING;
    }

    default public ServerAddress getAssetServerAddress() {
        return this.getSetup(AasComponent.ASSET).getServerAddress();
    }

    public String getAssetServerProtocol();

    default public State getAssetServerState() {
        return this.getSetup(AasComponent.ASSET).getState();
    }

    default public void notifyAssetServerStateChange(State state) {
        this.getSetup(AasComponent.ASSET).notifyStateChange(state);
    }

    default public KeyStoreDescriptor getAssetServerKeyStore() {
        return this.getSetup(AasComponent.ASSET).getKeyStore();
    }

    public static enum AasComponent {
        AAS_REGISTRY,
        AAS_REPOSITORY,
        SUBMODEL_REGISTRY,
        SUBMODEL_REPOSITORY,
        ASSET;

    }

    public static interface ComponentSetup {
        default public ServerAddress getServerAddress() {
            return this.getEndpoint();
        }

        public Endpoint getEndpoint();

        public KeyStoreDescriptor getKeyStore();

        public AuthenticationDescriptor getAuthentication();

        public State getState();

        public void notifyStateChange(State var1);
    }

    public static enum State {
        EXTERNAL,
        RUNNING,
        STOPPED;

    }
}

