/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.carbonFootprint;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.types.carbonFootprint.CarbonFootprintBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodel;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import java.util.Date;
import java.util.concurrent.ExecutionException;

public class CarbonFootprint
extends DelegatingSubmodel {
    public CarbonFootprint(Aas aas) {
        super(aas.getSubmodel("CarbonFootprint"));
    }

    public ProductCarbonFootprint getProductCarbonFootprint(int index) {
        SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("ProductCarbonFootprint", index));
        return null == tmp ? null : new ProductCarbonFootprint(tmp);
    }

    public TransportCarbonFootprint getTransportCarbonFootprint(int index) {
        SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("TransportCarbonFootprint", index));
        return null == tmp ? null : new TransportCarbonFootprint(tmp);
    }

    public static class ProductCarbonFootprint
    extends DelegatingSubmodelElementCollection {
        protected ProductCarbonFootprint(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getPCFCalculationMethodProperty(int index) {
            return this.getProperty(Utils.getCountingIdShort("PCFCalculationMethod", index));
        }

        public Iterable<CarbonFootprintBuilder.PCFCalculationMethod> getPCFCalculationMethod() throws ExecutionException {
            return Utils.collect(this.elements(), Property.class, IdentifierType.irdi("0173-1#02-ABG854#002"), p -> Utils.getEnumValue(p, CarbonFootprintBuilder.PCFCalculationMethod.class, CarbonFootprintBuilder.PCFCalculationMethod.class));
        }

        public Property getPCFCO2eqProperty() {
            return this.getProperty("PCFCO2eq");
        }

        public double getPCFCO2eq() throws ExecutionException {
            return Utils.getDoubleValue(this, "PCFCO2eq");
        }

        public Property getPCFReferenceValueForCalculationProperty() {
            return this.getProperty("PCFReferenceValueForCalculation");
        }

        public CarbonFootprintBuilder.PCFReferenceValueForCalculation getPCFReferenceValueForCalculation() throws ExecutionException {
            return Utils.getEnumValue(this, "PCFReferenceValueForCalculation", CarbonFootprintBuilder.PCFReferenceValueForCalculation.class, CarbonFootprintBuilder.PCFReferenceValueForCalculation.class);
        }

        public Property getPCFQuantityOfMeasureForCalculationProperty() {
            return this.getProperty("PCFQuantityOfMeasureForCalculation");
        }

        public double getPCFQuantityOfMeasureForCalculation() throws ExecutionException {
            return Utils.getDoubleValue(this, "PCFQuantityOfMeasureForCalculation");
        }

        public Property getPCFLifeCyclePhaseProperty(int index) {
            return this.getProperty(Utils.getCountingIdShort("PCFLifeCyclePhase", index));
        }

        public Iterable<CarbonFootprintBuilder.PCFLifeCyclePhase> getPCFLifeCyclePhase() throws ExecutionException {
            return Utils.collect(this.elements(), Property.class, IdentifierType.irdi("0173-1#02-ABG858#001"), p -> Utils.getEnumValue(p, CarbonFootprintBuilder.PCFLifeCyclePhase.class, CarbonFootprintBuilder.PCFLifeCyclePhase.class));
        }

        public FileDataElement getExplanatoryStatementProperty() {
            return (FileDataElement)this.getDataElement("ExplanatoryStatement");
        }

        public FileDataElement getExplanatoryStatement() throws ExecutionException {
            return Utils.getFileDataElementValue(this, "ExplanatoryStatement");
        }

        public PCFGoodsAddressHandover getPCFGoodsAddressHandover() {
            return new PCFGoodsAddressHandover(super.getSubmodelElementCollection("PCFGoodsAddressHandover"));
        }

        public Property getPublicationDateProperty() {
            return this.getProperty("PublicationDate");
        }

        public Date getPublicationDate() throws ExecutionException {
            return Utils.getDateValue(this, "PublicationDate");
        }

        public Property getExpirationDateProperty() {
            return this.getProperty("ExpirationDate");
        }

        public Date getExpirationDate() throws ExecutionException {
            return Utils.getDateValue(this, "ExpirationDate");
        }
    }

    public static class TransportCarbonFootprint
    extends DelegatingSubmodelElementCollection {
        protected TransportCarbonFootprint(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getTCFCalculationMethodProperty() {
            return this.getProperty("TCFCalculationMethod");
        }

        public CarbonFootprintBuilder.TCFCalculationMethod getTCFCalculationMethod() throws ExecutionException {
            return Utils.getEnumValue(this, "TCFCalculationMethod", CarbonFootprintBuilder.TCFCalculationMethod.class, CarbonFootprintBuilder.TCFCalculationMethod.class);
        }

        public Property getTCFCO2eqProperty() {
            return this.getProperty("TCFCO2eq");
        }

        public double getTCFCO2eq() throws ExecutionException {
            return Utils.getDoubleValue(this, "TCFCO2eq");
        }

        public Property getTCFReferenceValueForCalculationProperty() {
            return this.getProperty("TCFReferenceValueForCalculation");
        }

        public CarbonFootprintBuilder.TCFReferenceValueForCalculation getTCFReferenceValueForCalculation() throws ExecutionException {
            return Utils.getEnumValue(this, "TCFReferenceValueForCalculation", CarbonFootprintBuilder.TCFReferenceValueForCalculation.class, CarbonFootprintBuilder.TCFReferenceValueForCalculation.class);
        }

        public Property getTCFQuantityOfMeasureForCalculationProperty() {
            return this.getProperty("TCFQuantityOfMeasureForCalculation");
        }

        public double getTCFQuantityOfMeasureForCalculation() throws ExecutionException {
            return Utils.getDoubleValue(this, "TCFQuantityOfMeasureForCalculation");
        }

        public Property getTCFProcessesForGreenhouseGasEmissionInATransportServiceProperty(int index) {
            return this.getProperty(Utils.getCountingIdShort("TCFProcessesForGreenhouseGasEmissionInATransportService", index));
        }

        public Iterable<CarbonFootprintBuilder.TCFProcessesForGreenhouseGasEmissionInATransportService> getTCFProcessesForGreenhouseGasEmissionInATransportService() throws ExecutionException {
            return Utils.collect(this.elements(), Property.class, IdentifierType.irdi("0173-1#02-ABG863#002"), p -> Utils.getEnumValue(p, CarbonFootprintBuilder.TCFProcessesForGreenhouseGasEmissionInATransportService.class, CarbonFootprintBuilder.TCFProcessesForGreenhouseGasEmissionInATransportService.class));
        }

        public FileDataElement getExplanatoryStatementProperty() {
            return (FileDataElement)this.getDataElement("ExplanatoryStatement");
        }

        public FileDataElement getExplanatoryStatement() throws ExecutionException {
            return Utils.getFileDataElementValue(this, "ExplanatoryStatement");
        }

        public TCFGoodsTransportAddressHandover getTCFGoodsTransportAddressTakeover() {
            return new TCFGoodsTransportAddressHandover(super.getSubmodelElementCollection("TCFGoodsTransportAddressHandover"));
        }

        public TCFGoodsTransportAddressHandover getTCFGoodsTransportAddressHandover() {
            return new TCFGoodsTransportAddressHandover(super.getSubmodelElementCollection("TCFGoodsTransportAddressHandover"));
        }

        public Property getPublicationDateProperty() {
            return this.getProperty("PublicationDate");
        }

        public Date getPublicationDate() throws ExecutionException {
            return Utils.getDateValue(this, "PublicationDate");
        }

        public Property getExpirationDateProperty() {
            return this.getProperty("ExpirationDate");
        }

        public Date getExpirationDate() throws ExecutionException {
            return Utils.getDateValue(this, "ExpirationDate");
        }
    }

    public static class TCFGoodsTransportAddressHandover
    extends DelegatingSubmodelElementCollection {
        protected TCFGoodsTransportAddressHandover(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getStreetProperty() {
            return this.getProperty("Street");
        }

        public String getStreet() throws ExecutionException {
            return Utils.getStringValue(this, "Street");
        }

        public Property getHouseNumberProperty() {
            return this.getProperty("HouseNumber");
        }

        public String getHouseNumber() throws ExecutionException {
            return Utils.getStringValue(this, "HouseNumber");
        }

        public Property getZipCodeProperty() {
            return this.getProperty("ZipCode");
        }

        public String getZipCode() throws ExecutionException {
            return Utils.getStringValue(this, "ZipCode");
        }

        public Property getCityTownProperty() {
            return this.getProperty("CityTown");
        }

        public String getCityTown() throws ExecutionException {
            return Utils.getStringValue(this, "CityTown");
        }

        public Property getCountryProperty() {
            return this.getProperty("Country");
        }

        public String getCountry() throws ExecutionException {
            return Utils.getStringValue(this, "Country");
        }
    }

    public static class PCFGoodsAddressHandover
    extends DelegatingSubmodelElementCollection {
        protected PCFGoodsAddressHandover(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getStreetProperty() {
            return this.getProperty("Street");
        }

        public String getStreet() throws ExecutionException {
            return Utils.getStringValue(this, "Street");
        }

        public Property getHouseNumberProperty() {
            return this.getProperty("HouseNumber");
        }

        public String getHouseNumber() throws ExecutionException {
            return Utils.getStringValue(this, "HouseNumber");
        }

        public Property getZipCodeProperty() {
            return this.getProperty("ZipCode");
        }

        public String getZipCode() throws ExecutionException {
            return Utils.getStringValue(this, "ZipCode");
        }

        public Property getCityTownProperty() {
            return this.getProperty("CityTown");
        }

        public String getCityTown() throws ExecutionException {
            return Utils.getStringValue(this, "CityTown");
        }

        public Property getCountryProperty() {
            return this.getProperty("Country");
        }

        public String getCountry() throws ExecutionException {
            return Utils.getStringValue(this, "Country");
        }
    }
}

