/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.carbonFootprint;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollectionBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import java.util.Date;

public class CarbonFootprintBuilder
extends DelegatingSubmodelBuilder {
    private boolean createMultiLanguageProperties = true;
    private int productCarbonFootprintCounter = 0;
    private int transportCarbonFootprintCounter = 0;

    public CarbonFootprintBuilder(Aas.AasBuilder aasBuilder, String identifier) {
        this(aasBuilder, identifier, "CarbonFootprint");
    }

    public CarbonFootprintBuilder(Aas.AasBuilder aasBuilder, String identifier, String idShort) {
        super(aasBuilder.createSubmodelBuilder(idShort, identifier));
        this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/CarbonFootprint/CarbonFootprint/0/9"));
    }

    public void setCreateMultiLanguageProperties(boolean createMultiLanguageProperties) {
        this.createMultiLanguageProperties = createMultiLanguageProperties;
    }

    public ProductCarbonFootprintBuilder createProductCarbonFootprintBuilder() {
        return new ProductCarbonFootprintBuilder(this, ++this.productCarbonFootprintCounter);
    }

    public TransportCarbonFootprintBuilder createTransportCarbonFootprintBuilder() {
        return new TransportCarbonFootprintBuilder(this, ++this.transportCarbonFootprintCounter);
    }

    @Override
    public Submodel build() {
        Utils.assertThat(0 <= this.productCarbonFootprintCounter, "Cardinality {} of ProductCarbonFootprint must be greater or equal 0.", this.productCarbonFootprintCounter);
        Utils.assertThat(0 <= this.transportCarbonFootprintCounter, "Cardinality {} of TransportCarbonFootprint must be greater or equal 0.", this.transportCarbonFootprintCounter);
        return super.build();
    }

    public class ProductCarbonFootprintBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int pCFCalculationMethodCounter;
        private int pCFCO2eqCounter;
        private int pCFReferenceValueForCalculationCounter;
        private int pCFQuantityOfMeasureForCalculationCounter;
        private int pCFLifeCyclePhaseCounter;
        private int explanatoryStatementCounter;
        private int pCFGoodsAddressHandoverCounter;
        private int publicationDateCounter;
        private int expirationDateCounter;

        protected ProductCarbonFootprintBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("ProductCarbonFootprint"), smBuilder);
            this.pCFCalculationMethodCounter = 0;
            this.pCFCO2eqCounter = 0;
            this.pCFReferenceValueForCalculationCounter = 0;
            this.pCFQuantityOfMeasureForCalculationCounter = 0;
            this.pCFLifeCyclePhaseCounter = 0;
            this.explanatoryStatementCounter = 0;
            this.pCFGoodsAddressHandoverCounter = 0;
            this.publicationDateCounter = 0;
            this.expirationDateCounter = 0;
            this.setSemanticId(IdentifierType.irdi("https://admin-shell.io/idta/CarbonFootprint/ProductCarbonFootprint/0/9"));
        }

        protected ProductCarbonFootprintBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("ProductCarbonFootprint", nr)), smBuilder);
            this.pCFCalculationMethodCounter = 0;
            this.pCFCO2eqCounter = 0;
            this.pCFReferenceValueForCalculationCounter = 0;
            this.pCFQuantityOfMeasureForCalculationCounter = 0;
            this.pCFLifeCyclePhaseCounter = 0;
            this.explanatoryStatementCounter = 0;
            this.pCFGoodsAddressHandoverCounter = 0;
            this.publicationDateCounter = 0;
            this.expirationDateCounter = 0;
            this.setSemanticId(IdentifierType.irdi("https://admin-shell.io/idta/CarbonFootprint/ProductCarbonFootprint/0/9"));
        }

        public ProductCarbonFootprintBuilder setPCFCalculationMethod(PCFCalculationMethod pCFCalculationMethod) {
            this.createPropertyBuilder(Utils.getCountingIdShort("PCFCalculationMethod", ++this.pCFCalculationMethodCounter)).setSemanticId(IdentifierType.irdi("0173-1#02-ABG854#002")).setValue(Type.STRING, pCFCalculationMethod.getValue()).build();
            return this;
        }

        public ProductCarbonFootprintBuilder setPCFCO2eq(double pCFCO2eq) {
            ++this.pCFCO2eqCounter;
            this.createPropertyBuilder("PCFCO2eq").setSemanticId(IdentifierType.irdi("0173-1#02-ABG855#001")).setValue(Type.DOUBLE, pCFCO2eq).build();
            return this;
        }

        public ProductCarbonFootprintBuilder setPCFReferenceValueForCalculation(PCFReferenceValueForCalculation pCFReferenceValueForCalculation) {
            ++this.pCFReferenceValueForCalculationCounter;
            this.createPropertyBuilder("PCFReferenceValueForCalculation").setSemanticId(IdentifierType.irdi("0173-1#02-ABG856#001")).setValue(Type.STRING, pCFReferenceValueForCalculation.getValue()).build();
            return this;
        }

        public ProductCarbonFootprintBuilder setPCFQuantityOfMeasureForCalculation(double pCFQuantityOfMeasureForCalculation) {
            ++this.pCFQuantityOfMeasureForCalculationCounter;
            this.createPropertyBuilder("PCFQuantityOfMeasureForCalculation").setSemanticId(IdentifierType.irdi("0173-1#02-ABG857#001")).setValue(Type.DOUBLE, pCFQuantityOfMeasureForCalculation).build();
            return this;
        }

        public ProductCarbonFootprintBuilder setPCFLifeCyclePhase(PCFLifeCyclePhase pCFLifeCyclePhase) {
            this.createPropertyBuilder(Utils.getCountingIdShort("PCFLifeCyclePhase", ++this.pCFLifeCyclePhaseCounter)).setSemanticId(IdentifierType.irdi("0173-1#02-ABG858#001")).setValue(Type.STRING, pCFLifeCyclePhase.getValue()).build();
            return this;
        }

        public ProductCarbonFootprintBuilder setExplanatoryStatement(String file, String mimeType) {
            ++this.explanatoryStatementCounter;
            this.createFileDataElementBuilder("ExplanatoryStatement", file, mimeType).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/CarbonFootprint/ExplanatoryStatement/1/0")).build();
            return this;
        }

        public PCFGoodsAddressHandoverBuilder createPCFGoodsAddressHandoverBuilder() {
            ++this.pCFGoodsAddressHandoverCounter;
            return new PCFGoodsAddressHandoverBuilder(this);
        }

        public ProductCarbonFootprintBuilder setPublicationDate(Date publicationDate) {
            ++this.publicationDateCounter;
            this.createPropertyBuilder("PublicationDate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/CarbonFootprint/PublicationDate/1/0")).setValue(Type.DATE_TIME, publicationDate).build();
            return this;
        }

        public ProductCarbonFootprintBuilder setExpirationDate(Date expirationDate) {
            ++this.expirationDateCounter;
            this.createPropertyBuilder("ExpirationDate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/CarbonFootprint/ExpirationnDate/1/0")).setValue(Type.DATE_TIME, expirationDate).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(1 <= this.pCFCalculationMethodCounter, "Cardinality {} of PCFCalculationMethod must be greater or equal 1.", this.pCFCalculationMethodCounter);
            Utils.assertThat(this.pCFCO2eqCounter == 1, "Cardinality {} of PCFCO2eq must be equal 1.", this.pCFCO2eqCounter);
            Utils.assertThat(this.pCFReferenceValueForCalculationCounter == 1, "Cardinality {} of PCFReferenceValueForCalculation must be equal 1.", this.pCFReferenceValueForCalculationCounter);
            Utils.assertThat(this.pCFQuantityOfMeasureForCalculationCounter == 1, "Cardinality {} of PCFQuantityOfMeasureForCalculation must be equal 1.", this.pCFQuantityOfMeasureForCalculationCounter);
            Utils.assertThat(1 <= this.pCFLifeCyclePhaseCounter, "Cardinality {} of PCFLifeCyclePhase must be greater or equal 1.", this.pCFLifeCyclePhaseCounter);
            Utils.assertThat(0 <= this.explanatoryStatementCounter && this.explanatoryStatementCounter <= 1, "Cardinality {} of ExplanatoryStatement must be greater or equal 0 and less or equal 1.", this.explanatoryStatementCounter);
            Utils.assertThat(this.pCFGoodsAddressHandoverCounter == 1, "Cardinality {} of PCFGoodsAddressHandover must be equal 1.", this.pCFGoodsAddressHandoverCounter);
            Utils.assertThat(this.publicationDateCounter == 1, "Cardinality {} of PublicationDate must be equal 1.", this.publicationDateCounter);
            Utils.assertThat(0 <= this.expirationDateCounter && this.expirationDateCounter <= 1, "Cardinality {} of ExpirationDate must be greater or equal 0 and less or equal 1.", this.expirationDateCounter);
            return super.build();
        }
    }

    public class TransportCarbonFootprintBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int tCFCalculationMethodCounter;
        private int tCFCO2eqCounter;
        private int tCFReferenceValueForCalculationCounter;
        private int tCFQuantityOfMeasureForCalculationCounter;
        private int tCFProcessesForGreenhouseGasEmissionInATransportServiceCounter;
        private int explanatoryStatementCounter;
        private int tCFGoodsTransportAddressTakeoverCounter;
        private int tCFGoodsTransportAddressHandoverCounter;
        private int publicationDateCounter;
        private int expirationDateCounter;

        protected TransportCarbonFootprintBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("TransportCarbonFootprint"), smBuilder);
            this.tCFCalculationMethodCounter = 0;
            this.tCFCO2eqCounter = 0;
            this.tCFReferenceValueForCalculationCounter = 0;
            this.tCFQuantityOfMeasureForCalculationCounter = 0;
            this.tCFProcessesForGreenhouseGasEmissionInATransportServiceCounter = 0;
            this.explanatoryStatementCounter = 0;
            this.tCFGoodsTransportAddressTakeoverCounter = 0;
            this.tCFGoodsTransportAddressHandoverCounter = 0;
            this.publicationDateCounter = 0;
            this.expirationDateCounter = 0;
            this.setSemanticId(IdentifierType.irdi("https://admin-shell.io/idta/CarbonFootprint/TransportCarbonFootprint/0/9"));
        }

        protected TransportCarbonFootprintBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("TransportCarbonFootprint", nr)), smBuilder);
            this.tCFCalculationMethodCounter = 0;
            this.tCFCO2eqCounter = 0;
            this.tCFReferenceValueForCalculationCounter = 0;
            this.tCFQuantityOfMeasureForCalculationCounter = 0;
            this.tCFProcessesForGreenhouseGasEmissionInATransportServiceCounter = 0;
            this.explanatoryStatementCounter = 0;
            this.tCFGoodsTransportAddressTakeoverCounter = 0;
            this.tCFGoodsTransportAddressHandoverCounter = 0;
            this.publicationDateCounter = 0;
            this.expirationDateCounter = 0;
            this.setSemanticId(IdentifierType.irdi("https://admin-shell.io/idta/CarbonFootprint/TransportCarbonFootprint/0/9"));
        }

        public TransportCarbonFootprintBuilder setTCFCalculationMethod(TCFCalculationMethod tCFCalculationMethod) {
            ++this.tCFCalculationMethodCounter;
            this.createPropertyBuilder("TCFCalculationMethod").setSemanticId(IdentifierType.irdi("0173-1#02-ABG859#002")).setValue(Type.STRING, tCFCalculationMethod.getValue()).build();
            return this;
        }

        public TransportCarbonFootprintBuilder setTCFCO2eq(double tCFCO2eq) {
            ++this.tCFCO2eqCounter;
            this.createPropertyBuilder("TCFCO2eq").setSemanticId(IdentifierType.irdi("0173-1#02-ABG860#001")).setValue(Type.DOUBLE, tCFCO2eq).build();
            return this;
        }

        public TransportCarbonFootprintBuilder setTCFReferenceValueForCalculation(TCFReferenceValueForCalculation tCFReferenceValueForCalculation) {
            ++this.tCFReferenceValueForCalculationCounter;
            this.createPropertyBuilder("TCFReferenceValueForCalculation").setSemanticId(IdentifierType.irdi("0173-1#02-ABG861#002")).setValue(Type.STRING, tCFReferenceValueForCalculation.getValue()).build();
            return this;
        }

        public TransportCarbonFootprintBuilder setTCFQuantityOfMeasureForCalculation(double tCFQuantityOfMeasureForCalculation) {
            ++this.tCFQuantityOfMeasureForCalculationCounter;
            this.createPropertyBuilder("TCFQuantityOfMeasureForCalculation").setSemanticId(IdentifierType.irdi("0173-1#02-ABG862#001")).setValue(Type.DOUBLE, tCFQuantityOfMeasureForCalculation).build();
            return this;
        }

        public TransportCarbonFootprintBuilder setTCFProcessesForGreenhouseGasEmissionInATransportService(TCFProcessesForGreenhouseGasEmissionInATransportService tCFProcessesForGreenhouseGasEmissionInATransportService) {
            this.createPropertyBuilder(Utils.getCountingIdShort("TCFProcessesForGreenhouseGasEmissionInATransportService", ++this.tCFProcessesForGreenhouseGasEmissionInATransportServiceCounter)).setSemanticId(IdentifierType.irdi("0173-1#02-ABG863#002")).setValue(Type.STRING, tCFProcessesForGreenhouseGasEmissionInATransportService.getValue()).build();
            return this;
        }

        public TransportCarbonFootprintBuilder setExplanatoryStatement(String file, String mimeType) {
            ++this.explanatoryStatementCounter;
            this.createFileDataElementBuilder("ExplanatoryStatement", file, mimeType).setSemanticId(IdentifierType.irdi("https://admin-shell.io/idta/CarbonFootprint/ExplanatoryStatement/1/0")).build();
            return this;
        }

        public TCFGoodsTransportAddressHandoverBuilder createTCFGoodsTransportAddressTakeoverBuilder() {
            ++this.tCFGoodsTransportAddressTakeoverCounter;
            return new TCFGoodsTransportAddressHandoverBuilder(this);
        }

        public TCFGoodsTransportAddressHandoverBuilder createTCFGoodsTransportAddressHandoverBuilder() {
            ++this.tCFGoodsTransportAddressHandoverCounter;
            return new TCFGoodsTransportAddressHandoverBuilder(this);
        }

        public TransportCarbonFootprintBuilder setPublicationDate(Date publicationDate) {
            ++this.publicationDateCounter;
            this.createPropertyBuilder("PublicationDate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/CarbonFootprint/PublicationDate/1/0")).setValue(Type.DATE_TIME, publicationDate).build();
            return this;
        }

        public TransportCarbonFootprintBuilder setExpirationDate(Date expirationDate) {
            ++this.expirationDateCounter;
            this.createPropertyBuilder("ExpirationDate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/CarbonFootprint/ExpirationnDate/1/0")).setValue(Type.DATE_TIME, expirationDate).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.tCFCalculationMethodCounter == 1, "Cardinality {} of TCFCalculationMethod must be equal 1.", this.tCFCalculationMethodCounter);
            Utils.assertThat(this.tCFCO2eqCounter == 1, "Cardinality {} of TCFCO2eq must be equal 1.", this.tCFCO2eqCounter);
            Utils.assertThat(this.tCFReferenceValueForCalculationCounter == 1, "Cardinality {} of TCFReferenceValueForCalculation must be equal 1.", this.tCFReferenceValueForCalculationCounter);
            Utils.assertThat(this.tCFQuantityOfMeasureForCalculationCounter == 1, "Cardinality {} of TCFQuantityOfMeasureForCalculation must be equal 1.", this.tCFQuantityOfMeasureForCalculationCounter);
            Utils.assertThat(1 <= this.tCFProcessesForGreenhouseGasEmissionInATransportServiceCounter, "Cardinality {} of TCFProcessesForGreenhouseGasEmissionInATransportService must be greater or equal 1.", this.tCFProcessesForGreenhouseGasEmissionInATransportServiceCounter);
            Utils.assertThat(0 <= this.explanatoryStatementCounter && this.explanatoryStatementCounter <= 1, "Cardinality {} of ExplanatoryStatement must be greater or equal 0 and less or equal 1.", this.explanatoryStatementCounter);
            Utils.assertThat(this.tCFGoodsTransportAddressTakeoverCounter == 1, "Cardinality {} of TCFGoodsTransportAddressTakeover must be equal 1.", this.tCFGoodsTransportAddressTakeoverCounter);
            Utils.assertThat(this.tCFGoodsTransportAddressHandoverCounter == 1, "Cardinality {} of TCFGoodsTransportAddressHandover must be equal 1.", this.tCFGoodsTransportAddressHandoverCounter);
            Utils.assertThat(this.publicationDateCounter == 1, "Cardinality {} of PublicationDate must be equal 1.", this.publicationDateCounter);
            Utils.assertThat(0 <= this.expirationDateCounter && this.expirationDateCounter <= 1, "Cardinality {} of ExpirationDate must be greater or equal 0 and less or equal 1.", this.expirationDateCounter);
            return super.build();
        }
    }

    public class TCFGoodsTransportAddressHandoverBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int streetCounter;
        private int houseNumberCounter;
        private int zipCodeCounter;
        private int cityTownCounter;
        private int countryCounter;

        protected TCFGoodsTransportAddressHandoverBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("TCFGoodsTransportAddressHandover"), smBuilder);
            this.streetCounter = 0;
            this.houseNumberCounter = 0;
            this.zipCodeCounter = 0;
            this.cityTownCounter = 0;
            this.countryCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#02-ABI499#001"));
        }

        protected TCFGoodsTransportAddressHandoverBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("TCFGoodsTransportAddressHandover", nr)), smBuilder);
            this.streetCounter = 0;
            this.houseNumberCounter = 0;
            this.zipCodeCounter = 0;
            this.cityTownCounter = 0;
            this.countryCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#02-ABI499#001"));
        }

        public TCFGoodsTransportAddressHandoverBuilder setStreet(String street) {
            ++this.streetCounter;
            this.createPropertyBuilder("Street").setSemanticId(IdentifierType.irdi("0173-1#02-ABH956#001")).setValue(Type.STRING, street).build();
            return this;
        }

        public TCFGoodsTransportAddressHandoverBuilder setHouseNumber(String houseNumber) {
            ++this.houseNumberCounter;
            this.createPropertyBuilder("HouseNumber").setSemanticId(IdentifierType.irdi("0173-1#02-ABH957#001")).setValue(Type.STRING, houseNumber).build();
            return this;
        }

        public TCFGoodsTransportAddressHandoverBuilder setZipCode(String zipCode) {
            ++this.zipCodeCounter;
            this.createPropertyBuilder("ZipCode").setSemanticId(IdentifierType.irdi("0173-1#02-ABH958#001")).setValue(Type.STRING, zipCode).build();
            return this;
        }

        public TCFGoodsTransportAddressHandoverBuilder setCityTown(String cityTown) {
            ++this.cityTownCounter;
            this.createPropertyBuilder("CityTown").setSemanticId(IdentifierType.irdi("0173-1#02-ABH959#001")).setValue(Type.STRING, cityTown).build();
            return this;
        }

        public TCFGoodsTransportAddressHandoverBuilder setCountry(String country) {
            ++this.countryCounter;
            this.createPropertyBuilder("Country").setSemanticId(IdentifierType.irdi("0173-1#02-AAO259#005")).setValue(Type.STRING, country).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.streetCounter && this.streetCounter <= 1, "Cardinality {} of Street must be greater or equal 0 and less or equal 1.", this.streetCounter);
            Utils.assertThat(0 <= this.houseNumberCounter && this.houseNumberCounter <= 1, "Cardinality {} of HouseNumber must be greater or equal 0 and less or equal 1.", this.houseNumberCounter);
            Utils.assertThat(0 <= this.zipCodeCounter && this.zipCodeCounter <= 1, "Cardinality {} of ZipCode must be greater or equal 0 and less or equal 1.", this.zipCodeCounter);
            Utils.assertThat(0 <= this.cityTownCounter && this.cityTownCounter <= 1, "Cardinality {} of CityTown must be greater or equal 0 and less or equal 1.", this.cityTownCounter);
            Utils.assertThat(0 <= this.countryCounter && this.countryCounter <= 1, "Cardinality {} of Country must be greater or equal 0 and less or equal 1.", this.countryCounter);
            return super.build();
        }
    }

    public class PCFGoodsAddressHandoverBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int streetCounter;
        private int houseNumberCounter;
        private int zipCodeCounter;
        private int cityTownCounter;
        private int countryCounter;

        protected PCFGoodsAddressHandoverBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("PCFGoodsAddressHandover"), smBuilder);
            this.streetCounter = 0;
            this.houseNumberCounter = 0;
            this.zipCodeCounter = 0;
            this.cityTownCounter = 0;
            this.countryCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#02-ABI498#001"));
        }

        protected PCFGoodsAddressHandoverBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("PCFGoodsAddressHandover", nr)), smBuilder);
            this.streetCounter = 0;
            this.houseNumberCounter = 0;
            this.zipCodeCounter = 0;
            this.cityTownCounter = 0;
            this.countryCounter = 0;
            this.setSemanticId(IdentifierType.irdi("0173-1#02-ABI498#001"));
        }

        public PCFGoodsAddressHandoverBuilder setStreet(String street) {
            ++this.streetCounter;
            this.createPropertyBuilder("Street").setSemanticId(IdentifierType.irdi("0173-1#02-ABH956#001")).setValue(Type.STRING, street).build();
            return this;
        }

        public PCFGoodsAddressHandoverBuilder setHouseNumber(String houseNumber) {
            ++this.houseNumberCounter;
            this.createPropertyBuilder("HouseNumber").setSemanticId(IdentifierType.irdi("0173-1#02-ABH957#001")).setValue(Type.STRING, houseNumber).build();
            return this;
        }

        public PCFGoodsAddressHandoverBuilder setZipCode(String zipCode) {
            ++this.zipCodeCounter;
            this.createPropertyBuilder("ZipCode").setSemanticId(IdentifierType.irdi("0173-1#02-ABH958#001")).setValue(Type.STRING, zipCode).build();
            return this;
        }

        public PCFGoodsAddressHandoverBuilder setCityTown(String cityTown) {
            ++this.cityTownCounter;
            this.createPropertyBuilder("CityTown").setSemanticId(IdentifierType.irdi("0173-1#02-ABH959#001")).setValue(Type.STRING, cityTown).build();
            return this;
        }

        public PCFGoodsAddressHandoverBuilder setCountry(String country) {
            ++this.countryCounter;
            this.createPropertyBuilder("Country").setSemanticId(IdentifierType.irdi("0173-1#02-AAO259#005")).setValue(Type.STRING, country).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.streetCounter && this.streetCounter <= 1, "Cardinality {} of Street must be greater or equal 0 and less or equal 1.", this.streetCounter);
            Utils.assertThat(0 <= this.houseNumberCounter && this.houseNumberCounter <= 1, "Cardinality {} of HouseNumber must be greater or equal 0 and less or equal 1.", this.houseNumberCounter);
            Utils.assertThat(0 <= this.zipCodeCounter && this.zipCodeCounter <= 1, "Cardinality {} of ZipCode must be greater or equal 0 and less or equal 1.", this.zipCodeCounter);
            Utils.assertThat(0 <= this.cityTownCounter && this.cityTownCounter <= 1, "Cardinality {} of CityTown must be greater or equal 0 and less or equal 1.", this.cityTownCounter);
            Utils.assertThat(0 <= this.countryCounter && this.countryCounter <= 1, "Cardinality {} of Country must be greater or equal 0 and less or equal 1.", this.countryCounter);
            return super.build();
        }
    }

    public static enum TCFProcessesForGreenhouseGasEmissionInATransportService {
        WTT(0, "0173-1#07-ABU216#001", "WTT - Well-to-Tank"),
        TTW(0, "0173-1#07-ABU215#001", "TTW - Tank-to-Wheel"),
        WTW(0, "0173-1#07-ABU217#001", "WTW - Well-to-Wheel");

        private int valueId;
        private String semanticId;
        private String value;

        private TCFProcessesForGreenhouseGasEmissionInATransportService(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum TCFReferenceValueForCalculation {
        G(0, "0173-1#07-ABZ596#001", "g"),
        KG(0, "0173-1#07-ABZ597#001", "kg"),
        T(0, "0173-1#07-ABZ598#001", "t"),
        ML(0, "0173-1#07-ABZ599#001", "ml"),
        L(0, "0173-1#07-ABZ600#001", "l"),
        CBM(0, "0173-1#07-ABZ601#001", "cbm"),
        QM(0, "0173-1#07-ABZ602#001", "qm"),
        PIECE(0, "0173-1#07-ABZ603#001", "piece");

        private int valueId;
        private String semanticId;
        private String value;

        private TCFReferenceValueForCalculation(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum TCFCalculationMethod {
        EN_16258(0, "0173-1#07-ABU224#001", "EN 16258");

        private int valueId;
        private String semanticId;
        private String value;

        private TCFCalculationMethod(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PCFLifeCyclePhase {
        A1(0, "0173-1#07-ABU208#001", "A1 - raw material supply (and upstream production)"),
        A2(0, "0173-1#07-ABU209#001", "A2 - cradle-to-gate transport to factory"),
        A3(0, "0173-1#07-ABU210#001", "A3 - production"),
        A4(0, "0173-1#07-ABU211#001", "A4 - transport to final destination"),
        B1(0, "0173-1#07-ABU212#001", "B1 - usage phase"),
        B2(0, "0173-1#07-ABV498#001", "B2 - maintenance"),
        B3(0, "0173-1#07-ABV497#001", "B3 - repair"),
        B6(0, "0173-1#07-ABV500#001", "B6 - usage energy consumption"),
        B7(0, "0173-1#07-ABV501#001", "B7 - usage water consumption"),
        C1(0, "0173-1#07-ABV502#001", "C1 - reassembly"),
        C2(0, "0173-1#07-ABU213#001", "C2 - transport to recycler"),
        C3(0, "0173-1#07-ABV503#001", "C3 - recycling, waste treatment"),
        C4(0, "0173-1#07-ABV504#001", "C4 - landfill"),
        D(0, "0173-1#07-ABU214#001", "D - reuse"),
        A1_A3(0, "0173-1#07-ABZ789#001", "A1-A3");

        private int valueId;
        private String semanticId;
        private String value;

        private PCFLifeCyclePhase(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PCFReferenceValueForCalculation {
        G(0, "0173-1#07-ABZ596#001", "g"),
        KG(0, "0173-1#07-ABZ597#001", "kg"),
        T(0, "0173-1#07-ABZ598#001", "t"),
        ML(0, "0173-1#07-ABZ599#001", "ml"),
        L(0, "0173-1#07-ABZ600#001", "l"),
        CBM(0, "0173-1#07-ABZ601#001", "cbm"),
        QM(0, "0173-1#07-ABZ602#001", "qm"),
        PIECE(0, "0173-1#07-ABZ603#001", "piece");

        private int valueId;
        private String semanticId;
        private String value;

        private PCFReferenceValueForCalculation(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PCFCalculationMethod {
        EN_15804(0, "0173-1#07-ABU223#002", "EN 15804"),
        GHG_PROTOCOL(0, "0173-1#07-ABU221#002", "GHG Protocol"),
        IEC_TS_63058(0, "0173-1#07-ABU222#002", "IEC TS 63058"),
        ISO_14040(0, "0173-1#07-ABV505#002", "ISO 14040"),
        ISO_14044(0, "0173-1#07-ABV506#002", "ISO 14044"),
        ISO_14067(0, "0173-1#07-ABU218#002", "ISO 14067"),
        IEC_63366(0, "0173-1#07-ACA792#001", "IEC 63366"),
        PEP_ECOPASSPORT(0, "0173-1#07-ABU220#002", "PEP Ecopassport");

        private int valueId;
        private String semanticId;
        private String value;

        private PCFCalculationMethod(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }
}

