/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.hierarchicalStructure;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.Entity;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingEntityBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import java.math.BigInteger;

public class HierarchicalStructuresBuilder
extends DelegatingSubmodelBuilder {
    private boolean createMultiLanguageProperties = true;
    private int entryNodeCounter = 0;
    private int archeTypeCounter = 0;

    public HierarchicalStructuresBuilder(Aas.AasBuilder aasBuilder, String identifier) {
        this(aasBuilder, identifier, "HierarchicalStructures");
    }

    public HierarchicalStructuresBuilder(Aas.AasBuilder aasBuilder, String identifier, String idShort) {
        super(aasBuilder.createSubmodelBuilder(idShort, identifier));
        this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/1/0/Submodel"));
    }

    public void setCreateMultiLanguageProperties(boolean createMultiLanguageProperties) {
        this.createMultiLanguageProperties = createMultiLanguageProperties;
    }

    public EntryNodeBuilder createEntryNodeBuilder() {
        ++this.entryNodeCounter;
        return new EntryNodeBuilder(this);
    }

    public HierarchicalStructuresBuilder setArcheType(ArcheType archeType) {
        ++this.archeTypeCounter;
        this.createPropertyBuilder("ArcheType").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/ArcheType/1/0")).setValue(Type.STRING, archeType.getValue()).build();
        return this;
    }

    @Override
    public Submodel build() {
        Utils.assertThat(this.entryNodeCounter == 1, "Cardinality {} of EntryNode must be equal 1.", this.entryNodeCounter);
        Utils.assertThat(this.archeTypeCounter == 1, "Cardinality {} of ArcheType must be equal 1.", this.archeTypeCounter);
        return super.build();
    }

    public class EntryNodeBuilder
    extends DelegatingEntityBuilder {
        private int nodeCounter;
        private int sameAsCounter;
        private int isPartOfCounter;
        private int hasPartCounter;

        protected EntryNodeBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createEntityBuilder("EntryNode", Entity.EntityType.SELFMANAGEDENTITY, null), smBuilder);
            this.nodeCounter = 0;
            this.sameAsCounter = 0;
            this.isPartOfCounter = 0;
            this.hasPartCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/EntryNode/1/0"));
        }

        protected EntryNodeBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createEntityBuilder(Utils.getCountingIdShort("EntryNode", nr), Entity.EntityType.SELFMANAGEDENTITY, null), smBuilder);
            this.nodeCounter = 0;
            this.sameAsCounter = 0;
            this.isPartOfCounter = 0;
            this.hasPartCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/EntryNode/1/0"));
        }

        public NodeBuilder createNodeBuilder() {
            return new NodeBuilder(this, ++this.nodeCounter);
        }

        public EntryNodeBuilder setSameAs(Reference first, Reference second) {
            this.createRelationshipElementBuilder(Utils.getCountingIdShort("SameAs", ++this.sameAsCounter), first, second).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/SameAs/1/0")).build();
            return this;
        }

        public EntryNodeBuilder setIsPartOf(Reference first, Reference second) {
            this.createRelationshipElementBuilder(Utils.getCountingIdShort("IsPartOf", ++this.isPartOfCounter), first, second).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/IsPartOf/1/0")).build();
            return this;
        }

        public EntryNodeBuilder setHasPart(Reference first, Reference second) {
            this.createRelationshipElementBuilder(Utils.getCountingIdShort("HasPart", ++this.hasPartCounter), first, second).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/HasPart/1/0")).build();
            return this;
        }

        @Override
        public Entity build() {
            Utils.assertThat(1 <= this.nodeCounter, "Cardinality {} of Node must be greater or equal 1.", this.nodeCounter);
            Utils.assertThat(0 <= this.sameAsCounter, "Cardinality {} of SameAs must be greater or equal 0.", this.sameAsCounter);
            Utils.assertThat(0 <= this.isPartOfCounter, "Cardinality {} of IsPartOf must be greater or equal 0.", this.isPartOfCounter);
            Utils.assertThat(0 <= this.hasPartCounter, "Cardinality {} of HasPart must be greater or equal 0.", this.hasPartCounter);
            return super.build();
        }
    }

    public static enum ArcheType {
        FULL(0, "", "Full"),
        ONEDOWN(0, "", "OneDown"),
        ONEUP(0, "", "OneUp");

        private int valueId;
        private String semanticId;
        private String value;

        private ArcheType(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }

    public class NodeBuilder
    extends DelegatingEntityBuilder {
        private int nodeCounter;
        private int sameAsCounter;
        private int isPartOfCounter;
        private int hasPartCounter;
        private int bulkCountCounter;

        protected NodeBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createEntityBuilder("Node", Entity.EntityType.SELFMANAGEDENTITY, null), smBuilder);
            this.nodeCounter = 0;
            this.sameAsCounter = 0;
            this.isPartOfCounter = 0;
            this.hasPartCounter = 0;
            this.bulkCountCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/Node/1/0"));
        }

        protected NodeBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createEntityBuilder(Utils.getCountingIdShort("Node", nr), Entity.EntityType.SELFMANAGEDENTITY, null), smBuilder);
            this.nodeCounter = 0;
            this.sameAsCounter = 0;
            this.isPartOfCounter = 0;
            this.hasPartCounter = 0;
            this.bulkCountCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/Node/1/0"));
        }

        public NodeBuilder createNodeBuilder() {
            return new NodeBuilder(this, ++this.nodeCounter);
        }

        public NodeBuilder setSameAs(Reference first, Reference second) {
            this.createRelationshipElementBuilder(Utils.getCountingIdShort("SameAs", ++this.sameAsCounter), first, second).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/SameAs/1/0")).build();
            return this;
        }

        public NodeBuilder setIsPartOf(Reference first, Reference second) {
            this.createRelationshipElementBuilder(Utils.getCountingIdShort("IsPartOf", ++this.isPartOfCounter), first, second).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/IsPartOf/1/0")).build();
            return this;
        }

        public NodeBuilder setHasPart(Reference first, Reference second) {
            this.createRelationshipElementBuilder(Utils.getCountingIdShort("HasPart", ++this.hasPartCounter), first, second).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/HasPart/1/0")).build();
            return this;
        }

        public NodeBuilder setBulkCount(BigInteger bulkCount) {
            ++this.bulkCountCounter;
            this.createPropertyBuilder("BulkCount").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/HierarchicalStructures/BulkCount/1/0")).setValue(Type.UINT64, bulkCount).build();
            return this;
        }

        @Override
        public Entity build() {
            Utils.assertThat(0 <= this.nodeCounter, "Cardinality {} of Node must be greater or equal 0.", this.nodeCounter);
            Utils.assertThat(0 <= this.sameAsCounter, "Cardinality {} of SameAs must be greater or equal 0.", this.sameAsCounter);
            Utils.assertThat(0 <= this.isPartOfCounter, "Cardinality {} of IsPartOf must be greater or equal 0.", this.isPartOfCounter);
            Utils.assertThat(0 <= this.hasPartCounter, "Cardinality {} of HasPart must be greater or equal 0.", this.hasPartCounter);
            Utils.assertThat(0 <= this.bulkCountCounter && this.bulkCountCounter <= 1, "Cardinality {} of BulkCount must be greater or equal 0 and less or equal 1.", this.bulkCountCounter);
            return super.build();
        }
    }
}

