/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.technicaldata;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.MultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodel;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import java.util.Date;
import java.util.concurrent.ExecutionException;

public class TechnicalData
extends DelegatingSubmodel {
    public TechnicalData(Aas aas) {
        super(aas.getSubmodel("TechnicalData"));
    }

    public GeneralInformation getGeneralInformation() {
        return new GeneralInformation(super.getSubmodelElementCollection("GeneralInformation"));
    }

    public ProductClassifications getProductClassifications() {
        return new ProductClassifications(super.getSubmodelElementCollection("ProductClassifications"));
    }

    public TechnicalProperties getTechnicalProperties() {
        return new TechnicalProperties(super.getSubmodelElementCollection("TechnicalProperties"));
    }

    public FurtherInformation getFurtherInformation() {
        return new FurtherInformation(super.getSubmodelElementCollection("FurtherInformation"));
    }

    public static class GeneralInformation
    extends DelegatingSubmodelElementCollection {
        protected GeneralInformation(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getManufacturerNameProperty() {
            return this.getProperty("ManufacturerName");
        }

        public String getManufacturerName() throws ExecutionException {
            return Utils.getStringValue(this, "ManufacturerName");
        }

        public FileDataElement getManufacturerLogoProperty() {
            return (FileDataElement)this.getDataElement("ManufacturerLogo");
        }

        public FileDataElement getManufacturerLogo() throws ExecutionException {
            return Utils.getFileDataElementValue(this, "ManufacturerLogo");
        }

        public MultiLanguageProperty getManufacturerProductDesignationProperty() {
            return (MultiLanguageProperty)this.getDataElement("ManufacturerProductDesignation");
        }

        public LangString[] getManufacturerProductDesignation() throws ExecutionException {
            return Utils.getLangStringValue(this, "ManufacturerProductDesignation");
        }

        public Property getManufacturerArticleNumberProperty() {
            return this.getProperty("ManufacturerArticleNumber");
        }

        public String getManufacturerArticleNumber() throws ExecutionException {
            return Utils.getStringValue(this, "ManufacturerArticleNumber");
        }

        public Property getManufacturerOrderCodeProperty() {
            return this.getProperty("ManufacturerOrderCode");
        }

        public String getManufacturerOrderCode() throws ExecutionException {
            return Utils.getStringValue(this, "ManufacturerOrderCode");
        }

        public FileDataElement getProductImageProperty(int index) {
            return (FileDataElement)this.getDataElement(Utils.getCountingIdShort("ProductImage", index));
        }

        public Iterable<FileDataElement> getProductImage() throws ExecutionException {
            return Utils.collect(this.elements(), FileDataElement.class, IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/ProductImage/1/1"));
        }
    }

    public static class ProductClassifications
    extends DelegatingSubmodelElementCollection {
        protected ProductClassifications(SubmodelElementCollection parent) {
            super(parent);
        }

        public ProductClassificationItem getProductClassificationItem(int index) {
            SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("ProductClassificationItem", index));
            return null == tmp ? null : new ProductClassificationItem(tmp);
        }
    }

    public static class TechnicalProperties
    extends DelegatingSubmodelElementCollection {
        protected TechnicalProperties(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getArbitraryProperty(String idShort, int index) {
            return this.getProperty(Utils.getCountingIdShort(idShort, index));
        }

        public Iterable<String> getArbitrary(String idShort) throws ExecutionException {
            return Utils.collect(this.elements(), Property.class, IdentifierType.iri("https://admin-shell.io/SemanticIdNotAvailable/1/1"), p -> Utils.cast(p, String.class));
        }

        public SubmodelElementCollection getMainSection(int index) {
            return super.getSubmodelElementCollection(Utils.getCountingIdShort("MainSection", index));
        }

        public SubmodelElementCollection getSubSection(int index) {
            return super.getSubmodelElementCollection(Utils.getCountingIdShort("SubSection", index));
        }
    }

    public static class FurtherInformation
    extends DelegatingSubmodelElementCollection {
        protected FurtherInformation(SubmodelElementCollection parent) {
            super(parent);
        }

        public MultiLanguageProperty getTextStatementProperty(int index) {
            return (MultiLanguageProperty)this.getDataElement(Utils.getCountingIdShort("TextStatement", index));
        }

        public Iterable<LangString[]> getTextStatement() throws ExecutionException {
            return Utils.collect(this.elements(), MultiLanguageProperty.class, IdentifierType.iri("https://admin-shell.io/ZVEI/TechnicalData/TextStatement/1/1"), p -> Utils.getLangStringValue(p));
        }

        public Property getValidDateProperty() {
            return this.getProperty("ValidDate");
        }

        public Date getValidDate() throws ExecutionException {
            return Utils.getDateValue(this, "ValidDate");
        }
    }

    public static class ProductClassificationItem
    extends DelegatingSubmodelElementCollection {
        protected ProductClassificationItem(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getProductClassificationSystemProperty() {
            return this.getProperty("ProductClassificationSystem");
        }

        public String getProductClassificationSystem() throws ExecutionException {
            return Utils.getStringValue(this, "ProductClassificationSystem");
        }

        public Property getClassificationSystemVersionProperty() {
            return this.getProperty("ClassificationSystemVersion");
        }

        public String getClassificationSystemVersion() throws ExecutionException {
            return Utils.getStringValue(this, "ClassificationSystemVersion");
        }

        public Property getProductClassIdProperty() {
            return this.getProperty("ProductClassId");
        }

        public String getProductClassId() throws ExecutionException {
            return Utils.getStringValue(this, "ProductClassId");
        }
    }
}

