/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.documentation;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.Entity;
import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.MultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodel;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import de.iip_ecosphere.platform.support.aas.types.documentation.HandoverDocumentationBuilder;
import java.util.Date;
import java.util.concurrent.ExecutionException;

public class HandoverDocumentation
extends DelegatingSubmodel {
    public HandoverDocumentation(Aas aas) {
        super(aas.getSubmodel("HandoverDocumentation"));
    }

    public Document getDocument(int index) {
        SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("Document", index));
        return null == tmp ? null : new Document(tmp);
    }

    public Entity getEntity(int index) {
        return super.getEntity(Utils.getCountingIdShort("Entity", index));
    }

    public static class Document
    extends DelegatingSubmodelElementCollection {
        protected Document(SubmodelElementCollection parent) {
            super(parent);
        }

        public DocumentId getDocumentId(int index) {
            SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("DocumentId", index));
            return null == tmp ? null : new DocumentId(tmp);
        }

        public DocumentClassification getDocumentClassification(int index) {
            SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("DocumentClassification", index));
            return null == tmp ? null : new DocumentClassification(tmp);
        }

        public DocumentVersion getDocumentVersion(int index) {
            SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("DocumentVersion", index));
            return null == tmp ? null : new DocumentVersion(tmp);
        }

        public ReferenceElement getDocumentedEntityProperty(int index) {
            return this.getReferenceElement(Utils.getCountingIdShort("DocumentedEntity", index));
        }

        public Iterable<ReferenceElement> getDocumentedEntity(String semanticId) throws ExecutionException {
            return Utils.collect(this.elements(), ReferenceElement.class, semanticId != null && semanticId.length() > 0 ? semanticId : "<no semId given>");
        }
    }

    public static class DocumentVersion
    extends DelegatingSubmodelElementCollection {
        protected DocumentVersion(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getLanguageProperty(int index) {
            return this.getProperty(Utils.getCountingIdShort("Language", index));
        }

        public Iterable<String> getLanguage() throws ExecutionException {
            return Utils.collect(this.elements(), Property.class, IdentifierType.irdi("0173-1#02-AAN468#006"), p -> Utils.cast(p, String.class));
        }

        public Property getDocumentVersionIdProperty() {
            return this.getProperty("DocumentVersionId");
        }

        public String getDocumentVersionId() throws ExecutionException {
            return Utils.getStringValue(this, "DocumentVersionId");
        }

        public MultiLanguageProperty getTitleProperty() {
            return (MultiLanguageProperty)this.getDataElement("Title");
        }

        public LangString[] getTitle() throws ExecutionException {
            return Utils.getLangStringValue(this, "Title");
        }

        public MultiLanguageProperty getSubTitleProperty() {
            return (MultiLanguageProperty)this.getDataElement("SubTitle");
        }

        public LangString[] getSubTitle() throws ExecutionException {
            return Utils.getLangStringValue(this, "SubTitle");
        }

        public MultiLanguageProperty getSummaryProperty() {
            return (MultiLanguageProperty)this.getDataElement("Summary");
        }

        public LangString[] getSummary() throws ExecutionException {
            return Utils.getLangStringValue(this, "Summary");
        }

        public MultiLanguageProperty getKeyWordsProperty() {
            return (MultiLanguageProperty)this.getDataElement("KeyWords");
        }

        public LangString[] getKeyWords() throws ExecutionException {
            return Utils.getLangStringValue(this, "KeyWords");
        }

        public Property getStatusSetDateProperty() {
            return this.getProperty("StatusSetDate");
        }

        public Date getStatusSetDate() throws ExecutionException {
            return Utils.getDateValue(this, "StatusSetDate");
        }

        public Property getStatusValueProperty() {
            return this.getProperty("StatusValue");
        }

        public HandoverDocumentationBuilder.StatusValue getStatusValue() throws ExecutionException {
            return Utils.getEnumValue(this, "StatusValue", HandoverDocumentationBuilder.StatusValue.class, HandoverDocumentationBuilder.StatusValue.class);
        }

        public Property getOrganizationNameProperty() {
            return this.getProperty("OrganizationName");
        }

        public String getOrganizationName() throws ExecutionException {
            return Utils.getStringValue(this, "OrganizationName");
        }

        public Property getOrganizationOfficialNameProperty() {
            return this.getProperty("OrganizationOfficialName");
        }

        public String getOrganizationOfficialName() throws ExecutionException {
            return Utils.getStringValue(this, "OrganizationOfficialName");
        }

        public FileDataElement getDigitalFileProperty(int index) {
            return (FileDataElement)this.getDataElement(Utils.getCountingIdShort("DigitalFile", index));
        }

        public Iterable<FileDataElement> getDigitalFile(String semanticId) throws ExecutionException {
            return Utils.collect(this.elements(), FileDataElement.class, semanticId != null && semanticId.length() > 0 ? semanticId : IdentifierType.irdi("0173-1#01-AHF583#001"));
        }

        public FileDataElement getPreviewFileProperty(int index) {
            return (FileDataElement)this.getDataElement(Utils.getCountingIdShort("PreviewFile", index));
        }

        public Iterable<FileDataElement> getPreviewFile(String semanticId) throws ExecutionException {
            return Utils.collect(this.elements(), FileDataElement.class, semanticId != null && semanticId.length() > 0 ? semanticId : IdentifierType.irdi("0173-1#01-AHF584#001"));
        }

        public ReferenceElement getRefersToProperty(int index) {
            return this.getReferenceElement(Utils.getCountingIdShort("RefersTo", index));
        }

        public Iterable<ReferenceElement> getRefersTo() throws ExecutionException {
            return Utils.collect(this.elements(), ReferenceElement.class, IdentifierType.irdi("0173-1#02-ABI006#001"));
        }

        public ReferenceElement getBasedOnProperty(int index) {
            return this.getReferenceElement(Utils.getCountingIdShort("BasedOn", index));
        }

        public Iterable<ReferenceElement> getBasedOn() throws ExecutionException {
            return Utils.collect(this.elements(), ReferenceElement.class, IdentifierType.irdi("0173-1#02-ABI007#001"));
        }

        public ReferenceElement getTranslationOfProperty(int index) {
            return this.getReferenceElement(Utils.getCountingIdShort("TranslationOf", index));
        }

        public Iterable<ReferenceElement> getTranslationOf() throws ExecutionException {
            return Utils.collect(this.elements(), ReferenceElement.class, IdentifierType.irdi("0173-1#02-ABI008#001"));
        }
    }

    public static class DocumentClassification
    extends DelegatingSubmodelElementCollection {
        protected DocumentClassification(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getClassIdProperty() {
            return this.getProperty("ClassId");
        }

        public String getClassId() throws ExecutionException {
            return Utils.getStringValue(this, "ClassId");
        }

        public MultiLanguageProperty getClassNameProperty() {
            return (MultiLanguageProperty)this.getDataElement("ClassName");
        }

        public LangString[] getClassName() throws ExecutionException {
            return Utils.getLangStringValue(this, "ClassName");
        }

        public Property getClassificationSystemProperty() {
            return this.getProperty("ClassificationSystem");
        }

        public String getClassificationSystem() throws ExecutionException {
            return Utils.getStringValue(this, "ClassificationSystem");
        }
    }

    public static class DocumentId
    extends DelegatingSubmodelElementCollection {
        protected DocumentId(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getDocumentDomainIdProperty() {
            return this.getProperty("DocumentDomainId");
        }

        public String getDocumentDomainId() throws ExecutionException {
            return Utils.getStringValue(this, "DocumentDomainId");
        }

        public Property getValueIdProperty() {
            return this.getProperty("ValueId");
        }

        public String getValueId() throws ExecutionException {
            return Utils.getStringValue(this, "ValueId");
        }

        public Property getIsPrimaryProperty() {
            return this.getProperty("IsPrimary");
        }

        public boolean getIsPrimary() throws ExecutionException {
            return Utils.getBooleanValue(this, "IsPrimary");
        }
    }
}

