/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.AssetInformation;
import de.iip_ecosphere.platform.support.aas.BlobDataElement;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.Entity;
import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.MultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Range;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.RelationshipElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;

public class AasPrintVisitor
implements AasVisitor {
    private String indentation = "";
    private PrintStream out;
    private Predicate<Aas> aasPredicate = a -> true;
    private Predicate<Submodel> submodelPredicate = s -> true;
    private Predicate<SubmodelElementCollection> submodelElementCollectionPredicate = c -> true;
    private Predicate<SubmodelElementList> submodelElementListPredicate = l -> true;
    private Predicate<Entity> entityPredicate = e -> true;

    public AasPrintVisitor() {
        this(null);
    }

    public AasPrintVisitor(PrintStream out) {
        this.out = null == out ? System.out : out;
    }

    private void increaseIndentation() {
        this.indentation = this.indentation + " ";
    }

    private void decreaseIndentation() {
        if (this.indentation.length() > 0) {
            this.indentation = this.indentation.substring(0, this.indentation.length() - 1);
        }
    }

    private void log(String text) {
        this.out.println(this.indentation + text);
    }

    @Override
    public boolean visitAas(Aas aas) {
        this.log("AAS " + aas.getIdShort() + " [" + aas.getIdentification() + "]");
        this.increaseIndentation();
        return this.aasPredicate.test(aas);
    }

    @Override
    public void endAas(Aas aas) {
        this.decreaseIndentation();
    }

    @Override
    public void visitAsset(AssetInformation asset) {
        this.log("ASSET " + asset.getIdShort() + " " + String.valueOf((Object)asset.getAssetKind()));
    }

    @Override
    public boolean visitSubmodel(Submodel submodel) {
        this.log("SUBMODEL " + submodel.getIdShort() + " [" + submodel.getIdentification() + "]");
        this.increaseIndentation();
        return this.submodelPredicate.test(submodel);
    }

    @Override
    public void endSubmodel(Submodel submodel) {
        this.decreaseIndentation();
    }

    @Override
    public void visitProperty(Property property) {
        String value;
        try {
            value = String.valueOf(property.getValue());
        }
        catch (ExecutionException e) {
            value = "?";
        }
        Object semId = property.getSemanticId();
        semId = null == semId ? "" : " (semanticId: " + (String)semId + ")";
        this.log("PROPERTY " + property.getIdShort() + " = " + value + (String)semId);
    }

    @Override
    public void visitOperation(Operation operation) {
        this.log("OPERATION " + operation.getIdShort() + " #args " + operation.getArgsCount());
    }

    @Override
    public void visitReferenceElement(ReferenceElement referenceElement) {
        this.log("REFERENCE " + referenceElement.getIdShort() + " = " + String.valueOf(referenceElement.getValue()));
    }

    @Override
    public boolean visitSubmodelElementCollection(SubmodelElementCollection collection) {
        this.log("COLLECTION " + collection.getIdShort());
        this.increaseIndentation();
        return this.submodelElementCollectionPredicate.test(collection);
    }

    @Override
    public void endSubmodelElementCollection(SubmodelElementCollection collection) {
        this.decreaseIndentation();
    }

    @Override
    public boolean visitSubmodelElementList(SubmodelElementList list) {
        this.log("LIST " + list.getIdShort());
        this.increaseIndentation();
        return this.submodelElementListPredicate.test(list);
    }

    @Override
    public void endSubmodelElementList(SubmodelElementList list) {
        this.decreaseIndentation();
    }

    @Override
    public void visitDataElement(DataElement dataElement) {
        this.log("DATAELT " + dataElement.getIdShort());
    }

    @Override
    public void visitFileDataElement(FileDataElement dataElement) {
        this.log("FILEDATAELT " + dataElement.getIdShort());
    }

    @Override
    public void visitRange(Range range) {
        this.log("RANGE " + String.valueOf(range.getMin()) + " " + String.valueOf(range.getMax()));
    }

    @Override
    public void visitBlobDataElement(BlobDataElement dataElement) {
        this.log("BLOBDATAELT " + dataElement.getIdShort());
    }

    @Override
    public void visitMultiLanguageProperty(MultiLanguageProperty property) {
        this.log("MLP " + property.getIdShort());
    }

    @Override
    public void visitRelationshipElement(RelationshipElement relationship) {
        this.log("RELATIONSHIP " + relationship.getIdShort());
    }

    @Override
    public boolean visitEntity(Entity entity) {
        this.log("ENTITY " + entity.getIdShort());
        this.increaseIndentation();
        return this.entityPredicate.test(entity);
    }

    @Override
    public void endVisitEntity(Entity entity) {
        this.decreaseIndentation();
    }

    public AasPrintVisitor setAasPredicate(Predicate<Aas> aasPredicate) {
        if (null != aasPredicate) {
            this.aasPredicate = aasPredicate;
        }
        return this;
    }

    public AasPrintVisitor setEntityPredicate(Predicate<Entity> entityPredicate) {
        if (null != entityPredicate) {
            this.entityPredicate = entityPredicate;
        }
        return this;
    }

    public AasPrintVisitor setSubmodelPredicate(Predicate<Submodel> submodelPredicate) {
        if (null != submodelPredicate) {
            this.submodelPredicate = submodelPredicate;
        }
        return this;
    }

    public AasPrintVisitor setSubmodelElementCollectionPredicate(Predicate<SubmodelElementCollection> submodelElementCollectionPredicate) {
        if (null != submodelElementCollectionPredicate) {
            this.submodelElementCollectionPredicate = submodelElementCollectionPredicate;
        }
        return this;
    }

    public AasPrintVisitor setSubmodelElementListPredicate(Predicate<SubmodelElementList> submodelElementListPredicate) {
        if (null != submodelElementListPredicate) {
            this.submodelElementListPredicate = submodelElementListPredicate;
        }
        return this;
    }
}

