/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.LocalNetworkManagerImpl;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerDescriptor;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;

public class NetworkManagerFactory {
    public static final String PROPERTY = "iip.networkManager";
    private static NetworkManager instance;

    public static Optional<NetworkManagerDescriptor> getDescriptor() {
        Optional first = NetworkManagerFactory.loadFromProperty();
        if (first.isEmpty()) {
            first = ServiceLoaderUtils.findFirst(NetworkManagerDescriptor.class);
        }
        return first;
    }

    public static NetworkManager getInstance() {
        if (null == instance) {
            Optional<NetworkManagerDescriptor> first = NetworkManagerFactory.getDescriptor();
            if (first.isPresent()) {
                instance = first.get().createInstance();
                if (null != instance) {
                    System.setProperty(PROPERTY, first.get().getClass().getName());
                    NetworkManagerFactory.getLogger().info("Network manager implementation registered: {}", (Object)instance.getClass().getName());
                }
            } else {
                NetworkManagerFactory.getLogger().warn("No Network manager descriptor/implementation known. Falling back to local network manager.");
                instance = new LocalNetworkManagerImpl();
            }
        }
        return instance;
    }

    public static Optional<NetworkManagerDescriptor> loadFromProperty() {
        String mgrProperty = System.getProperty(PROPERTY);
        Optional<NetworkManagerDescriptor> result = Optional.empty();
        if (null != mgrProperty) {
            try {
                Class<?> cls = Class.forName(mgrProperty);
                if (NetworkManagerDescriptor.class.isAssignableFrom(cls)) {
                    result = Optional.of((NetworkManagerDescriptor)NetworkManagerDescriptor.class.cast(cls.getConstructor(new Class[0]).newInstance(new Object[0])));
                }
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                NetworkManagerFactory.getLogger().warn("Cannot instantiate {} as network manager: {}", (Object)mgrProperty, (Object)e.getMessage());
            }
        }
        return result;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(NetworkManagerFactory.class);
    }

    public static void configure(NetworkManagerSetup setup) {
        NetworkManager mgr = NetworkManagerFactory.getInstance();
        if (null != mgr && null != setup) {
            mgr.configure(setup);
        }
    }
}

