/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.rls.RlsProtoData;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;

final class RlsRequestFactory {
    private final String target;
    private final Table<String, String, RlsProtoData.NameMatcher> keyBuilderTable;

    RlsRequestFactory(RlsProtoData.RouteLookupConfig rlsConfig, String target) {
        Preconditions.checkNotNull((Object)rlsConfig, (Object)"rlsConfig");
        this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.keyBuilderTable = RlsRequestFactory.createKeyBuilderTable(rlsConfig);
    }

    private static Table<String, String, RlsProtoData.NameMatcher> createKeyBuilderTable(RlsProtoData.RouteLookupConfig config) {
        HashBasedTable table = HashBasedTable.create();
        for (RlsProtoData.GrpcKeyBuilder grpcKeyBuilder : config.getGrpcKeyBuilders()) {
            for (RlsProtoData.NameMatcher nameMatcher : grpcKeyBuilder.getHeaders()) {
                for (RlsProtoData.GrpcKeyBuilder.Name name : grpcKeyBuilder.getNames()) {
                    String method = name.getMethod() == null || name.getMethod().isEmpty() ? "*" : name.getMethod();
                    String path = "/" + name.getService() + "/" + method;
                    table.put((Object)path, (Object)nameMatcher.getKey(), (Object)nameMatcher);
                }
            }
        }
        return table;
    }

    @CheckReturnValue
    RlsProtoData.RouteLookupRequest create(String service, String method, Metadata metadata) {
        Preconditions.checkNotNull((Object)service, (Object)"service");
        Preconditions.checkNotNull((Object)method, (Object)"method");
        String path = "/" + service + "/" + method;
        Map keyBuilder = this.keyBuilderTable.row((Object)path);
        if (keyBuilder.isEmpty()) {
            keyBuilder = this.keyBuilderTable.row((Object)("/" + service + "/*"));
        }
        Map<String, String> rlsRequestHeaders = this.createRequestHeaders(metadata, keyBuilder);
        return new RlsProtoData.RouteLookupRequest(this.target, path, "grpc", rlsRequestHeaders);
    }

    private Map<String, String> createRequestHeaders(Metadata metadata, Map<String, RlsProtoData.NameMatcher> keyBuilder) {
        HashMap<String, String> rlsRequestHeaders = new HashMap<String, String>();
        for (Map.Entry<String, RlsProtoData.NameMatcher> entry : keyBuilder.entrySet()) {
            String requestHeaderName;
            RlsProtoData.NameMatcher nameMatcher = entry.getValue();
            String value = null;
            UnmodifiableIterator unmodifiableIterator = nameMatcher.names().iterator();
            while (unmodifiableIterator.hasNext() && (value = (String)metadata.get(Metadata.Key.of((String)(requestHeaderName = (String)unmodifiableIterator.next()), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER))) == null) {
            }
            if (value != null) {
                rlsRequestHeaders.put(entry.getKey(), value);
                continue;
            }
            if (nameMatcher.isOptional()) continue;
            throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription(String.format("Missing mandatory metadata(%s) not found", entry.getKey())));
        }
        return rlsRequestHeaders;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("keyBuilderTable", this.keyBuilderTable).toString();
    }
}

