/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.io.ByteStreams;
import io.grpc.ExperimentalApi;
import io.grpc.ServerCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7621")
public final class TlsServerCredentials
extends ServerCredentials {
    private final boolean fakeFeature;
    private final byte[] certificateChain;
    private final byte[] privateKey;
    private final String privateKeyPassword;

    public static ServerCredentials create(File certChain, File privateKey) throws IOException {
        return TlsServerCredentials.newBuilder().keyManager(certChain, privateKey).build();
    }

    public static ServerCredentials create(InputStream certChain, InputStream privateKey) throws IOException {
        return TlsServerCredentials.newBuilder().keyManager(certChain, privateKey).build();
    }

    TlsServerCredentials(Builder builder) {
        this.fakeFeature = builder.fakeFeature;
        this.certificateChain = builder.certificateChain;
        this.privateKey = builder.privateKey;
        this.privateKeyPassword = builder.privateKeyPassword;
    }

    public byte[] getCertificateChain() {
        return Arrays.copyOf(this.certificateChain, this.certificateChain.length);
    }

    public byte[] getPrivateKey() {
        return Arrays.copyOf(this.privateKey, this.privateKey.length);
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public Set<Feature> incomprehensible(Set<Feature> understoodFeatures) {
        EnumSet<Feature> incomprehensible = EnumSet.noneOf(Feature.class);
        if (this.fakeFeature) {
            TlsServerCredentials.requiredFeature(understoodFeatures, incomprehensible, Feature.FAKE);
        }
        return Collections.unmodifiableSet(incomprehensible);
    }

    private static void requiredFeature(Set<Feature> understoodFeatures, Set<Feature> incomprehensible, Feature feature) {
        if (!understoodFeatures.contains((Object)feature)) {
            incomprehensible.add(feature);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7621")
    public static final class Builder {
        private boolean fakeFeature;
        private byte[] certificateChain;
        private byte[] privateKey;
        private String privateKeyPassword;

        private Builder() {
        }

        public Builder requireFakeFeature() {
            this.fakeFeature = true;
            return this;
        }

        public Builder keyManager(File certChain, File privateKey) throws IOException {
            return this.keyManager(certChain, privateKey, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder keyManager(File certChain, File privateKey, String privateKeyPassword) throws IOException {
            try (FileInputStream certChainIs = new FileInputStream(certChain);){
                Builder builder;
                FileInputStream privateKeyIs = new FileInputStream(privateKey);
                try {
                    builder = this.keyManager(certChainIs, privateKeyIs, privateKeyPassword);
                }
                catch (Throwable throwable) {
                    ((InputStream)privateKeyIs).close();
                    throw throwable;
                }
                ((InputStream)privateKeyIs).close();
                return builder;
            }
        }

        public Builder keyManager(InputStream certChain, InputStream privateKey) throws IOException {
            return this.keyManager(certChain, privateKey, null);
        }

        public Builder keyManager(InputStream certChain, InputStream privateKey, String privateKeyPassword) throws IOException {
            byte[] certChainBytes = ByteStreams.toByteArray((InputStream)certChain);
            byte[] privateKeyBytes = ByteStreams.toByteArray((InputStream)privateKey);
            this.certificateChain = certChainBytes;
            this.privateKey = privateKeyBytes;
            this.privateKeyPassword = privateKeyPassword;
            return this;
        }

        public ServerCredentials build() {
            if (this.certificateChain == null) {
                throw new IllegalStateException("A key manager is required");
            }
            return new TlsServerCredentials(this);
        }
    }

    public static enum Feature {
        FAKE;

    }
}

